/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice;

import be.iminds.ilabt.jfed.experimenter_gui.util.ImageUtil;
import be.iminds.ilabt.jfed.rspec.model.IPv4;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXAddressPool;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import java.util.Map;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.VBox;
import org.controlsfx.glyphfont.FontAwesome;

public class AddressPoolPropertiesDialog
extends Dialog<ButtonType> {
    private final TableView<IPv4> addressesTableView;
    private final TableColumn<IPv4, String> addressTableColumn;
    private final TableColumn<IPv4, String> netmaskTableColumn;
    private final FXAddressPool addressPool;

    public AddressPoolPropertiesDialog(FXAddressPool addressPool) {
        this.addressPool = addressPool;
        this.setTitle(String.format("Address pool '%s'", addressPool.getClientId()));
        this.setHeaderText(this.getTitle());
        this.setGraphic((Node)new ImageView(new Image(ImageUtil.class.getResource("/images/node_types/64/addresspool.png").toExternalForm())));
        this.addressTableColumn = new TableColumn("IP Address");
        this.addressTableColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((IPv4)param.getValue()).getAddress()));
        this.netmaskTableColumn = new TableColumn("Netmask");
        this.netmaskTableColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((IPv4)param.getValue()).getNetmask()));
        this.addressesTableView = new TableView();
        this.addressesTableView.getColumns().add(this.addressTableColumn);
        this.addressesTableView.getColumns().add(this.netmaskTableColumn);
        this.addressTableColumn.prefWidthProperty().bind((ObservableValue)this.addressesTableView.widthProperty().divide(2).subtract(1));
        this.netmaskTableColumn.prefWidthProperty().bind((ObservableValue)this.addressesTableView.widthProperty().divide(2).subtract(1));
        this.addressesTableView.setRowFactory(param -> {
            TableRow iPv4TableRow = new TableRow();
            MenuItem copyAddressMenuItem = new MenuItem("Copy IP Address");
            copyAddressMenuItem.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.COPY));
            copyAddressMenuItem.setOnAction(actionEvent -> {
                ClipboardContent content = new ClipboardContent();
                content.putString(((IPv4)iPv4TableRow.getItem()).getAddress());
                Clipboard.getSystemClipboard().setContent((Map)content);
            });
            MenuItem copyNetmaskMenuItem = new MenuItem("Copy Netmask");
            copyNetmaskMenuItem.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.COPY));
            copyNetmaskMenuItem.setOnAction(actionEvent -> {
                ClipboardContent content = new ClipboardContent();
                content.putString(((IPv4)iPv4TableRow.getItem()).getNetmask());
                Clipboard.getSystemClipboard().setContent((Map)content);
            });
            ContextMenu contextMenu = new ContextMenu(new MenuItem[]{copyAddressMenuItem, copyNetmaskMenuItem});
            iPv4TableRow.setContextMenu(contextMenu);
            return iPv4TableRow;
        });
        this.addressesTableView.setItems(addressPool.getIPv4s());
        this.addressesTableView.setPrefWidth(300.0);
        this.addressesTableView.prefHeightProperty().bind((ObservableValue)Bindings.size((ObservableList)this.addressesTableView.getItems()).multiply(30).add(35));
        VBox rootPane = new VBox(5.0);
        rootPane.setPadding(new Insets(5.0));
        rootPane.getChildren().add(this.addressesTableView);
        this.getDialogPane().setContent((Node)rootPane);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK});
    }
}

