/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice;

import be.iminds.ilabt.jfed.experiment.CapabilityChecker;
import be.iminds.ilabt.jfed.experiment.SshConnectionPoolFactory;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.DialogsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.EditSshKeysDialog;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.OpenESpecDialog;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.RunSshCommandDialog;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.ExperimentActionsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.EditSshKeysEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.ExportToolsConfigFilesEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.FixSshKeysEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.RebootExperimentEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.RenewExperimentEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.RerunEspecEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.RunSshCommandEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.SCPEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.SaveExperimentEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.SaveExperimentInfoJsonEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.ShareExperimentEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.TerminateExperimentEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.TestLinkEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.UnshareExperimentEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.UpdateExperimentEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.scp.SCPDownloadTask;
import be.iminds.ilabt.jfed.experimenter_gui.slice.scp.SCPUploadTask;
import be.iminds.ilabt.jfed.experimenter_gui.util.DateTimeUtils;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.Pair;
import com.google.common.base.Joiner;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ExperimentEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimentEventHandler.class);
    private final EventBus eventBus;
    private final Provider<OpenESpecDialog> openESpecDialogProvider;
    private final Provider<RunSshCommandDialog> runSshCommandDialogProvider;
    private final DialogsFactory dialogsFactory;
    private final ExperimentActionsFactory experimentActionsFactory;
    private final Provider<SshConnectionPoolFactory> sshConnectionPoolFactoryProvider;
    private final CapabilityChecker capabilityChecker;
    private final JFedHLPreferences jFedPreferences;
    private final SfaModel sfaModel;
    private final GeniUserProvider geniUserProvider;

    @Inject
    public ExperimentEventHandler(EventBus eventBus, DialogsFactory dialogsFactory, ExperimentActionsFactory experimentActionsFactory, Provider<SshConnectionPoolFactory> sshConnectionPoolFactoryProvider, Provider<OpenESpecDialog> openESpecDialogProvider, Provider<RunSshCommandDialog> runSshCommandDialogProvider, CapabilityChecker capabilityChecker, JFedHLPreferences jFedPreferences, SfaModel sfaModel, GeniUserProvider geniUserProvider) {
        this.eventBus = eventBus;
        this.dialogsFactory = dialogsFactory;
        this.experimentActionsFactory = experimentActionsFactory;
        this.sshConnectionPoolFactoryProvider = sshConnectionPoolFactoryProvider;
        this.openESpecDialogProvider = openESpecDialogProvider;
        this.runSshCommandDialogProvider = runSshCommandDialogProvider;
        this.capabilityChecker = capabilityChecker;
        this.jFedPreferences = jFedPreferences;
        this.sfaModel = sfaModel;
        this.geniUserProvider = geniUserProvider;
    }

    @Subscribe
    public void handleUpdateExperimentEvent(UpdateExperimentEvent updateExperimentEvent) {
        updateExperimentEvent.getExperimentController().requestUpdate();
    }

    @Subscribe
    public void handleTerminateExperimentEvent(TerminateExperimentEvent event) {
        this.dialogsFactory.showTerminateSliceDialog(event.getParentWindow(), event.getExperimentController());
    }

    @Subscribe
    public void handleRenewExperimentEvent(RenewExperimentEvent event) {
        Slice slice = event.getExperimentController().getExperiment().getSliceOrNull();
        if (slice == null) {
            throw new IllegalStateException("Attempted to renew when slice == null");
        }
        assert (slice.getExpirationDate() != null);
        Instant sliceExpirationTime = slice.getExpirationDate();
        if (sliceExpirationTime != null && sliceExpirationTime.isBefore(Instant.now())) {
            JFDialogs.create().owner(event.getParentWindow()).message(String.format("The experiment %s has expired on %s. It can therefore not be renewed again.", slice.getName(), DateTimeUtils.DATE_HOUR_MINUTES_FORMATTER.format(LocalDateTime.ofInstant(sliceExpirationTime, ZoneId.systemDefault())))).masthead("Experiment has expired").title("Experiment has expired").showError();
        } else {
            this.dialogsFactory.showRenewSliceDialog(event.getParentWindow(), event.getExperimentController());
        }
    }

    @Subscribe
    public void handleRebootExperimentEvent(RebootExperimentEvent event) {
        this.dialogsFactory.showRebootDialog(event.getParentWindow(), event.getExperimentController());
    }

    @Subscribe
    public void handleFixSshKeysEvent(FixSshKeysEvent event) {
        Pair<Boolean, List<String>> help = EditSshKeysDialog.findUnsupportedAuthorityNames(event.getExperimentController(), this.capabilityChecker);
        List unsupportedAuthorityNames = (List)help.getValue();
        boolean supported = (Boolean)help.getKey();
        if (!supported) {
            JFDialogs.create().owner(event.getParentWindow()).message("Fixing SSH-keys is not supported for this experiment").masthead("SSH-keys fix not supported").title("Not supported").showError();
            return;
        }
        if (!unsupportedAuthorityNames.isEmpty()) {
            JFDialogs.create().owner(event.getParentWindow()).message("\n- " + Joiner.on((String)", ").join((Iterable)unsupportedAuthorityNames) + (unsupportedAuthorityNames.size() == 1 ? " does" : " do") + " not support fixing/editing SSH-keys. Will fix SSH-keys only on others.").masthead("SSH-keys fix not supported everywhere").title("Not fully supported").showWarning();
        }
        try {
            List<UserSpec> userspecs = EditSshKeysDialog.getBestCurrentUserSpec(this.sfaModel, this.jFedPreferences, this.geniUserProvider, event.getExperimentController().getExperiment().getSlice());
            event.getExperimentController().updateSshKeys(userspecs);
        }
        catch (Exception e) {
            LOG.error("Something went wrong trying to fix SSH keys: " + e.getMessage(), (Throwable)e);
            JFDialogs.create().owner(event.getParentWindow()).message("Something went wrong trying to fix SSH keys: " + e.getMessage()).masthead("Failed to fix").title("Error").showError();
        }
    }

    @Subscribe
    public void handleEditSshKeysEvent(EditSshKeysEvent event) {
        this.dialogsFactory.showEditSshKeysDialog(event.getParentWindow(), event.getExperimentController());
    }

    @Subscribe
    public void handleShareExperimentEvent(ShareExperimentEvent event) {
        this.dialogsFactory.showShareSliceDialog(event.getParentWindow(), event.getExperimentController());
    }

    @Subscribe
    public void handleUnshareExperimentEvent(UnshareExperimentEvent event) {
        this.dialogsFactory.showUnshareSliceDialog(event.getParentWindow(), event.getExperimentController());
    }

    @Subscribe
    public void handleTestLinkEvent(TestLinkEvent event) {
        event.getExperimentController().testLinks();
    }

    @Subscribe
    public void handleRerunEspecEvent(RerunEspecEvent event) {
        OpenESpecDialog dialog = (OpenESpecDialog)((Object)this.openESpecDialogProvider.get());
        dialog.initOwner(event.getParentWindow());
        dialog.setExperimentController(event.getExperimentController());
        dialog.show();
    }

    @Subscribe
    public void handleRunSshCommandEvent(RunSshCommandEvent event) {
        RunSshCommandDialog dialog = (RunSshCommandDialog)((Object)this.runSshCommandDialogProvider.get());
        dialog.initOwner(event.getParentWindow());
        dialog.setExperimentController(event.getExperimentController());
        dialog.show();
    }

    @Subscribe
    public void handleSaveExperimentEvent(SaveExperimentEvent event) {
        this.experimentActionsFactory.createSaveManifestAction(event.getExperimentViewController(), event.isSaveToCsv()).run();
    }

    @Subscribe
    public void handleSaveExperimentInfoJsonEvent(SaveExperimentInfoJsonEvent event) {
        this.experimentActionsFactory.createSaveExperimentInfoJsonAction(event.getExperimentViewController()).run();
    }

    @Subscribe
    public void handleExportToolsConfigFilesEvent(ExportToolsConfigFilesEvent event) {
        this.experimentActionsFactory.createExportToolsConfigFilesAction(event.getParentWindow(), event.getExperimentViewController()).run();
    }

    @Subscribe
    public void handleScpEvent(SCPEvent event) {
        if (event.isUpload()) {
            this.eventBus.post((Object)new SCPUploadTask(event.getExperiment(), event.getNode(), event.getFrom(), event.getTo(), (SshConnectionPoolFactory)this.sshConnectionPoolFactoryProvider.get()));
        } else {
            this.eventBus.post((Object)new SCPDownloadTask(event.getExperiment(), event.getNode(), event.getFrom(), event.getTo(), (SshConnectionPoolFactory)this.sshConnectionPoolFactoryProvider.get()));
        }
    }
}

