/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.experiment.util.NextExperimentExpiration;
import be.iminds.ilabt.jfed.experiment.util.NextExperimentExpirationBinding;
import be.iminds.ilabt.jfed.experimenter_gui.util.DateTimeUtils;
import be.iminds.ilabt.jfed.highlevel.util.SliceRunDuration;
import java.time.Instant;
import java.time.ZoneId;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.util.Duration;

public class ExperimentStatusProperty
extends StringBinding {
    private final Experiment experiment;
    private final NextExperimentExpirationBinding nextExperimentExpirationBinding;
    private final Timeline expirationTickerTimeline;

    public ExperimentStatusProperty(Experiment experiment) {
        this.experiment = experiment;
        this.nextExperimentExpirationBinding = new NextExperimentExpirationBinding(experiment);
        this.bind(new Observable[]{this.nextExperimentExpirationBinding});
        this.expirationTickerTimeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, actionEvent -> this.invalidate(), new KeyValue[0]), new KeyFrame(new Duration(1000.0), new KeyValue[0])});
        this.expirationTickerTimeline.setCycleCount(-1);
        this.expirationTickerTimeline.play();
    }

    private String composeReservationStartMessage() {
        assert (this.experiment.getRequestedStartTime() != null && !this.experiment.getRequestedStartTime().isBefore(Instant.now()));
        java.time.Duration duration = java.time.Duration.between(Instant.now(), this.experiment.getRequestedStartTime()).withNanos(0);
        return String.format("The reservation for this experiment run will start on %s. It will start in %s.", DateTimeUtils.DATE_HOUR_MINUTES_FORMATTER.format(this.experiment.getRequestedStartTime().atZone(ZoneId.systemDefault())), DateTimeUtils.prettyPrintDuration(duration));
    }

    private String composeExpirationMessage() {
        SliceRunDuration sliceRunDuration = new SliceRunDuration(this.experiment);
        NextExperimentExpiration nextExperimentExpiration = (NextExperimentExpiration)this.nextExperimentExpirationBinding.get();
        if (nextExperimentExpiration == null || nextExperimentExpiration.getFirstExpirationTime() == null) {
            return "";
        }
        StringBuilder message = new StringBuilder();
        if (nextExperimentExpiration.getFirstExpiringPart() == null) {
            message.append("This experiment run");
        } else {
            message.append("The resources on ").append(nextExperimentExpiration.getFirstExpiringPart().getName());
        }
        if (nextExperimentExpiration.getFirstExpirationTime().isAfter(Instant.now())) {
            java.time.Duration duration = java.time.Duration.between(Instant.now(), nextExperimentExpiration.getFirstExpirationTime()).withNanos(0);
            message.append(" will expire in ").append(DateTimeUtils.prettyPrintDuration(duration)).append(".");
            if (this.experiment.getExperimentState() == ExperimentState.EMPTY) {
                message.append(" (currently no resources active)");
            }
            if (sliceRunDuration.isLongRunning(false) && sliceRunDuration.willExpireSoon(nextExperimentExpiration.getFirstExpirationTime(), false)) {
                message.append(" Make sure you RENEW in time!");
            }
        } else if (nextExperimentExpiration.getFirstExpiringPart() == null) {
            message.append(" has EXPIRED!");
        } else {
            message.append(" have EXPIRED!");
        }
        return message.toString();
    }

    protected String computeValue() {
        if (this.experiment.getRequestedStartTime() != null && this.experiment.getRequestedStartTime().isAfter(Instant.now())) {
            return this.composeReservationStartMessage();
        }
        return this.composeExpirationMessage();
    }
}

