/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice;

import be.iminds.ilabt.jfed.espec.filefetcher.ESpecFileFetchException;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentChangeListener;
import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experiment.ExperimentControllerListener;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.events.ExperimentPartsEvent;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.experiment.tasks.TaskExecutionFinishedListener;
import be.iminds.ilabt.jfed.experiment.util.ExperimentUtils;
import be.iminds.ilabt.jfed.experiment.util.NextExperimentExpiration;
import be.iminds.ilabt.jfed.experimenter_gui.call_gui.TasksWindow;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.slice.CustomStateDetailsView;
import be.iminds.ilabt.jfed.experimenter_gui.slice.DetailsTabHost;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentStatusProperty;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentViewsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ExpirationNotifier;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ModelSliceView;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ProgressItemCustomDetailsViews;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ansible.AnsibleOutputTab;
import be.iminds.ilabt.jfed.experimenter_gui.slice.errors.ErrorDialogs;
import be.iminds.ilabt.jfed.experimenter_gui.slice.errors.ErrorsView;
import be.iminds.ilabt.jfed.experimenter_gui.slice.errors.ErrorsViewTab;
import be.iminds.ilabt.jfed.experimenter_gui.slice.espec.model.ESpecLogModel;
import be.iminds.ilabt.jfed.experimenter_gui.slice.espec.view.ESpecTab;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.RenewExperimentEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.jobs.ExperimenterJobFactory;
import be.iminds.ilabt.jfed.experimenter_gui.slice.progress.ProgressItem;
import be.iminds.ilabt.jfed.experimenter_gui.slice.progress.ProgressView;
import be.iminds.ilabt.jfed.experimenter_gui.slice.progress.ProgressViewTab;
import be.iminds.ilabt.jfed.experimenter_gui.slice.raw.RawSliceView;
import be.iminds.ilabt.jfed.experimenter_gui.slice.scp.SCPTab;
import be.iminds.ilabt.jfed.experimenter_gui.slice.scp.SCPTask;
import be.iminds.ilabt.jfed.experimenter_gui.ui.status.TaskStatusIndicator;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.experimenter_gui.util.DateTimeUtils;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.highlevel.jobs.AbstractJob;
import be.iminds.ilabt.jfed.highlevel.jobs.AllocateExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.MultipleCallState;
import be.iminds.ilabt.jfed.highlevel.jobs.OpenConsoleJob;
import be.iminds.ilabt.jfed.highlevel.jobs.RenewJob;
import be.iminds.ilabt.jfed.highlevel.jobs.SingleCallState;
import be.iminds.ilabt.jfed.highlevel.jobs.SlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.jobs.StateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.TestLinksJob;
import be.iminds.ilabt.jfed.highlevel.jobs.states.ExecuteAnsibleServicesState;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.util.ExpirationChecker;
import be.iminds.ilabt.jfed.highlevel.util.SliceRunDuration;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.ThreadFactoryUtil;
import be.iminds.ilabt.jfed.util.common.TimeUtil;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SplitPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Provider;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentViewController
extends SplitPane
implements ExperimentChangeListener,
ExperimentControllerListener,
DetailsTabHost {
    private static final Logger LOG = LoggerFactory.getLogger(ExperimentViewController.class);
    private static final ListeningExecutorService jobExecutorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(ThreadFactoryUtil.getFactory((String)"ViewJobExecutor")));
    @Nonnull
    private final TasksWindow tasksWindow;
    @Nonnull
    private final JFedHLPreferences jFedPreferences;
    @Nonnull
    private final JFedGuiConfig jFedGuiConfig;
    @Nonnull
    private final EventBus eventBus;
    @Nonnull
    private final ProgressItemCustomDetailsViews progressItemCustomViews;
    @Nonnull
    private final BrowserUtil browserUtil;
    @Nonnull
    private final ExperimenterJobFactory experimenterJobFactory;
    @Nonnull
    private final ModelSliceView modelSliceView;
    @Nonnull
    private final RawSliceView rawSliceView;
    @Nonnull
    private final TabPane detailsTabPane;
    @Nonnull
    private final ProgressView progressView;
    @Nonnull
    private final ErrorsView errorsView;
    @Nullable
    private final ESpecLogModel eSpecLogModel;
    @Nonnull
    private final ErrorDialogs errorDialogs;
    @Nonnull
    private final ExperimentStatusProperty experimentStatusProperty;
    @Nonnull
    private final ExpirationNotifier expirationNotifier;
    @Nonnull
    private final ExperimentController experimentController;
    @Nonnull
    private final Experiment experiment;
    @Nonnull
    private final ManifestRspecSource canvasRspecSource;
    private SCPTab scpTab = null;

    public ExperimentViewController(@Nonnull ExperimentController experimentController, @Nonnull ExperimentViewsFactory experimentViewsFactory, @Nonnull Provider<ErrorsView> errorsViewProvider, @Nonnull ErrorDialogs errorDialogs, @Nonnull TasksWindow tasksWindow, @Nonnull JFedHLPreferences jFedPreferences, @Nonnull JFedGuiConfig jFedGuiConfig, @Nonnull EventBus eventBus, @Nonnull ProgressItemCustomDetailsViews progressItemCustomViews, @Nonnull BrowserUtil browserUtil, @Nonnull ExperimenterJobFactory experimenterJobFactory) {
        this.experimentController = experimentController;
        this.progressItemCustomViews = progressItemCustomViews;
        this.browserUtil = browserUtil;
        this.experimenterJobFactory = experimenterJobFactory;
        this.experiment = experimentController.getExperiment();
        this.experimentStatusProperty = new ExperimentStatusProperty(this.experiment);
        this.expirationNotifier = new ExpirationNotifier(this, jFedPreferences, eventBus);
        this.eventBus = eventBus;
        this.errorDialogs = errorDialogs;
        this.tasksWindow = tasksWindow;
        this.jFedPreferences = jFedPreferences;
        this.jFedGuiConfig = jFedGuiConfig;
        eventBus.register((Object)this);
        experimentController.addListener((ExperimentControllerListener)this);
        this.experiment.addExperimentChangeListener((ExperimentChangeListener)this);
        experimentController.addEventHandler(ExperimentPartsEvent.STOPPED, this::onExperimentPartsStoppedHandler);
        experimentController.setWaitForReadyTimeoutHandler(experiment -> Platform.runLater(this::showTimedOutWaitingForReadyDialog));
        this.canvasRspecSource = ExperimentUtils.mergeNewRequestRspecWithExistingManifestRspec((RequestRspecSource)this.experiment.getNewRequestRspecSource(), (Slice)this.experiment.getSliceOrNull());
        this.detailsTabPane = new TabPane();
        this.detailsTabPane.setTabClosingPolicy(TabPane.TabClosingPolicy.ALL_TABS);
        this.progressView = new ProgressView();
        this.errorsView = (ErrorsView)((Object)errorsViewProvider.get());
        this.detailsTabPane.getTabs().addAll((Object[])new Tab[]{new ProgressViewTab(this.progressView), new ErrorsViewTab(this.errorsView)});
        this.eSpecLogModel = new ESpecLogModel(this.experiment);
        Runnable initESpecTab = () -> {
            boolean hasEspecTab = this.detailsTabPane.getTabs().stream().anyMatch(tab -> tab instanceof ESpecTab);
            if (!hasEspecTab) {
                this.detailsTabPane.getTabs().addAll((Object[])new Tab[]{new ESpecTab(experimentController, this.eSpecLogModel)});
            }
        };
        if (this.experiment.getExperimentSpecification() != null) {
            initESpecTab.run();
        } else {
            this.experiment.containsExperimentSpecificationProperty().addListener((observable, oldVal, newVal) -> initESpecTab.run());
        }
        this.modelSliceView = experimentViewsFactory.createModelSliceView(experimentController, this.canvasRspecSource);
        this.rawSliceView = experimentViewsFactory.createRawSliceView(this.experiment, this.canvasRspecSource);
        ScrollPane detailsScrollPane = new ScrollPane();
        detailsScrollPane.setPrefHeight(100.0);
        detailsScrollPane.setContent((Node)this.detailsTabPane);
        detailsScrollPane.setFitToHeight(true);
        detailsScrollPane.setFitToWidth(true);
        this.setOrientation(Orientation.VERTICAL);
        this.getItems().addAll((Object[])new Node[]{new Pane(), detailsScrollPane});
        this.setDividerPosition(0, 0.7);
        LOG.info("ExperimentViewController constructor starts experiment");
        try {
            experimentController.start();
        }
        catch (ESpecFileFetchException e) {
            JFDialogs.create().owner((Node)this).message("Something went wrong trying to fetch the ESpec files.\nCheck the logs (CTRL-F10, and scroll to bottom) for details.\n\nNo experiment will be created or started.").masthead("Error fetching ESpec files").showError();
        }
    }

    private void onExperimentPartsStoppedHandler(ExperimentPartsEvent event) {
        List<SfaExperimentPart> sfaParts = event.getParts().stream().filter(part -> part instanceof SfaExperimentPart).map(SfaExperimentPart.class::cast).collect(Collectors.toList());
        if (!sfaParts.isEmpty() && this.jFedGuiConfig.isQOEReportingEnabled()) {
            this.submitJob((Job)this.experimenterJobFactory.createQoeJob(this.experimentController.getExperiment(), sfaParts));
        }
    }

    private <V> ListenableFuture<V> submitJob(Job<V> job) {
        this.onJobSubmitted(job);
        job.stateProperty().addListener(observable -> this.onJobStateChanged(job, job.getState()));
        return jobExecutorService.submit(() -> {
            try {
                Object result = job.call();
                this.onJobFinished(job);
                return result;
            }
            catch (Exception ex) {
                LOG.error("Error while executing job '{}': {}", new Object[]{job.getName(), ex.getMessage(), ex});
                throw ex;
            }
        });
    }

    private void warnIfExpireSoon() {
        if (this.experiment.isPartsEmpty()) {
            LOG.debug("Won't warn for expire soon: parts empty");
            return;
        }
        SliceRunDuration sliceRunDuration = new SliceRunDuration(this.experiment);
        NextExperimentExpiration nextExperimentExpiration = new NextExperimentExpiration(this.experiment);
        Instant firstExpiration = nextExperimentExpiration.getFirstExpirationTime();
        if (sliceRunDuration.isLongRunning(false) && sliceRunDuration.willExpireSoon(firstExpiration, false)) {
            LOG.debug("warning for for expire soon: " + String.valueOf(firstExpiration));
            JFDialogs.create().message("This experiment expires soon: in " + DateTimeUtils.prettyPrintDuration(Duration.between(Instant.now(), firstExpiration)) + " (" + String.valueOf(firstExpiration) + "). Make sure you renew it in time, if needed.").title("Experiment expires soon").masthead("Experiment expires soon").showWarning();
        } else {
            LOG.debug("Not warning for for expire soon: " + String.valueOf(firstExpiration));
        }
    }

    public void onExperimentStateChange(ExperimentState newExperimentState) {
        if (newExperimentState == ExperimentState.CREATED) {
            Platform.runLater(this::checkAndWarnForExpiringResources);
        } else if (newExperimentState == ExperimentState.RESTORED) {
            Platform.runLater(this::warnIfExpireSoon);
        } else if (newExperimentState == ExperimentState.PROVISIONING) {
            Platform.runLater(this::showSliversInitializationDialog);
        } else if (newExperimentState == ExperimentState.WAIT_FOR_READY) {
            Platform.runLater(this::checkAndWarnForEarlyExpire);
        } else if (newExperimentState == ExperimentState.FAILING) {
            if (this.experiment.getNewRequestRspecSource() != null) {
                Platform.runLater(this::showFailedDialog);
            } else {
                Platform.runLater(this::showFailedRecoverDialog);
            }
        }
    }

    public void onExperimentPartAdded(ExperimentPart experimentPart) {
    }

    private void checkAndWarnForEarlyExpire() {
        if (this.experiment.getNewRequestRspecSource() == null) {
            return;
        }
        if (ExpirationChecker.isEarlyExpire((Experiment)this.experiment)) {
            Instant actualEarliestExpiration = ExpirationChecker.getEarliestExpiration((Experiment)this.experiment);
            Instant requestedExpiration = this.experiment.getRequestedEndTime();
            String diff = requestedExpiration != null && actualEarliestExpiration != null ? TimeUtil.calcDiff((Instant)requestedExpiration, (Instant)actualEarliestExpiration) : null;
            LOG.warn("Detected that the experiment expired earlier than requested. requested={} actual={} diff={}", new Object[]{requestedExpiration, actualEarliestExpiration, diff});
            JFDialogs.create().owner((Node)this).message("The created experiment expires earlier than you requested! This will cause your resources to be freed at a sooner time than you anticipate. \n\nRequested Expiration time: " + String.valueOf(requestedExpiration) + " \nActual Earliest Expiration time: " + String.valueOf(actualEarliestExpiration) + " \nDifference: " + diff + " \n\nThe experiment will continue to be set up normally. We advise you to try to renew it.").masthead("Early Expiration!").showError();
        }
    }

    private void checkAndWarnForExpiringResources() {
        NextExperimentExpiration nextExperimentExpiration;
        if (this.jFedPreferences.isRecoverExpirationWarningEnabled() && this.experiment.getNewRequestRspecSource() == null && (nextExperimentExpiration = new NextExperimentExpiration(this.experiment)).getFirstExpirationTime() != null) {
            Duration durationToNextExpiration = Duration.between(Instant.now(), nextExperimentExpiration.getFirstExpirationTime());
            if (durationToNextExpiration.toMinutes() < (long)this.jFedPreferences.getRecoverExpirationWarningTime()) {
                LOG.debug("Showing warning dialog about imminent expiration of recovering experiment {}", (Object)this.experiment.getName());
                ButtonType renewNewButtonType = new ButtonType("Renew now", ButtonBar.ButtonData.OK_DONE);
                ButtonType ignoreButtonType = new ButtonType("Ignore", ButtonBar.ButtonData.CANCEL_CLOSE);
                Alert alert = new Alert(Alert.AlertType.WARNING, String.format("The experiment %s is expiring in less than %d minutes.\nDo you want to renew your experiment now?", this.experiment.getName(), durationToNextExpiration.toMinutes() + 1L), new ButtonType[]{renewNewButtonType, ignoreButtonType});
                alert.setHeaderText("Experiment is expiring soon");
                alert.showAndWait().filter(buttonType -> buttonType == renewNewButtonType).ifPresent(buttonType -> {
                    Window window = this.getScene() == null ? null : this.getScene().getWindow();
                    this.eventBus.post((Object)new RenewExperimentEvent(window, this.getExperimentController()));
                });
            } else {
                LOG.debug("Recovering experiment {} expires in {}, while treshold is on {} minutes. Not showing warning dialog.", new Object[]{this.experiment.getName(), durationToNextExpiration.toMinutes(), this.jFedPreferences.getRecoverExpirationWarningTime()});
            }
        }
    }

    private void showFailedDialog() {
        if (this.jFedGuiConfig.isExperimentDeleteDisabled()) {
            LOG.debug("Not showing failed dialog: jFedGuiConfig.isExperimentDeleteDisabled() == true");
            this.experiment.setExperimentState(ExperimentState.FAILED);
            return;
        }
        SliceRunDuration sliceRunDuration = new SliceRunDuration(this.experiment);
        boolean shortRunningSlice = sliceRunDuration.isShortRunning(false);
        boolean longRunningSlice = sliceRunDuration.isLongRunning(false);
        LOG.info("Showing failed dialog, with shortRunningSlice=" + shortRunningSlice + " longRunningSlice=" + longRunningSlice);
        DialogPane dialogPane = new DialogPane();
        dialogPane.setHeaderText(String.format("Experiment '%s' failed", this.experiment.getName()));
        dialogPane.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.PLAY, (Color)Color.GREEN));
        ButtonType releaseResourcesButtonType = new ButtonType("Yes, Release Resources", ButtonBar.ButtonData.YES);
        ButtonType doNothingButtonType = new ButtonType("No", ButtonBar.ButtonData.NO);
        if (shortRunningSlice) {
            dialogPane.setContentText(String.format("The testbed reported that one or more resources in your experiment '%s' failed permanently.\n\n", this.experiment.getName()) + "It is advised to delete all requested resources from your experiment now.\n\nDo you want do delete all your resources?");
            dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{releaseResourcesButtonType, doNothingButtonType});
        } else {
            if (longRunningSlice) {
                dialogPane.setContentText(String.format("The testbed reported that one or more resources in your long running experiment '%s' failed permanently.\n\n", this.experiment.getName()) + "You should check what is going wrong. When in doubt, send a bugreport.");
            } else {
                dialogPane.setContentText(String.format("The testbed reported that one or more resources in your experiment '%s' failed permanently.\n\n", this.experiment.getName()) + "jFed has limited info on this experiment.\n\nConsider sending a bugreport or deleting all requested resources from your experiment.");
            }
            dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{doNothingButtonType});
        }
        Dialog dialog = new Dialog();
        dialog.setTitle(String.format("Experiment %s failed", this.experiment.getName()));
        dialog.setDialogPane(dialogPane);
        dialog.setResizable(true);
        ButtonType chosenButton = dialog.showAndWait().orElse(doNothingButtonType);
        if (chosenButton == releaseResourcesButtonType && chosenButton.getText().contains("Release Resources") && shortRunningSlice) {
            LOG.info("showFailedDialog() -> The user has chosen to Terminate the experiment. chosenButton=" + String.valueOf(chosenButton) + " (shortRunningSlice=" + shortRunningSlice + " longRunningSlice=" + longRunningSlice + ")");
            this.experimentController.stop();
        } else {
            LOG.info("showFailedDialog() -> The user has chosen NOT to terminate the experiment: chosenButton=" + String.valueOf(chosenButton) + " (shortRunningSlice=" + shortRunningSlice + " longRunningSlice=" + longRunningSlice + ")");
        }
        this.experiment.setExperimentState(ExperimentState.FAILED);
    }

    private void showFailedRecoverDialog() {
        LOG.debug("Showing recover failed dialog");
        DialogPane dialogPane = new DialogPane();
        dialogPane.setHeaderText(String.format("Experiment '%s' has FAILED resources", this.experiment.getName()));
        dialogPane.setContentText(String.format("The testbed reported that one or more resources in your experiment '%s' failed permanently.\n\n", this.experiment.getName()) + "Consider freeing the resources and starting a new experiment.");
        dialogPane.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TIMES_CIRCLE, (Color)Color.RED));
        ButtonType doNothingButtonType = new ButtonType("Ok", ButtonBar.ButtonData.OK_DONE);
        dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{doNothingButtonType});
        Dialog dialog = new Dialog();
        dialog.setTitle(String.format("Experiment %s failed", this.experiment.getName()));
        dialog.setDialogPane(dialogPane);
        dialog.setResizable(true);
        ButtonType chosenButton = dialog.showAndWait().orElse(doNothingButtonType);
        this.experiment.setExperimentState(ExperimentState.FAILED);
    }

    private void showTimedOutWaitingForReadyDialog() {
        LOG.debug("Showing timed out waiting for ready dialog");
        DialogPane dialogPane = new DialogPane();
        dialogPane.setHeaderText("Experiment is taking long to become ready");
        dialogPane.setContentText("One or more resources in your experiment is taking a long time to become ready.\n\nYou can either give up or you can wait longer.\n\nNote: No resources will be released.");
        dialogPane.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.CLOCK_ALT, (Color)Color.ORANGE));
        ButtonType stopWaitingButtonType = new ButtonType("Stop waiting", ButtonBar.ButtonData.OTHER);
        ButtonType doNothingButtonType = new ButtonType("Wait Longer", ButtonBar.ButtonData.YES);
        dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{stopWaitingButtonType});
        dialogPane.getButtonTypes().add((Object)doNothingButtonType);
        Dialog dialog = new Dialog();
        dialog.setTitle("Experiment Wait For Ready Timeout");
        dialog.setDialogPane(dialogPane);
        dialog.setResizable(true);
        ButtonType chosenButton = dialog.showAndWait().orElse(doNothingButtonType);
        if (chosenButton == stopWaitingButtonType) {
            LOG.debug("showTimedOutWaitingForReadyDialog: User chose to keep resources and stop waiting");
            this.experiment.setExperimentState(ExperimentState.UNKNOWN);
        }
        if (chosenButton == doNothingButtonType) {
            LOG.debug("showTimedOutWaitingForReadyDialog: User chose to keep waiting");
            this.experiment.setExperimentState(ExperimentState.WAIT_FOR_READY);
        }
    }

    @Override
    public void addDetailsTab(Tab tab) {
        this.detailsTabPane.getTabs().add((Object)tab);
    }

    @Override
    public void removeDetailsTab(Tab tab) {
        this.detailsTabPane.getTabs().remove((Object)tab);
    }

    @Override
    public boolean containsDetailsTab(Tab tab) {
        return this.detailsTabPane.getTabs().contains((Object)tab);
    }

    @Override
    public void selectDetailsTab(Tab tab) {
        assert (this.detailsTabPane.getTabs().contains((Object)tab));
        this.detailsTabPane.getSelectionModel().select((Object)tab);
    }

    private Node getMainView() {
        return (Node)this.getItems().get(0);
    }

    public boolean switchToModelView() {
        this.setMainView((Node)this.modelSliceView);
        return true;
    }

    public boolean switchToRawView() {
        this.setMainView((Node)this.rawSliceView);
        return true;
    }

    private void setMainView(@Nonnull Node node) {
        Node oldNode = this.getItems().isEmpty() ? null : (Node)this.getItems().get(0);
        double[] oldDividerPostions = this.getDividerPositions();
        this.getItems().set(0, (Object)node);
        node.setVisible(true);
        if (oldNode != null) {
            oldNode.setVisible(false);
        }
        this.setDividerPositions(oldDividerPostions);
    }

    public boolean isCanvasVisible() {
        return this.getMainView() == this.modelSliceView;
    }

    public boolean isRawRspecVisible() {
        return this.getMainView() == this.rawSliceView;
    }

    public void showSliversInitializationDialog() {
        if (this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SHOW_SLICE_INITIALIZATION_DIALOG, true)) {
            LOG.debug("Showing slivers initialization dialog");
            VBox pane = new VBox();
            pane.setPrefWidth(400.0);
            pane.setMinHeight(300.0);
            pane.setSpacing(5.0);
            Label textLabel = new Label("It will take some time to start and initialize all nodes. You will be able to login by double-clicking or right-clicking on the node when it becomes green. Typically it takes about 3 minutes. If SSH-login does not work when the node is green, try again after some time.");
            textLabel.setMinHeight(200.0);
            textLabel.setWrapText(true);
            pane.getChildren().add((Object)textLabel);
            CheckBox checkBox = new CheckBox("Do not show this dialog again");
            pane.getChildren().add((Object)checkBox);
            DialogPane dialogPane = new DialogPane();
            dialogPane.setHeaderText("Your experiment run is initializing...");
            dialogPane.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.PLAY, (Color)Color.GREEN));
            dialogPane.setContent((Node)pane);
            dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK});
            Dialog dialog = new Dialog();
            dialog.setTitle("Experiment run is initializing");
            dialog.setDialogPane(dialogPane);
            dialog.showAndWait();
            this.jFedPreferences.setBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SHOW_SLICE_INITIALIZATION_DIALOG, !checkBox.isSelected());
        } else {
            LOG.debug("Skipping slivers initializing dialog because user muted it before");
        }
    }

    @Nonnull
    public ExperimentController getExperimentController() {
        return this.experimentController;
    }

    public void onJobSubmitted(@Nonnull Job<?> job) {
        if (job instanceof AbstractJob) {
            AbstractJob abstractJob = (AbstractJob)job;
            abstractJob.addTaskExecutionFinishedListener((TaskExecutionFinishedListener)this.errorsView);
            abstractJob.addTaskExecutionFinishedListener((TaskExecutionFinishedListener)this.errorDialogs);
        } else {
            LOG.warn("Unexpected job type: {}. Cannot listen for taskExecutions", (Object)job.getClass().getName());
        }
    }

    public void onJobStateChanged(@Nonnull Job<?> job, State state) {
        LOG.debug("Received new State {} from job {} in ExperimentViewController of {}", new Object[]{state.getName(), job.getName(), this.experiment.getName()});
        if (state instanceof SlicedState) {
            SlicedState slicedState = (SlicedState)state;
            for (StateSlice statefulThread : slicedState.getSlices()) {
                assert (statefulThread.getState() == null) : "Unexpected: Thread is already active!";
                statefulThread.stateProperty().addListener(observable -> this.onJobStateChanged(job, statefulThread.getState()));
            }
        } else if (!(state instanceof AllocateExperimentJob.AllocatePartStateSlice.WaitForNextAllocateActionState)) {
            Platform.runLater(() -> this.progressView.registerProgressViewItem(new StateProgressItem(state)));
        }
        if (state instanceof ExecuteAnsibleServicesState.ExecuteAnsibleServiceStateSlice.ExecuteAnsibleServiceState) {
            ExecuteAnsibleServicesState.ExecuteAnsibleServiceStateSlice.ExecuteAnsibleServiceState s = (ExecuteAnsibleServicesState.ExecuteAnsibleServiceStateSlice.ExecuteAnsibleServiceState)state;
            Platform.runLater(() -> this.detailsTabPane.getTabs().add((Object)new AnsibleOutputTab(s.getNode(), s.getAnsibleService(), s.getGalaxyInputStream(), s.getGalaxyErrorStream(), s.getPlaybookInputStream(), s.getPlaybookErrorStream())));
        }
    }

    public void onJobFinished(@Nonnull Job<?> job) {
        AllocateExperimentJob allocateExperimentJob;
        OpenConsoleJob openConsoleJob;
        if (job instanceof OpenConsoleJob && (openConsoleJob = (OpenConsoleJob)job).getResult() != null) {
            this.browserUtil.openUrlInBrowser(openConsoleJob.getResult());
        }
        if (job instanceof AllocateExperimentJob && (allocateExperimentJob = (AllocateExperimentJob)job).getFailedResources() != null) {
            this.showReservationFailedDialog(allocateExperimentJob.getFailedResources());
        }
        if (job instanceof RenewJob) {
            RenewJob renewJob = (RenewJob)job;
            if (renewJob.isRenewSliceFailed()) {
                Platform.runLater(() -> this.showRenewSliceFailedDialog(this.experiment));
            } else if (!renewJob.getFailedParts().isEmpty()) {
                Platform.runLater(() -> this.showRenewSliversFailedDialog(renewJob.getExperiment(), renewJob.getFailedParts()));
            }
        }
    }

    private void showRenewSliversFailedDialog(Experiment experiment, List<ExperimentPart> failedParts) {
        LOG.debug("Showing renew failed dialog");
        StringBuilder content = new StringBuilder();
        content.append("One or more resources in the experiment '").append(experiment.getName()).append("' could not be renewed on:\n");
        failedParts.forEach(experimentPart -> {
            if (experimentPart instanceof SfaExperimentPart) {
                SfaExperimentPart sfaExperimentPart = (SfaExperimentPart)experimentPart;
                content.append("\t- ").append(sfaExperimentPart.getComponentManagerSfaAuthority().getName()).append("\n");
            } else {
                content.append("\t- ").append(experimentPart.getName()).append("\n");
            }
        });
        content.append("\nWe strongly advise you to submit a bugreport, so that the testbed administrators can look into this issue.");
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Renew failed");
        alert.setHeaderText("Renew failed");
        alert.setContentText(content.toString());
        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        alert.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.CLOCK_ALT, (Color)Color.ORANGERED));
        alert.setResizable(true);
        if (Platform.isFxApplicationThread()) {
            alert.showAndWait();
        } else {
            Platform.runLater(() -> alert.showAndWait());
        }
    }

    private void showRenewSliceFailedDialog(Experiment experiment) {
        LOG.debug("Showing renew slice failed dialog");
        String content = "The experiment container (slice) of '" + experiment.getName() + "' could not be renewed.\n\nWe strongly advise you to submit a bugreport, so that the testbed administrators can look into this issue.";
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Renew failed");
        alert.setHeaderText("Renew failed");
        alert.setContentText(content);
        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        alert.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.CLOCK_ALT, (Color)Color.ORANGERED));
        if (Platform.isFxApplicationThread()) {
            alert.showAndWait();
        } else {
            Platform.runLater(() -> alert.showAndWait());
        }
    }

    private void showReservationFailedDialog(Collection<GeniUrn> failedResources) {
        LOG.debug("Showing reservation failed dialog");
        StringBuilder content = new StringBuilder();
        content.append("The following resources could not be reserved:\n");
        failedResources.forEach(geniUrn -> content.append("\t- ").append(geniUrn.toString()).append("\n"));
        content.append("\nIt is advised to delete all requested resources from your experiment now.\n\nDo you want do delete all your resources?");
        DialogPane dialogPane = new DialogPane();
        dialogPane.setHeaderText("Reservation failed");
        dialogPane.setContentText(content.toString());
        dialogPane.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.CALENDAR, (Color)Color.ORANGERED));
        ButtonType releaseResourcesButtonType = new ButtonType("Yes, Release Resources", ButtonBar.ButtonData.YES);
        dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{releaseResourcesButtonType, ButtonType.NO});
        Dialog dialog = new Dialog();
        dialog.setTitle("Experiment run is initializing");
        dialog.setDialogPane(dialogPane);
        if (dialog.showAndWait().orElse(ButtonType.NO) == releaseResourcesButtonType) {
            LOG.info("showReservationFailedDialog() -> The user has chosen to Terminate the experiment.");
            this.experimentController.stop();
        }
    }

    @Nonnull
    public Experiment getExperiment() {
        return this.experimentController.getExperiment();
    }

    @Nonnull
    public ObservableStringValue statusProperty() {
        return this.experimentStatusProperty;
    }

    @Nonnull
    public ModelSliceView getModelSliceView() {
        return this.modelSliceView;
    }

    @Nonnull
    public RawSliceView getRawSliceView() {
        return this.rawSliceView;
    }

    @Nonnull
    public JFedHLPreferences getjFedPreferences() {
        return this.jFedPreferences;
    }

    @Subscribe
    public void handleSCPTasks(SCPTask scpTask) {
        if (scpTask.getExperiment() != this.experiment) {
            return;
        }
        if (this.scpTab == null) {
            this.scpTab = new SCPTab();
            this.detailsTabPane.getTabs().add((Object)this.scpTab);
            this.detailsTabPane.getSelectionModel().select((Object)this.scpTab);
        }
        this.scpTab.registerSCPTask(scpTask);
        scpTask.setOnFailed(event -> JFDialogs.create().owner(this.getScene().getWindow()).title("File transfer failed").masthead("Your file transfer encountered an error").message(event.getSource().getException().getMessage()).showException(event.getSource().getException()));
    }

    @Nonnull
    public ManifestRspecSource getCanvasRspecSource() {
        return this.canvasRspecSource;
    }

    private final class StateProgressItem
    extends ProgressItem {
        private final State state;

        private StateProgressItem(State state) {
            this.state = state;
            this.setText(state.getName());
            if (state instanceof TestLinksJob.TestLinksOfExperimentPartState) {
                final TestLinksJob.TestLinksOfExperimentPartState linkTestState = (TestLinksJob.TestLinksOfExperimentPartState)state;
                final StatusBinding statusBinding = new StatusBinding((ObservableObjectValue<ExperimentTaskStatus>)state.statusProperty());
                this.progressProperty().set((Object)statusBinding.computeValue());
                state.statusProperty().addListener((ChangeListener)new ChangeListener<ExperimentTaskStatus>(){

                    public void changed(ObservableValue<? extends ExperimentTaskStatus> observable, ExperimentTaskStatus oldValue, ExperimentTaskStatus newValue) {
                        if (newValue == ExperimentTaskStatus.SUCCESS) {
                            if (linkTestState.areAllReportSuccessful()) {
                                StateProgressItem.this.progressProperty().set((Object)TaskStatusIndicator.Status.SUCCESS);
                            } else {
                                StateProgressItem.this.progressProperty().set((Object)TaskStatusIndicator.Status.FAILED);
                            }
                        } else {
                            StateProgressItem.this.progressProperty().set((Object)statusBinding.computeValue());
                        }
                    }
                });
            } else {
                this.progressProperty().bind((ObservableValue)new StatusBinding((ObservableObjectValue<ExperimentTaskStatus>)state.statusProperty()));
            }
            this.statusProperty().bind((ObservableValue)state.messageProperty());
            CustomStateDetailsView<? extends State> customDetailsView = ExperimentViewController.this.progressItemCustomViews.getCustomDetailsView(state);
            if (customDetailsView != null) {
                this.setOnDetailsView((EventHandler<Event>)((EventHandler)event -> customDetailsView.showCustomDetailsView(state)));
            } else if (state instanceof SingleCallState) {
                SingleCallState singleCallState = (SingleCallState)state;
                this.setOnDetailsView((EventHandler<Event>)((EventHandler)event -> {
                    if (singleCallState.getTaskExecution() != null) {
                        ExperimentViewController.this.tasksWindow.showTaskExecution(singleCallState.getTaskExecution());
                    }
                }));
            } else if (state instanceof MultipleCallState) {
                MultipleCallState multipleCallState = (MultipleCallState)state;
                this.setOnDetailsView((EventHandler<Event>)((EventHandler)event -> multipleCallState.getTaskExecutions().values().stream().filter(Objects::nonNull).findFirst().ifPresent(ExperimentViewController.this.tasksWindow::showTaskExecution)));
            }
        }
    }

    private static class StatusBinding
    extends ObjectBinding<TaskStatusIndicator.Status> {
        @Nonnull
        private final ObservableObjectValue<ExperimentTaskStatus> statusProperty;

        private StatusBinding(@Nonnull ObservableObjectValue<ExperimentTaskStatus> statusProperty) {
            this.bind(new Observable[]{statusProperty});
            this.statusProperty = statusProperty;
        }

        protected TaskStatusIndicator.Status computeValue() {
            switch ((ExperimentTaskStatus)this.statusProperty.get()) {
                case INACTIVE: {
                    return TaskStatusIndicator.Status.INACTIVE;
                }
                case BUSY: {
                    return TaskStatusIndicator.Status.BUSY;
                }
                case SUCCESS: {
                    return TaskStatusIndicator.Status.SUCCESS;
                }
                case FAILED: {
                    return TaskStatusIndicator.Status.FAILED;
                }
                case WARNING: {
                    return TaskStatusIndicator.Status.WARNING;
                }
            }
            throw new IllegalArgumentException("Unknown state");
        }
    }
}

