/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experiment.ExperimentControllerFactory;
import be.iminds.ilabt.jfed.experiment.ExperimentControllerListener;
import be.iminds.ilabt.jfed.experimenter_gui.call_gui.TasksWindow;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentViewController;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentViewsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.slice.FunctionalityBlockingExperimentControllerFactory;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ProgressItemCustomDetailsViews;
import be.iminds.ilabt.jfed.experimenter_gui.slice.errors.ErrorDialogs;
import be.iminds.ilabt.jfed.experimenter_gui.slice.errors.ErrorsView;
import be.iminds.ilabt.jfed.experimenter_gui.slice.jobs.ExperimenterJobFactory;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.experimenter_gui.util.BugReportExperimentControllerListener;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import com.google.common.eventbus.EventBus;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class ExperimentViewControllerFactory {
    @Nonnull
    private final ExperimentControllerFactory experimentControllerFactory;
    @Nonnull
    private final ExperimentViewsFactory experimentViewsFactory;
    @Nonnull
    private final ExperimenterJobFactory experimenterJobFactory;
    @Nonnull
    private final Provider<ErrorsView> errorsViewProvider;
    @Nonnull
    private final Provider<ErrorDialogs> errorDialogsProvider;
    @Nonnull
    private final JFedHLPreferences jFedPreferences;
    @Nonnull
    private final JFedGuiConfig jFedGuiConfig;
    @Nonnull
    private final TasksWindow tasksWindow;
    @Nonnull
    private final EventBus eventBus;
    @Nonnull
    private final ProgressItemCustomDetailsViews progressItemCustomViews;
    @Nonnull
    private final BrowserUtil browserUtil;
    @Nonnull
    private final BugReportExperimentControllerListener bugReportExperimentControllerListener;

    @Inject
    public ExperimentViewControllerFactory(@Nonnull ExperimentControllerFactory experimentControllerFactory, @Nonnull ExperimentViewsFactory experimentViewsFactory, @Nonnull Provider<ErrorsView> errorsViewProvider, @Nonnull Provider<ErrorDialogs> errorDialogsProvider, @Nonnull JFedHLPreferences jFedPreferences, @Nonnull JFedGuiConfig jFedGuiConfig, @Nonnull TasksWindow tasksWindow, @Nonnull EventBus eventBus, @Nonnull ExperimenterJobFactory experimenterJobFactory, @Nonnull ProgressItemCustomDetailsViews progressItemCustomViews, @Nonnull BrowserUtil browserUtil, @Nonnull BugReportExperimentControllerListener bugReportExperimentControllerListener) {
        this.experimentControllerFactory = new FunctionalityBlockingExperimentControllerFactory(jFedGuiConfig, experimentControllerFactory);
        this.experimentViewsFactory = experimentViewsFactory;
        this.errorsViewProvider = errorsViewProvider;
        this.errorDialogsProvider = errorDialogsProvider;
        this.jFedPreferences = jFedPreferences;
        this.jFedGuiConfig = jFedGuiConfig;
        this.tasksWindow = tasksWindow;
        this.eventBus = eventBus;
        this.experimenterJobFactory = experimenterJobFactory;
        this.progressItemCustomViews = progressItemCustomViews;
        this.browserUtil = browserUtil;
        this.bugReportExperimentControllerListener = bugReportExperimentControllerListener;
    }

    public ExperimentViewController createExperimentViewController(ExperimentController experimentController) {
        return new ExperimentViewController(experimentController, this.experimentViewsFactory, this.errorsViewProvider, (ErrorDialogs)this.errorDialogsProvider.get(), this.tasksWindow, this.jFedPreferences, this.jFedGuiConfig, this.eventBus, this.progressItemCustomViews, this.browserUtil, this.experimenterJobFactory);
    }

    public ExperimentViewController createExperimentViewController(Experiment experiment) {
        ExperimentController experimentController = this.experimentControllerFactory.createExperimentController(experiment);
        experimentController.setExperimentConnectivityTesterFactory(this.experimenterJobFactory::createTestConnectivityJob);
        experimentController.setExperimentLinkTesterFactory(this.experimenterJobFactory::createTestLinksJob);
        experimentController.addListener((ExperimentControllerListener)this.bugReportExperimentControllerListener);
        return this.createExperimentViewController(experimentController);
    }
}

