/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice;

import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentViewController;
import be.iminds.ilabt.jfed.experimenter_gui.slice.SliceRibbonTabs;
import be.iminds.ilabt.jfed.experimenter_gui.tabs.AskOnCloseRequest;
import be.iminds.ilabt.jfed.experimenter_gui.tabs.RibbonEnabled;
import be.iminds.ilabt.jfed.experimenter_gui.tabs.StatusEnabled;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ribbon.RibbonTab;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.List;
import java.util.Optional;
import javafx.application.Platform;
import javafx.beans.value.ObservableStringValue;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javax.annotation.Nonnull;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.GlyphFont;
import org.controlsfx.glyphfont.GlyphFontRegistry;

public class ExperimentViewControllerTab
extends Tab
implements StatusEnabled,
RibbonEnabled,
AskOnCloseRequest {
    private static final GlyphFont fontAwesome = GlyphFontRegistry.font((String)"FontAwesome");
    @Nonnull
    private final ObservableMap<GeniUrn, ExperimentViewController> experimentViewControllers;
    @Nonnull
    private final ExperimentViewController experimentViewController;
    @Nonnull
    private final SliceRibbonTabs sliceRibbonTabs;
    @Nonnull
    private final JFedPreferences jFedPreferences;

    public ExperimentViewControllerTab(@Nonnull ExperimentViewController experimentViewController, @Nonnull ObservableMap<GeniUrn, ExperimentViewController> experimentViewControllers, @Nonnull SliceRibbonTabs sliceRibbonTabs) {
        this.setGraphic((Node)fontAwesome.create((Enum)FontAwesome.Glyph.PLAY_CIRCLE));
        this.experimentViewController = experimentViewController;
        this.experimentViewControllers = experimentViewControllers;
        this.sliceRibbonTabs = sliceRibbonTabs;
        assert (experimentViewController != null);
        this.jFedPreferences = experimentViewController.getjFedPreferences();
        this.setContent((Node)experimentViewController);
        this.setText(experimentViewController.getExperiment().getName());
        TabStyle.updateTabStyle(this, experimentViewController.getExperiment().getExperimentState());
        experimentViewController.getExperiment().experimentStateProperty().addListener(observable -> Platform.runLater(() -> TabStyle.updateTabStyle(this, experimentViewController.getExperiment().getExperimentState())));
    }

    @Nonnull
    public ExperimentViewController getExperimentViewController() {
        return this.experimentViewController;
    }

    @Override
    public ObservableStringValue statusProperty() {
        return this.experimentViewController.statusProperty();
    }

    @Override
    public List<? extends RibbonTab> getRibbonTabs() {
        return this.sliceRibbonTabs.getRibbonTabs();
    }

    @Override
    public RibbonTab getInitialTabToActivate() {
        if (this.experimentViewController.isRawRspecVisible()) {
            return this.sliceRibbonTabs.getRspecViewerRibbonTab();
        }
        return this.sliceRibbonTabs.getTopologyViewerRibbonTab();
    }

    @Override
    public boolean onTabCloseRequest() {
        if (this.getExperimentViewController().getExperiment().getExperimentState().isActiveState()) {
            if (this.jFedPreferences.getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SHOW_CLOSE_TAB_WARNING_DIALOG, true)) {
                VBox pane = new VBox();
                pane.setSpacing(5.0);
                Label textLabel = new Label(String.format("There are currently resources in use by '%s'. \nAre you sure you want to close this tab?\n\nIf you close it, you will still be able to access the resources later by using jFed's \"Recover\" function. ", this.getExperimentViewController().getExperiment().getName()));
                textLabel.setWrapText(true);
                pane.getChildren().add((Object)textLabel);
                CheckBox checkBox = new CheckBox("Do not show this dialog again");
                pane.getChildren().add((Object)checkBox);
                DialogPane dialogPane = new DialogPane();
                dialogPane.setHeaderText("Resources in use");
                dialogPane.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.WARNING, (Color)Color.ORANGE));
                dialogPane.setContent((Node)pane);
                dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
                Dialog dialog = new Dialog();
                dialog.setTitle("Resources in use");
                dialog.setDialogPane(dialogPane);
                Optional result = dialog.showAndWait();
                if (result.isPresent() && result.get() != ButtonType.YES) {
                    return false;
                }
                this.jFedPreferences.setBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_SHOW_CLOSE_TAB_WARNING_DIALOG, !checkBox.isSelected());
                GeniUrn sliceUrn = this.experimentViewController.getExperiment().getSliceUrn();
                if (sliceUrn != null) {
                    this.experimentViewControllers.remove((Object)sliceUrn);
                }
                return true;
            }
            GeniUrn sliceUrn = this.experimentViewController.getExperiment().getSliceUrn();
            if (sliceUrn != null) {
                this.experimentViewControllers.remove((Object)sliceUrn);
            }
            return true;
        }
        return true;
    }

    public static enum TabStyle {
        FUTURE_RESERVATION("tab-experiment-future-reservation"),
        RUNNING("tab-experiment-execution"),
        EXPIRED("tab-experiment-execution-expired"),
        FAILED("tab-experiment-execution-terminated");

        private final String styleClass;

        private TabStyle(String styleClass) {
            this.styleClass = styleClass;
        }

        public static void updateTabStyle(Tab tab, ExperimentState newState) {
            for (TabStyle tabStyle : TabStyle.values()) {
                tab.getStyleClass().remove((Object)tabStyle.styleClass);
            }
            TabStyle newTabStyle = switch (newState) {
                case ExperimentState.FUTURE_RESERVATION -> FUTURE_RESERVATION;
                case ExperimentState.TIMEOUT_WAITING, ExperimentState.FAILING, ExperimentState.FAILED -> FAILED;
                case ExperimentState.UNKNOWN, ExperimentState.EXPIRED, ExperimentState.EMPTY -> EXPIRED;
                default -> RUNNING;
            };
            tab.getStyleClass().add((Object)newTabStyle.styleClass);
        }
    }
}

