/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experimenter_gui.call_gui.TasksWindow;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ModelSliceView;
import be.iminds.ilabt.jfed.experimenter_gui.slice.NodePropertiesDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.slice.SliceExperimentCanvasFactory;
import be.iminds.ilabt.jfed.experimenter_gui.slice.raw.RawSliceView;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.experimenter_gui.util.ImageUtil;
import be.iminds.ilabt.jfed.experimenter_gui.util.SSHTerminalUtil;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsCache;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class ExperimentViewsFactory {
    @Nonnull
    private final Provider<TasksWindow> tasksWindowProvider;
    @Nonnull
    private final Provider<ApiCallDetailsCache> apiCallDetailsCacheProvider;
    @Nonnull
    private final Provider<SSHTerminalUtil> sshTerminalUtilProvider;
    @Nonnull
    private final Provider<JFedHLPreferences> jFedPreferencesProvider;
    @Nonnull
    private final Provider<TestbedInfoSource> authorityListModelProvider;
    @Nonnull
    private final Provider<SliceExperimentCanvasFactory> sliceExperimentCanvasFactoryProvider;
    @Nonnull
    private final Provider<NodePropertiesDialogFactory> nodePropertiesDialogFactoryProvider;
    @Nonnull
    private final Provider<ImageUtil> imageUtilProvider;
    @Nonnull
    private final Provider<BrowserUtil> browserUtilProvider;

    @Inject
    public ExperimentViewsFactory(@Nonnull Provider<ApiCallDetailsCache> apiCallDetailsCacheProvider, @Nonnull Provider<TasksWindow> tasksWindowProvider, @Nonnull Provider<SSHTerminalUtil> sshTerminalUtilProvider, @Nonnull Provider<JFedHLPreferences> jFedPreferencesProvider, @Nonnull Provider<TestbedInfoSource> authorityListModelProvider, @Nonnull Provider<SliceExperimentCanvasFactory> sliceExperimentCanvasFactoryProvider, @Nonnull Provider<NodePropertiesDialogFactory> nodePropertiesDialogFactoryProvider, @Nonnull Provider<ImageUtil> imageUtilProvider, @Nonnull Provider<BrowserUtil> browserUtilProvider) {
        this.apiCallDetailsCacheProvider = apiCallDetailsCacheProvider;
        this.tasksWindowProvider = tasksWindowProvider;
        this.sshTerminalUtilProvider = sshTerminalUtilProvider;
        this.jFedPreferencesProvider = jFedPreferencesProvider;
        this.authorityListModelProvider = authorityListModelProvider;
        this.sliceExperimentCanvasFactoryProvider = sliceExperimentCanvasFactoryProvider;
        this.nodePropertiesDialogFactoryProvider = nodePropertiesDialogFactoryProvider;
        this.imageUtilProvider = imageUtilProvider;
        this.browserUtilProvider = browserUtilProvider;
    }

    public RawSliceView createRawSliceView(@Nonnull Experiment experiment, @Nonnull ManifestRspecSource canvasRspecSource) {
        return new RawSliceView(experiment, canvasRspecSource, (SSHTerminalUtil)this.sshTerminalUtilProvider.get(), (BrowserUtil)this.browserUtilProvider.get(), (JFedHLPreferences)this.jFedPreferencesProvider.get(), (TestbedInfoSource)this.authorityListModelProvider.get());
    }

    public ModelSliceView createModelSliceView(@Nonnull ExperimentController experimentController, @Nonnull ManifestRspecSource canvasRspecSource) {
        return new ModelSliceView(experimentController, canvasRspecSource, (TestbedInfoSource)this.authorityListModelProvider.get(), (SliceExperimentCanvasFactory)this.sliceExperimentCanvasFactoryProvider.get(), (BrowserUtil)this.browserUtilProvider.get());
    }
}

