/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.experiment.util.NextExperimentExpiration;
import be.iminds.ilabt.jfed.experiment.util.NextExperimentExpirationBinding;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentViewController;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.RenewExperimentEvent;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.util.common.ThreadFactoryUtil;
import com.google.common.eventbus.EventBus;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javafx.application.Platform;
import javafx.stage.Window;
import javafx.util.Duration;
import javax.annotation.Nonnull;
import org.controlsfx.control.Notifications;
import org.controlsfx.control.action.Action;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpirationNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(ExpirationNotifier.class);
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor(ThreadFactoryUtil.getFactory((String)"ExpirationNotifier"));
    @Nonnull
    private final JFedHLPreferences jFedPreferences;
    @Nonnull
    private final EventBus eventBus;
    @Nonnull
    private final ExperimentViewController experimentViewController;
    @Nonnull
    private final Experiment experiment;
    private ScheduledFuture<?> scheduledFuture = null;
    private boolean warningShown = false;
    private Instant expirationWarningInstant = null;
    @Nonnull
    private final NextExperimentExpirationBinding nextExperimentExpirationBinding;

    public ExpirationNotifier(@Nonnull ExperimentViewController experimentViewController, @Nonnull JFedHLPreferences jFedPreferences, @Nonnull EventBus eventBus) {
        this.experimentViewController = experimentViewController;
        this.experiment = experimentViewController.getExperiment();
        this.jFedPreferences = jFedPreferences;
        this.eventBus = eventBus;
        this.nextExperimentExpirationBinding = new NextExperimentExpirationBinding(this.experiment);
        this.nextExperimentExpirationBinding.addListener(observable -> {
            this.onExpirationTimesUpdated();
            this.scheduleNextCheck();
        });
    }

    private void scheduleNextCheck() {
        if (this.expirationWarningInstant != null) {
            long secondsLeft;
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
            }
            if ((secondsLeft = ChronoUnit.SECONDS.between(Instant.now(), this.expirationWarningInstant)) < 0L) {
                LOG.info("Experiment will have expired by next check. Stopping ExpirationNotifier checks");
                return;
            }
            LOG.info("Schedule next check for {} in {} seconds.", (Object)this.experiment.getName(), (Object)secondsLeft);
            this.scheduledFuture = executor.schedule(this::checkToShowWarning, secondsLeft, TimeUnit.SECONDS);
        } else {
            LOG.warn("Cannot schedule next check for {}, as no expiration time is available.", (Object)this.experiment.getName());
        }
    }

    private void checkToShowWarning() {
        if (this.warningShown) {
            LOG.trace("Expiration warning for {} already shown. Ignoring.", (Object)this.experiment.getName());
            return;
        }
        if (this.experiment.getExperimentState() != ExperimentState.TESTING_CONNECTIVITY && this.experiment.getExperimentState() != ExperimentState.READY) {
            LOG.debug("Not checking for expiration as experiment is currently {}", (Object)this.experiment.getExperimentState());
            return;
        }
        LOG.trace("Checking for expiration, as slice state is {}", (Object)this.experiment.getExperimentState());
        if (this.expirationWarningInstant == null) {
            LOG.info("Could not find a valid expiration time to compare against for experiment {}", (Object)this.experiment.getName());
            return;
        }
        assert (this.expirationWarningInstant.isBefore(Instant.now()));
        this.showExpirationWarning();
    }

    private void onExpirationTimesUpdated() {
        this.warningShown = false;
        NextExperimentExpiration nextExperimentExpiration = (NextExperimentExpiration)this.nextExperimentExpirationBinding.get();
        this.expirationWarningInstant = nextExperimentExpiration != null && nextExperimentExpiration.getFirstExpirationTime() != null ? nextExperimentExpiration.getFirstExpirationTime().minus(this.jFedPreferences.getExpirationWarningTime(), ChronoUnit.MINUTES) : null;
    }

    private void showExpirationWarning() {
        NextExperimentExpiration nextExperimentExpiration = (NextExperimentExpiration)this.nextExperimentExpirationBinding.get();
        assert (nextExperimentExpiration != null);
        assert (nextExperimentExpiration.getFirstExpirationTime() != null);
        Instant firstExpirationTime = nextExperimentExpiration.getFirstExpirationTime();
        if (firstExpirationTime == null) {
            LOG.warn("Could not show Expiration Warning because firstExpirationTime == null");
            return;
        }
        long fullMinutesUntilExpiration = Instant.now().until(firstExpirationTime, ChronoUnit.MINUTES);
        if (this.jFedPreferences.isExpirationWarningEnabled() && fullMinutesUntilExpiration >= 0L) {
            Window ownerWindow;
            StringBuilder message = new StringBuilder();
            if (nextExperimentExpiration.getFirstExpiringPart() == null) {
                message.append("The experiment '").append(this.experiment.getName()).append("' is");
            } else {
                message.append("The resources on ").append(nextExperimentExpiration.getFirstExpiringPart().getName()).append(" of experiment '").append(this.experiment.getName()).append("' are");
            }
            message.append(" expiring in less than ").append(fullMinutesUntilExpiration + 1L).append(" minutes.");
            Window window = ownerWindow = this.experimentViewController.getScene() == null ? null : this.experimentViewController.getScene().getWindow();
            if (ownerWindow != null) {
                Action renewAction = new Action("Renew now", event -> this.eventBus.post((Object)new RenewExperimentEvent(ownerWindow, this.experimentViewController.getExperimentController())));
                LOG.info("Showing expiration warning for experiment {} to user.", (Object)this.experiment.getName());
                Duration hideAfterDuration = Duration.millis((double)java.time.Duration.between(Instant.now(), nextExperimentExpiration.getFirstExpirationTime()).toMillis());
                if (hideAfterDuration.lessThan(Duration.seconds((double)20.0))) {
                    hideAfterDuration = Duration.seconds((double)20.0);
                }
                assert (ownerWindow != null);
                Duration finalHideAfterDuration = hideAfterDuration;
                Platform.runLater(() -> Notifications.create().title(nextExperimentExpiration.getFirstExpiringPart() == null ? "Experiment expiring!" : "Resources expiring!").text(message.toString()).action(new Action[]{renewAction}).hideAfter(finalHideAfterDuration).owner((Object)ownerWindow).showWarning());
            }
        } else {
            LOG.info("Not showing expiration warning, as user disabled it!");
        }
        this.warningShown = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.scheduledFuture.cancel(true);
    }
}

