/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice;

import be.iminds.ilabt.jfed.espec.model.ESpecStep;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentConnectivityTesterFactory;
import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experiment.ExperimentControllerFactory;
import be.iminds.ilabt.jfed.experiment.ExperimentControllerFactoryImpl;
import be.iminds.ilabt.jfed.experiment.ExperimentControllerListener;
import be.iminds.ilabt.jfed.experiment.ExperimentLinkTesterFactory;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.experiment.WaitForReadyTimeoutHandler;
import be.iminds.ilabt.jfed.experiment.events.ExperimentEvent;
import be.iminds.ilabt.jfed.experiment.events.ExperimentEventHandler;
import be.iminds.ilabt.jfed.experiment.events.ExperimentEventType;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.time.Instant;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class FunctionalityBlockingExperimentControllerFactory
implements ExperimentControllerFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FunctionalityBlockingExperimentControllerFactory.class);
    @Nonnull
    private final JFedGuiConfig guiConfig;
    @Nonnull
    private final ExperimentControllerFactory experimentControllerFactory;

    public FunctionalityBlockingExperimentControllerFactory(@Nonnull JFedGuiConfig guiConfig, @Nonnull ExperimentControllerFactory experimentControllerFactory) {
        this.guiConfig = guiConfig;
        this.experimentControllerFactory = experimentControllerFactory;
    }

    @Inject
    public FunctionalityBlockingExperimentControllerFactory(@Nonnull JFedGuiConfig guiConfig, @Nonnull ExperimentControllerFactoryImpl experimentControllerFactory) {
        this.guiConfig = guiConfig;
        this.experimentControllerFactory = experimentControllerFactory;
    }

    private boolean hasAnyDisabledFunctions() {
        return this.guiConfig.isExperimentDeleteDisabled() || this.guiConfig.isExperimentActionDisabled() || this.guiConfig.isExperimentRenewDisabled() || this.guiConfig.isExperimentStartDisabled();
    }

    public ExperimentController createExperimentController(Experiment experiment) {
        if (this.hasAnyDisabledFunctions()) {
            return new LimitedExperimentController(this.guiConfig, this.experimentControllerFactory.createExperimentController(experiment));
        }
        return this.experimentControllerFactory.createExperimentController(experiment);
    }

    private static class LimitedExperimentController
    implements ExperimentController {
        @Nonnull
        private final JFedGuiConfig guiConfig;
        @Nonnull
        private final ExperimentController experimentController;

        public LimitedExperimentController(@Nonnull JFedGuiConfig guiConfig, @Nonnull ExperimentController experimentController) {
            this.guiConfig = guiConfig;
            this.experimentController = experimentController;
        }

        public void onExperimentStateChange(ExperimentState newExperimentState) {
            this.experimentController.onExperimentStateChange(newExperimentState);
        }

        public void onExperimentPartAdded(ExperimentPart experimentPart) {
            this.experimentController.onExperimentPartAdded(experimentPart);
        }

        public void start() {
            LOG.info("LimitedExperimentController constructor starts experiment. guiConfig.isExperimentStartDisabled()={}", (Object)this.guiConfig.isExperimentStartDisabled());
            if (this.guiConfig.isExperimentStartDisabled()) {
                return;
            }
            this.experimentController.start();
        }

        public CompletableFuture<Void> createSlice() {
            LOG.info("LimitedExperimentController.createSlice guiConfig.isExperimentStartDisabled()={}", (Object)this.guiConfig.isExperimentStartDisabled());
            if (this.guiConfig.isExperimentStartDisabled()) {
                return null;
            }
            return this.experimentController.createSlice();
        }

        public CompletableFuture<Void> requestUpdate() {
            return this.experimentController.requestUpdate();
        }

        public void shareWithUsers(@Nonnull List<GeniUrn> selectedUsers, boolean registerSshKeys) {
            if (this.guiConfig.isExperimentActionDisabled()) {
                return;
            }
            this.experimentController.shareWithUsers(selectedUsers, registerSshKeys);
        }

        public void unshareWithUsers(@Nonnull List<GeniUrn> selectedUsers, boolean unregisterSshKeys) {
            if (this.guiConfig.isExperimentActionDisabled()) {
                return;
            }
            this.experimentController.unshareWithUsers(selectedUsers, unregisterSshKeys);
        }

        public void updateSshKeys(@Nonnull List<UserSpec> userspec) {
            if (this.guiConfig.isExperimentActionDisabled()) {
                return;
            }
            this.experimentController.updateSshKeys(userspec);
        }

        public void reloadOS(Sliver sliver) {
            if (this.guiConfig.isExperimentActionDisabled()) {
                return;
            }
            this.experimentController.reloadOS(sliver);
        }

        public void createDiskImage(FXRspecNode node, String imageName, boolean global, boolean updatePrepare) {
            if (this.guiConfig.isExperimentActionDisabled()) {
                return;
            }
            this.experimentController.createDiskImage(node, imageName, global, updatePrepare);
        }

        public void stop(Collection<ExperimentPart> experimentParts) {
            if (this.guiConfig.isExperimentDeleteDisabled()) {
                return;
            }
            this.experimentController.stop(experimentParts);
        }

        public void stop() {
            if (this.guiConfig.isExperimentDeleteDisabled()) {
                return;
            }
            this.experimentController.stop();
        }

        public CompletableFuture<Boolean> testLinks() {
            return this.experimentController.testLinks();
        }

        public void reboot(Sliver sliver) {
            if (this.guiConfig.isExperimentActionDisabled()) {
                return;
            }
            this.experimentController.reboot(sliver);
        }

        public void reboot(ExperimentPart experimentPart) {
            if (this.guiConfig.isExperimentActionDisabled()) {
                return;
            }
            this.experimentController.reboot(experimentPart);
        }

        public void openConsole(Sliver sliver) {
            if (this.guiConfig.isExperimentActionDisabled()) {
                return;
            }
            this.experimentController.openConsole(sliver);
        }

        public void shareLan(FXRspecLink link, String sharedLanName) {
            if (this.guiConfig.isExperimentActionDisabled()) {
                return;
            }
            this.experimentController.shareLan(link, sharedLanName);
        }

        public void unshareLan(FXRspecLink link, String sharedLanName) {
            if (this.guiConfig.isExperimentActionDisabled()) {
                return;
            }
            this.experimentController.unshareLan(link, sharedLanName);
        }

        public CompletableFuture<Collection<UserSpec>> fetchSliceMemberSshKeys() {
            return this.experimentController.fetchSliceMemberSshKeys();
        }

        public CompletableFuture<ExperimentTaskStatus> renew(Instant newExpirationTime) {
            if (this.guiConfig.isExperimentRenewDisabled()) {
                return null;
            }
            return this.experimentController.renew(newExpirationTime);
        }

        public void renewParts(Instant newExpirationTime, Collection<ExperimentPart> parts) {
            if (this.guiConfig.isExperimentRenewDisabled()) {
                return;
            }
            this.experimentController.renewParts(newExpirationTime, parts);
        }

        public void waitForReady() {
            this.experimentController.waitForReady();
        }

        public void setupSoftware() {
            this.experimentController.setupSoftware();
        }

        public CompletableFuture<Boolean> rerunESpec(@Nullable ESpecStep startPosition, @Nullable ESpecStep stopPosition) {
            return this.experimentController.rerunESpec(startPosition, stopPosition);
        }

        @Nonnull
        public Experiment getExperiment() {
            return this.experimentController.getExperiment();
        }

        public void addListener(ExperimentControllerListener listener) {
            this.experimentController.addListener(listener);
        }

        public void removeListener(ExperimentControllerListener listener) {
            this.experimentController.removeListener(listener);
        }

        public ExperimentConnectivityTesterFactory getExperimentConnectivityTesterFactory() {
            return this.experimentController.getExperimentConnectivityTesterFactory();
        }

        public void setExperimentConnectivityTesterFactory(ExperimentConnectivityTesterFactory experimentConnectivityTesterFactory) {
            this.experimentController.setExperimentConnectivityTesterFactory(experimentConnectivityTesterFactory);
        }

        public void setExperimentLinkTesterFactory(ExperimentLinkTesterFactory experimentLinkTesterFactory) {
            this.experimentController.setExperimentLinkTesterFactory(experimentLinkTesterFactory);
        }

        public WaitForReadyTimeoutHandler getWaitForReadyTimeoutHandler() {
            return this.experimentController.getWaitForReadyTimeoutHandler();
        }

        public void setWaitForReadyTimeoutHandler(WaitForReadyTimeoutHandler waitForReadyTimeoutHandler) {
            this.experimentController.setWaitForReadyTimeoutHandler(waitForReadyTimeoutHandler);
        }

        public <T extends ExperimentEvent> void addEventHandler(ExperimentEventType<T> type, ExperimentEventHandler<T> eventHandler) {
            this.experimentController.addEventHandler(type, eventHandler);
        }
    }
}

