/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice;

import be.iminds.ilabt.jfed.experimenter_gui.canvas.ExperimentCanvas;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.experimenter_gui.util.ImageUtil;
import be.iminds.ilabt.jfed.rspec.model.WebVncService;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXGeantTestbedType;
import java.util.ArrayList;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GTSDetailsView
extends FlowPane {
    private static final Logger LOG = LoggerFactory.getLogger(GTSDetailsView.class);
    private final BrowserUtil browserUtil;
    private FXGeantTestbedType manifestGeantTestbedType = null;
    private Label noInfoLabel = new Label("No information available");

    public GTSDetailsView(BrowserUtil browserUtil) {
        this.setPrefWrapLength(300.0);
        this.setHgap(5.0);
        this.setVgap(5.0);
        this.browserUtil = browserUtil;
        this.setManifestGeantTestbedType(null);
    }

    public void setManifestGeantTestbedType(FXGeantTestbedType manifestGeantTestbedType) {
        this.manifestGeantTestbedType = manifestGeantTestbedType;
        ArrayList<Label> newChildren = new ArrayList<Label>();
        if (manifestGeantTestbedType == null) {
            newChildren.add(this.noInfoLabel);
        } else {
            manifestGeantTestbedType.getWebVncServices().stream().map(this::createGtsButton).forEach(newChildren::add);
        }
        this.getChildren().setAll(newChildren);
    }

    private Button createGtsButton(WebVncService webVnc) {
        Button button = new Button();
        button.getStylesheets().add((Object)ExperimentCanvas.class.getResource("canvas.css").toExternalForm());
        button.getStyleClass().add((Object)"canvas-node");
        ImageView imageView = new ImageView(new Image(ImageUtil.class.getResource("/images/gts_types/32/gts-node.png").toExternalForm()));
        imageView.setFitWidth(16.0);
        imageView.setFitHeight(16.0);
        button.setGraphic((Node)imageView);
        button.setText(webVnc.getProviderId());
        button.setOnAction(event -> {
            if (webVnc.getVncUrl() != null) {
                this.browserUtil.openUrlInBrowser(webVnc.getVncUrl());
            } else {
                new Alert(Alert.AlertType.WARNING, "No login info available", new ButtonType[0]).show();
            }
        });
        GTSDetailsView.updateGtsStyleClass(button, webVnc.getVncUrl() != null);
        return button;
    }

    private static void updateGtsStyleClass(Button button, boolean hasLoginInfo) {
        button.getStyleClass().removeAll((Object[])new String[]{"canvas-node-unknown", "canvas-node-ready", "canvas-node-changing", "canvas-node-unallocated", "canvas-node-uninitialised"});
        button.getStyleClass().add((Object)GTSDetailsView.statusToNodeStyleClass(hasLoginInfo));
    }

    private static String statusToNodeStyleClass(boolean hasLoginInfo) {
        if (hasLoginInfo) {
            return "canvas-node-ready";
        }
        return "canvas-node-changing";
    }
}

