/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice;

import be.iminds.ilabt.jfed.experimenter_gui.util.ui.MacWithDotsBinding;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.ReadOnlyTextFieldTableCell;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecInterface;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import java.util.ArrayList;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.util.Pair;
import javax.annotation.Nonnull;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkPropertiesDialog
extends VBox {
    private static final Logger LOG = LoggerFactory.getLogger(LinkPropertiesDialog.class);
    @FXML
    private TableView<Pair<FXRspecInterface, RspecInterface.IpAddress>> interfacesTableView;
    @FXML
    private TableColumn<Pair<FXRspecInterface, RspecInterface.IpAddress>, String> nodeIdTableColumn;
    @FXML
    private TableColumn<Pair<FXRspecInterface, RspecInterface.IpAddress>, String> ifaceIdTableColumn;
    @FXML
    private TableColumn<Pair<FXRspecInterface, RspecInterface.IpAddress>, String> ifaceIpTableColumn;
    @FXML
    private TableColumn<Pair<FXRspecInterface, RspecInterface.IpAddress>, String> ifaceNetmaskTableColumn;
    @FXML
    private TableColumn<Pair<FXRspecInterface, RspecInterface.IpAddress>, String> ifaceMacTableColumn;
    @FXML
    private HBox vlanTagBox;
    @FXML
    private TextField vlanTagTextField;
    private final FXRspecLink link;
    private final Dialog<ButtonType> dialog;

    public LinkPropertiesDialog(@Nonnull FXRspecLink link) {
        this.link = link;
        FXMLUtil.injectFXML((Object)((Object)this));
        DoubleBinding tableWidth = this.interfacesTableView.widthProperty().subtract(4);
        this.nodeIdTableColumn.prefWidthProperty().bind((ObservableValue)tableWidth.multiply(0.125));
        this.ifaceIdTableColumn.prefWidthProperty().bind((ObservableValue)tableWidth.multiply(0.125));
        this.ifaceIpTableColumn.prefWidthProperty().bind((ObservableValue)tableWidth.multiply(0.25));
        this.ifaceNetmaskTableColumn.prefWidthProperty().bind((ObservableValue)tableWidth.multiply(0.25));
        this.ifaceMacTableColumn.prefWidthProperty().bind((ObservableValue)tableWidth.multiply(0.25));
        this.nodeIdTableColumn.setCellValueFactory(param -> ((FXRspecInterface)((Pair)param.getValue()).getKey()).getNode().clientIdProperty());
        this.ifaceIdTableColumn.setCellValueFactory(param -> ((FXRspecInterface)((Pair)param.getValue()).getKey()).clientIdProperty());
        this.ifaceMacTableColumn.setCellValueFactory(param -> new MacWithDotsBinding((ObservableStringValue)((FXRspecInterface)((Pair)param.getValue()).getKey()).macAddressProperty()));
        this.ifaceIpTableColumn.setCellValueFactory(param -> new SimpleStringProperty(param != null && param.getValue() != null && ((Pair)param.getValue()).getValue() != null && ((RspecInterface.IpAddress)((Pair)param.getValue()).getValue()).getAddress() != null ? ((RspecInterface.IpAddress)((Pair)param.getValue()).getValue()).getAddress() : ""));
        this.ifaceNetmaskTableColumn.setCellValueFactory(param -> new SimpleStringProperty(param != null && param.getValue() != null && ((Pair)param.getValue()).getValue() != null && ((RspecInterface.IpAddress)((Pair)param.getValue()).getValue()).getNetmask() != null ? ((RspecInterface.IpAddress)((Pair)param.getValue()).getValue()).getNetmask() : ""));
        this.interfacesTableView.prefHeightProperty().bind((ObservableValue)Bindings.size((ObservableList)this.interfacesTableView.getItems()).multiply(28).add(37));
        this.ifaceIpTableColumn.setCellFactory(ReadOnlyTextFieldTableCell.forTableColumn());
        this.ifaceNetmaskTableColumn.setCellFactory(ReadOnlyTextFieldTableCell.forTableColumn());
        this.ifaceMacTableColumn.setCellFactory(ReadOnlyTextFieldTableCell.forTableColumn());
        ArrayList<Pair> ifaceWithAddressCombos = new ArrayList<Pair>();
        for (FXRspecInterface iface : link.getInterfaces()) {
            if (!iface.getIpAddresses().isEmpty()) {
                for (RspecInterface.IpAddress ipAddress : iface.getIpAddresses()) {
                    ifaceWithAddressCombos.add(new Pair((Object)iface, (Object)ipAddress));
                }
                continue;
            }
            ifaceWithAddressCombos.add(new Pair((Object)iface, null));
        }
        if (ifaceWithAddressCombos.isEmpty()) {
            this.interfacesTableView.setVisible(false);
            this.interfacesTableView.setManaged(false);
        } else {
            this.interfacesTableView.getItems().addAll(ifaceWithAddressCombos);
        }
        if (link.getVlanTag() != null) {
            this.vlanTagTextField.setText(link.getVlanTag().toString());
        } else {
            this.vlanTagBox.setVisible(false);
            this.vlanTagBox.setManaged(false);
        }
        DialogPane dialogPane = new DialogPane();
        dialogPane.setContent((Node)this);
        dialogPane.setHeaderText("Properties of " + link.getClientId());
        dialogPane.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.INFO, (Color)Color.BLACK));
        dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        this.dialog = new Dialog();
        this.dialog.setDialogPane(dialogPane);
        this.dialog.setTitle(dialogPane.getHeaderText());
        this.dialog.setHeaderText(this.dialog.getTitle());
        this.dialog.setResizable(true);
    }

    public void showDialog() {
        LOG.debug("\"Show Link Info\" -> link info showing dialog");
        this.dialog.show();
    }
}

