/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentChangeListener;
import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.AddressPoolCanvasNode;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.RspecCanvasLink;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.RspecCanvasNode;
import be.iminds.ilabt.jfed.experimenter_gui.slice.SliceExperimentCanvas;
import be.iminds.ilabt.jfed.experimenter_gui.slice.SliceExperimentCanvasFactory;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecFactoryFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXAddressPool;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecInterface;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.List;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelSliceView
extends BorderPane
implements ExperimentChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(ModelSliceView.class);
    private final ExperimentController experimentController;
    private final Experiment experiment;
    private final TestbedInfoSource testbedInfoSource;
    private final SliceExperimentCanvasFactory sliceExperimentCanvasFactory;
    private final BrowserUtil browserUtil;
    private final SliceExperimentCanvas experimentCanvas;
    private Slice slice;
    private final FXModelRspec canvasModel;
    private final InvalidationListener sliceStatusListener = observable -> {
        if (Platform.isFxApplicationThread()) {
            this.updateStatus();
        } else {
            Platform.runLater(this::updateStatus);
        }
    };

    ModelSliceView(ExperimentController experimentController, ManifestRspecSource canvasRspecSource, TestbedInfoSource testbedInfoSource, SliceExperimentCanvasFactory sliceExperimentCanvasFactory, BrowserUtil browserUtil) {
        this.experimentController = experimentController;
        this.browserUtil = browserUtil;
        this.experiment = experimentController.getExperiment();
        this.testbedInfoSource = testbedInfoSource;
        this.sliceExperimentCanvasFactory = sliceExperimentCanvasFactory;
        this.canvasModel = (FXModelRspec)canvasRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        assert (this.canvasModel != null);
        if (this.canvasModel == null) {
            throw new RuntimeException("Failed to convert RSpec to FXModelRspec");
        }
        this.experimentCanvas = sliceExperimentCanvasFactory.createSliceExperimentCanvas(experimentController, this.canvasModel);
        if (!ModelSliceView.areAllNodePositionsDefined((ModelRspec)this.canvasModel)) {
            this.experimentCanvas.autoLayout();
        }
        this.setCenter((Node)this.experimentCanvas);
        for (FXRspecNode node : this.canvasModel.getNodes()) {
            if (this.isFakeAuthority(node.getComponentManagerId())) {
                this.setRspecNodeStatus(node, StatusDetails.SliverStatus.READY, false, false);
                continue;
            }
            this.setRspecNodeStatus(node, StatusDetails.SliverStatus.UNKNOWN, false, false);
        }
        this.canvasModel.getAddressPools().forEach(addressPool -> this.setAddressPoolStatus((FXAddressPool)addressPool, StatusDetails.SliverStatus.UNKNOWN));
        this.experiment.addExperimentChangeListener((ExperimentChangeListener)this);
        if (this.experiment.getSliceOrNull() != null) {
            this.initializeSlice(this.experiment.getSliceOrNull());
        }
    }

    public void handleManifestChange(ManifestRspecSource newManifestSource) {
        ImmutableModelRspec newModel = newManifestSource.getImmutableModelRspec();
        if (newModel == null) {
            return;
        }
        RspecFactory fact = RspecFactoryFactory.getRspecFactoryInstance((ModelRspecType)this.canvasModel.getModelRspecType());
        for (RspecNode node : newModel.getNodes()) {
            if (this.canvasModel.getNodeByUniqueId(node.getUniqueId()) != null || this.canvasModel.getNodeByClientId(node.getClientId()) != null) continue;
            RspecNode newNode = fact.copyNode((ModelRspec)this.canvasModel, node, RspecNode.InterfaceCopyMethod.NO_COPY);
            if (newNode.getEditorX() <= 0.0 && newNode.getEditorY() <= 0.0) {
                newNode.setEditorX(50.0 + Math.random() * 400.0);
                newNode.setEditorY(50.0 + Math.random() * 400.0);
            }
            this.canvasModel.addNode(newNode);
        }
    }

    public static boolean areAllNodePositionsDefined(ModelRspec model) {
        for (RspecNode node : model.getNodes()) {
            if (node.getEditorX() != -1.0 || node.getEditorY() != -1.0) continue;
            return false;
        }
        return true;
    }

    public static boolean areNodePositionsOutsideWindow(ModelRspec model, double maxWidth, double maxHeight) {
        double marginX = 50.0;
        double marginY = 20.0;
        for (RspecNode node : model.getNodes()) {
            if (!(node.getEditorX() <= marginX || node.getEditorY() <= marginY || node.getEditorX() >= maxWidth - marginX) && !(node.getEditorY() >= maxHeight - marginY)) continue;
            return true;
        }
        return false;
    }

    public boolean areNodePositionsOutsideWindow(ModelRspec model) {
        double maxWidth = this.experimentCanvas.getViewportBounds().getWidth();
        double maxHeight = this.experimentCanvas.getViewportBounds().getHeight();
        return ModelSliceView.areNodePositionsOutsideWindow(model, maxWidth, maxHeight);
    }

    private void initializeSlice(@Nonnull Slice slice) {
        assert (this.slice == null) : "Slice can only be assigned once!";
        this.slice = slice;
        slice.statusProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.sliceStatusListener));
        slice.manifestRspecProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.sliceStatusListener));
        slice.manifestRspecProperty().addListener((ob, old, nw) -> this.handleManifestChange((ManifestRspecSource)nw));
    }

    public void updateStatus() {
        assert (this.slice != null);
        FXModelRspec modelRspec = null;
        if (this.slice.getManifestRspec() != null) {
            modelRspec = (FXModelRspec)this.slice.getManifestRspec().getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        }
        if (modelRspec == null && this.slice.getRequestRspec() != null) {
            modelRspec = (FXModelRspec)this.slice.getRequestRspec().getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        }
        if (modelRspec == null) {
            LOG.error("Cannot update sliverStatus, as there is no modelRspec available.");
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Updating ModelSliceView status with {}", (Object)(this.slice.getStatus() != null ? this.slice.getStatus().detailedToString() : "slice.getStatus() == null"));
        }
        modelRspec.getNodes().forEach(this::updateRspecNodeStatus);
        modelRspec.getLinks().forEach(this::updateRspecLinkStatus);
        modelRspec.getAddressPools().forEach(this::updateAddressPoolStatus);
    }

    private void updateAddressPoolStatus(FXAddressPool manifestAddressPool) {
        assert (this.slice != null);
        FXAddressPool canvasAddressPool = this.canvasModel.getAddressPoolByClientId(manifestAddressPool.getClientId());
        if (canvasAddressPool == null) {
            LOG.warn("Could not find canvasAddressPool for addresspool {}", (Object)manifestAddressPool.getClientId());
            return;
        }
        StatusDetails statusDetails = this.slice.getStatus();
        if (statusDetails != null) {
            this.setAddressPoolStatus(canvasAddressPool, statusDetails.getGlobalStatus());
        }
    }

    private void setAddressPoolStatus(FXAddressPool canvasAddressPool, StatusDetails.SliverStatus status) {
        assert (canvasAddressPool != null);
        LOG.debug("Canvas: Setting status of addresspool {} to {}", (Object)canvasAddressPool.getClientId(), (Object)(status != null ? status.name() : "null"));
        AddressPoolCanvasNode addressPoolCanvasNode = this.experimentCanvas.getAddressPoolCanvasNode(canvasAddressPool);
        for (StatusDetails.SliverStatus s : StatusDetails.SliverStatus.values()) {
            addressPoolCanvasNode.getStyleClass().remove((Object)SliceExperimentCanvas.statusToAddressPoolStyleClass(s));
        }
        addressPoolCanvasNode.getStyleClass().add((Object)SliceExperimentCanvas.statusToAddressPoolStyleClass(status));
    }

    private boolean isFakeAuthority(GeniUrn authUrn) {
        Server auth = this.testbedInfoSource.getByUrn(authUrn, TestbedInfoSource.SubAuthMatchAllowed.ALLOW_TOPLEVEL, TestbedInfoSource.SubAuthMatchPreference.PREFER_EXACT_SUBAUTHORITY);
        if (auth == null) {
            LOG.warn("Could not retrieve an authority for urn '{}'", (Object)authUrn);
        }
        return auth != null && auth.isEdgeVlan();
    }

    private void updateRspecNodeStatus(FXRspecNode manifestRspecNode) {
        StatusDetails.SliverStatus nodeStatus;
        assert (this.slice != null);
        FXRspecNode canvasNode = this.canvasModel.getNodeByUniqueId(manifestRspecNode.getUniqueId());
        if (manifestRspecNode.getClientId() != null && canvasNode == null) {
            canvasNode = this.canvasModel.getNodeByClientId(manifestRspecNode.getClientId());
            LOG.debug("Could not find a matching node in canvas-view for node {} while using uniqueId, doing fallback to clientId. Selected node is: {}", (Object)manifestRspecNode.getUniqueId(), (Object)(canvasNode != null ? canvasNode.getUniqueId() : "<NO NODE FOUND>"));
        }
        if (canvasNode == null) {
            LOG.warn("Could not find matching node AT ALL in canvas-view for node {}", (Object)manifestRspecNode.getUniqueId());
            return;
        }
        StatusDetails status = this.slice.getStatus();
        if (status != null) {
            if (this.isFakeAuthority(manifestRspecNode.getComponentManagerId())) {
                nodeStatus = status.getGlobalStatus() == StatusDetails.SliverStatus.UNALLOCATED ? StatusDetails.SliverStatus.UNALLOCATED : StatusDetails.SliverStatus.READY;
            } else if (manifestRspecNode.getComponentId() != null && status.hasComponentStatus(manifestRspecNode.getComponentId())) {
                nodeStatus = status.getNodeStatusByComponentUrn(manifestRspecNode.getComponentId());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Status node {} is {} according to nodeStatusByComponentUrn", (Object)manifestRspecNode.getUniqueId(), (Object)nodeStatus);
                }
            } else if (manifestRspecNode.getSliverId() != null && status.hasSliverStatus(manifestRspecNode.getSliverId())) {
                nodeStatus = status.getStatusBySliverUrn(manifestRspecNode.getSliverId());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Status node {} is {} according to getStatusBySliverUrn", (Object)manifestRspecNode.getUniqueId(), (Object)nodeStatus);
                }
            } else {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Current status: {}", (Object)status.detailedToString());
                }
                if (manifestRspecNode.getComponentManagerId() != null) {
                    List slivers = this.slice.findSlivers(manifestRspecNode.getComponentManagerId());
                    StatusDetails.SliverStatus sliversStatus = StatusDetails.SliverStatus.READY;
                    boolean validStatus = false;
                    for (Sliver sliver : slivers) {
                        if (!status.hasSliverStatus(sliver.getUrn())) continue;
                        sliversStatus = StatusDetails.SliverStatus.merge((StatusDetails.SliverStatus)sliversStatus, (StatusDetails.SliverStatus)status.getStatusBySliverUrn(sliver.getUrn()));
                        validStatus = true;
                    }
                    if (validStatus) {
                        nodeStatus = sliversStatus;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Status node {} is {} according to getStatusBySliverUrn VIA AUTHORITY", (Object)manifestRspecNode.getUniqueId(), (Object)nodeStatus);
                        }
                    } else {
                        nodeStatus = status.getGlobalStatus();
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Status node {} is {} according to slice.globalStatus because no slivers available", (Object)manifestRspecNode.getUniqueId(), (Object)nodeStatus);
                        }
                    }
                } else {
                    nodeStatus = status.getGlobalStatus();
                }
            }
        } else {
            LOG.trace("slice.getStatus() is null -> unknown nodeStatus");
            nodeStatus = StatusDetails.SliverStatus.UNKNOWN;
        }
        if (nodeStatus == StatusDetails.SliverStatus.CHANGING && status.getGlobalStatus() == StatusDetails.SliverStatus.FAIL) {
            nodeStatus = StatusDetails.SliverStatus.FAIL;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Status node {} was changed to FAILED because global status is FAIL", (Object)manifestRspecNode.getUniqueId());
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Setting {} to status {} with loginServices available = {}", new Object[]{canvasNode.getUniqueId(), nodeStatus, !manifestRspecNode.getLoginServices().isEmpty()});
        }
        this.setRspecNodeStatus(canvasNode, nodeStatus, !manifestRspecNode.getLoginServices().isEmpty(), false);
    }

    private void updateRspecLinkStatus(FXRspecLink manifestRspecLink) {
        assert (this.slice != null);
        StatusDetails status = this.slice.getStatus();
        if (status == null) {
            return;
        }
        StatusDetails.SliverStatus linkStatus = StatusDetails.SliverStatus.READY;
        if (!manifestRspecLink.isStitched(this.testbedInfoSource) && manifestRspecLink.getSliverId() != null && status.hasSliverStatus(manifestRspecLink.getSliverId())) {
            linkStatus = status.getStatusBySliverUrn(manifestRspecLink.getSliverId());
        } else if (!manifestRspecLink.getComponentManagerUrns().isEmpty()) {
            for (GeniUrn cmUrn : manifestRspecLink.getComponentManagerUrns()) {
                if (this.isFakeAuthority(cmUrn)) continue;
                List slivers = this.slice.findSlivers(cmUrn);
                if (!slivers.isEmpty()) {
                    for (Sliver sliver : slivers) {
                        boolean hasLinks;
                        boolean hasNodes = sliver.getNodes() != null && !sliver.getNodes().isEmpty();
                        boolean bl = hasLinks = sliver.getLinks() != null && !sliver.getLinks().isEmpty();
                        if (!hasNodes && hasLinks) continue;
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Updating status of link {} from {} to {} because of sliver {} with status {}", new Object[]{manifestRspecLink.getUniqueId(), linkStatus, StatusDetails.SliverStatus.merge((StatusDetails.SliverStatus)linkStatus, (StatusDetails.SliverStatus)sliver.getStatus().getGlobalStatus()), sliver.getUrn(), sliver.getStatus().getGlobalStatus()});
                        }
                        linkStatus = StatusDetails.SliverStatus.merge((StatusDetails.SliverStatus)linkStatus, (StatusDetails.SliverStatus)sliver.getStatus().getGlobalStatus());
                    }
                    continue;
                }
                linkStatus = StatusDetails.SliverStatus.merge((StatusDetails.SliverStatus)linkStatus, (StatusDetails.SliverStatus)StatusDetails.SliverStatus.UNINITIALISED);
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Setting statusByCMs to UNINITIALISED because no slivers for {} could be found", (Object)cmUrn);
            }
        }
        FXRspecLink canvasLink = this.canvasModel.getLinkByUniqueId(manifestRspecLink.getUniqueId());
        if (canvasLink == null) {
            canvasLink = this.canvasModel.getLinkByUniqueId(manifestRspecLink.getPreStitchingUniqueId());
        }
        if (manifestRspecLink.getClientId() != null && canvasLink == null) {
            LOG.trace("Could not match link with uniqueId {}, reverting to clientId", (Object)manifestRspecLink.getUniqueId());
            canvasLink = this.canvasModel.getLinkByClientId(manifestRspecLink.getClientId());
        }
        if (canvasLink != null) {
            this.setRspecLinkStatus(canvasLink, linkStatus);
        } else {
            LOG.warn("Could not find matching canvas link for {}", (Object)manifestRspecLink.getUniqueId());
        }
        for (FXRspecInterface manifestRspecIface : manifestRspecLink.getInterfaces()) {
            FXRspecInterface canvasIface = this.canvasModel.getInterfaceByUniqueId(manifestRspecIface.getUniqueId());
            if (canvasIface == null) {
                LOG.warn("Could not find matching interface in canvas-view for iface {}, reverting to clientId", (Object)manifestRspecIface.getUniqueId());
                canvasIface = this.canvasModel.getInterfaceByClientId(manifestRspecIface.getClientId());
            }
            if (canvasIface == null) {
                LOG.warn("Could not find matching interface in canvas-view for clientId {}", (Object)manifestRspecIface.getClientId());
                continue;
            }
            StatusDetails.SliverStatus ifaceStatus = linkStatus;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Status iface {} is {} according fallback to link-status", (Object)manifestRspecIface.getUniqueId(), (Object)ifaceStatus);
            }
            this.setRspecIfaceStatus(canvasIface, ifaceStatus);
        }
    }

    private void setRspecNodeStatus(FXRspecNode canvasRspecNode, StatusDetails.SliverStatus status, boolean loginServiceAvailable, boolean reservationFailed) {
        RspecCanvasNode canvasNode;
        if (LOG.isTraceEnabled()) {
            LOG.trace("setRspecNodeStatus: Setting status of node {} to {} with loginServices available = {}, reservationFailed = {}", new Object[]{canvasRspecNode.getUniqueId(), status != null ? status.name() : "null", loginServiceAvailable, reservationFailed});
        }
        if ((canvasNode = this.experimentCanvas.getRspecCanvasNode(canvasRspecNode)) == null) {
            LOG.warn("setRspecNodeStatus: Could not find a RspecCanvasNode for rspecNode with UniqueID {}. Ignoring status-update.", (Object)canvasRspecNode.getUniqueId());
            return;
        }
        for (SliceExperimentCanvas.NodeStatus s : SliceExperimentCanvas.NodeStatus.values()) {
            canvasNode.getStyleClass().remove((Object)SliceExperimentCanvas.statusToNodeStyleClass(s));
        }
        canvasNode.getStyleClass().add((Object)SliceExperimentCanvas.statusToNodeStyleClass(SliceExperimentCanvas.NodeStatus.fromSliverStatus(status, loginServiceAvailable, reservationFailed)));
    }

    private void setRspecIfaceStatus(FXRspecInterface rspecIface, StatusDetails.SliverStatus status) {
        RspecCanvasLink canvasLink;
        RspecCanvasLink.InterfaceLink ifaceLink;
        if (LOG.isTraceEnabled()) {
            LOG.trace("Canvas: Setting status of iface {} to {}", (Object)rspecIface.getClientId(), (Object)(status != null ? status.name() : "null"));
        }
        if (rspecIface.isLinkBound() && (ifaceLink = (canvasLink = this.experimentCanvas.getRspecCanvasLink(rspecIface.getLink())).getInterfaceLinkByRspecInterface(rspecIface)) != null) {
            for (StatusDetails.SliverStatus s : StatusDetails.SliverStatus.values()) {
                ifaceLink.getStyleClass().remove((Object)SliceExperimentCanvas.statusToInterfaceStyleClass(s));
            }
            ifaceLink.getStyleClass().add((Object)SliceExperimentCanvas.statusToInterfaceStyleClass(status));
        }
    }

    private void setRspecLinkStatus(FXRspecLink rspecLink, StatusDetails.SliverStatus status) {
        assert (rspecLink != null);
        LOG.debug("Canvas: Setting status of link {} to {}", (Object)rspecLink.getUniqueId(), (Object)(status != null ? status.name() : "null"));
        RspecCanvasLink canvasLink = this.experimentCanvas.getRspecCanvasLink(rspecLink);
        for (StatusDetails.SliverStatus s : StatusDetails.SliverStatus.values()) {
            canvasLink.getLinkCenter().getStyleClass().remove((Object)SliceExperimentCanvas.statusToLinkCenterStyleClass(s));
        }
        canvasLink.getLinkCenter().getStyleClass().add((Object)SliceExperimentCanvas.statusToLinkCenterStyleClass(status));
    }

    public SliceExperimentCanvas getCanvas() {
        return this.experimentCanvas;
    }

    public void onExperimentStateChange(ExperimentState newExperimentState) {
        if (this.slice == null && newExperimentState != ExperimentState.PENDING) {
            if (this.experiment.getSliceOrNull() != null) {
                this.initializeSlice(this.experiment.getSliceOrNull());
            } else {
                LOG.error("Expected a slice to be presend in the Experiment-object. Has register slice failed?");
            }
        }
        if (this.slice != null) {
            Platform.runLater(this::updateStatus);
        }
    }

    public void onExperimentPartAdded(ExperimentPart experimentPart) {
    }

    public FXModelRspec getModelRspec() {
        return this.canvasModel;
    }
}

