/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice;

import be.iminds.ilabt.jfed.experimenter_gui.util.ui.MacWithDotsBinding;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.ReadOnlyTextFieldTableCell;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.DiskImage;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecInterface;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.ssh_terminal_tool.ExternalSshTerminal;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.util.common.OSDetector;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableStringValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.util.Pair;
import javafx.util.StringConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodePropertiesDialog
extends GridPane {
    private static final Logger LOG = LoggerFactory.getLogger(NodePropertiesDialog.class);
    @Nonnull
    private final Slice slice;
    @Nonnull
    private final FXRspecNode node;
    @Nullable
    private final BasicStringRspec.LoginService bestLoginService;
    @Nonnull
    private final List<BasicStringRspec.LoginService> loginServices;
    @Nonnull
    private final ExternalSshTerminal externalSshTerminal;
    @FXML
    private ComboBox<BasicStringRspec.LoginService> loginCombobox;
    @FXML
    private GridPane loginDetailsPane;
    @FXML
    private Label authenticationTypeLabel;
    @FXML
    private TextField hostnameTextField;
    @FXML
    private TextField usernameTextField;
    @FXML
    private TextField portTextField;
    @FXML
    private TextArea cliSshTextArea;
    @FXML
    private Label sliverTypeLabel;
    @FXML
    private TextField diskImageTextField;
    @FXML
    private TextField compUrnTextField;
    @FXML
    private TableView<Pair<FXRspecInterface, RspecInterface.IpAddress>> interfacesTableView;
    @FXML
    private TableColumn<Pair<FXRspecInterface, RspecInterface.IpAddress>, String> ifaceIdTableColumn;
    @FXML
    private TableColumn<Pair<FXRspecInterface, RspecInterface.IpAddress>, String> ifaceIpTableColumn;
    @FXML
    private TableColumn<Pair<FXRspecInterface, RspecInterface.IpAddress>, String> ifaceNetmaskTableColumn;
    @FXML
    private TableColumn<Pair<FXRspecInterface, RspecInterface.IpAddress>, String> ifaceMacTableColumn;
    @FXML
    private TableColumn<Pair<FXRspecInterface, RspecInterface.IpAddress>, String> ifaceLinkTableColumn;
    private final Dialog<ButtonType> dialog;

    NodePropertiesDialog(@Nonnull Slice slice, @Nonnull FXRspecNode node, @Nullable BasicStringRspec.LoginService bestLoginService, @Nonnull List<BasicStringRspec.LoginService> loginServices, @Nonnull ExternalSshTerminal externalSshTerminal) {
        assert (loginServices.isEmpty() || bestLoginService != null);
        this.slice = slice;
        this.node = node;
        this.bestLoginService = bestLoginService;
        this.loginServices = loginServices;
        this.externalSshTerminal = externalSshTerminal;
        FXMLUtil.injectFXML((Object)((Object)this));
        DoubleBinding tableWidth = this.interfacesTableView.widthProperty().subtract(4);
        this.ifaceIdTableColumn.prefWidthProperty().bind((ObservableValue)tableWidth.multiply(0.125));
        this.ifaceIpTableColumn.prefWidthProperty().bind((ObservableValue)tableWidth.multiply(0.25));
        this.ifaceNetmaskTableColumn.prefWidthProperty().bind((ObservableValue)tableWidth.multiply(0.25));
        this.ifaceMacTableColumn.prefWidthProperty().bind((ObservableValue)tableWidth.multiply(0.25));
        this.ifaceLinkTableColumn.prefWidthProperty().bind((ObservableValue)tableWidth.multiply(0.125));
        this.ifaceIdTableColumn.setCellValueFactory(param -> ((FXRspecInterface)((Pair)param.getValue()).getKey()).clientIdProperty());
        this.ifaceMacTableColumn.setCellValueFactory(param -> new MacWithDotsBinding((ObservableStringValue)((FXRspecInterface)((Pair)param.getValue()).getKey()).macAddressProperty()));
        this.ifaceIpTableColumn.setCellValueFactory(param -> new SimpleStringProperty(param.getValue() != null && ((Pair)param.getValue()).getValue() != null && ((RspecInterface.IpAddress)((Pair)param.getValue()).getValue()).getAddress() != null ? ((RspecInterface.IpAddress)((Pair)param.getValue()).getValue()).getAddress() : ""));
        this.ifaceNetmaskTableColumn.setCellValueFactory(param -> new SimpleStringProperty(param.getValue() != null && ((Pair)param.getValue()).getValue() != null && ((RspecInterface.IpAddress)((Pair)param.getValue()).getValue()).getNetmask() != null ? ((RspecInterface.IpAddress)((Pair)param.getValue()).getValue()).getNetmask() : ""));
        this.ifaceLinkTableColumn.setCellValueFactory(param -> {
            try {
                return new SimpleStringProperty(param.getValue() != null && ((Pair)param.getValue()).getKey() != null && ((FXRspecInterface)((Pair)param.getValue()).getKey()).getLink() != null && ((FXRspecInterface)((Pair)param.getValue()).getKey()).getLink().getClientId() != null ? ((FXRspecInterface)((Pair)param.getValue()).getKey()).getLink().getClientId() : "");
            }
            catch (Exception e) {
                LOG.error("Exception showing link info in table", (Throwable)e);
                return new SimpleStringProperty("**ERROR**");
            }
        });
        this.interfacesTableView.prefHeightProperty().bind((ObservableValue)Bindings.size((ObservableList)this.interfacesTableView.getItems()).multiply(28).add(37));
        this.ifaceIpTableColumn.setCellFactory(ReadOnlyTextFieldTableCell.forTableColumn());
        this.ifaceNetmaskTableColumn.setCellFactory(ReadOnlyTextFieldTableCell.forTableColumn());
        this.ifaceMacTableColumn.setCellFactory(ReadOnlyTextFieldTableCell.forTableColumn());
        if (!this.loginServices.isEmpty()) {
            this.loginDetailsPane.setVisible(true);
            if (this.loginServices.size() > 1) {
                this.loginCombobox.setConverter((StringConverter)new StringConverter<BasicStringRspec.LoginService>(){

                    public String toString(BasicStringRspec.LoginService ls) {
                        return ls.toDescription(true, false);
                    }

                    public BasicStringRspec.LoginService fromString(String string) {
                        throw new RuntimeException("Cannot convert from String to LoginService");
                    }
                });
                this.loginCombobox.getItems().setAll(this.loginServices);
                if (this.bestLoginService != null) {
                    this.loginCombobox.getSelectionModel().select((Object)this.bestLoginService);
                    this.showLoginInfo(this.bestLoginService);
                }
                this.loginCombobox.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, newValue) -> {
                    if (newValue != null) {
                        this.showLoginInfo((BasicStringRspec.LoginService)newValue);
                    }
                });
            } else {
                if (this.bestLoginService != null) {
                    this.showLoginInfo(this.bestLoginService);
                }
                this.loginCombobox.setVisible(false);
            }
        } else {
            this.loginCombobox.setVisible(false);
            this.cliSshTextArea.setVisible(false);
            this.loginDetailsPane.setVisible(false);
        }
        if (node.getSliverType() != null) {
            this.sliverTypeLabel.setVisible(true);
            this.sliverTypeLabel.setText(node.getSliverTypeName());
            if (node.getSliverType().getDiskImages().isEmpty()) {
                this.diskImageTextField.setVisible(true);
                this.diskImageTextField.setText("<Testbed Default>");
                this.diskImageTextField.setDisable(true);
            } else {
                this.showDiskImageInfo((DiskImage)node.getSliverType().getDiskImages().get(0));
            }
        } else {
            this.sliverTypeLabel.setVisible(false);
            this.diskImageTextField.setVisible(false);
        }
        if (node.getComponentId() != null) {
            this.compUrnTextField.setVisible(true);
            this.compUrnTextField.setText(node.getComponentId().toString());
        } else {
            this.compUrnTextField.setVisible(false);
        }
        ArrayList<Pair> ifaceWithAddressCombos = new ArrayList<Pair>();
        for (FXRspecInterface iface : node.getInterfaces()) {
            if (!iface.getIpAddresses().isEmpty()) {
                for (RspecInterface.IpAddress ipAddress : iface.getIpAddresses()) {
                    ifaceWithAddressCombos.add(new Pair((Object)iface, (Object)ipAddress));
                }
                continue;
            }
            ifaceWithAddressCombos.add(new Pair((Object)iface, null));
        }
        if (ifaceWithAddressCombos.isEmpty()) {
            this.interfacesTableView.setVisible(false);
        } else {
            this.interfacesTableView.getItems().addAll(ifaceWithAddressCombos);
        }
        DialogPane dialogPane = new DialogPane();
        dialogPane.setContent((Node)this);
        dialogPane.setHeaderText("Properties of " + node.getClientId());
        dialogPane.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.INFO, (Color)Color.BLACK));
        dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        this.dialog = new Dialog();
        this.dialog.setDialogPane(dialogPane);
        this.dialog.setTitle(dialogPane.getHeaderText());
        this.dialog.setHeaderText(this.dialog.getTitle());
        this.dialog.setResizable(true);
    }

    private void showDiskImageInfo(@Nonnull DiskImage diskImage) {
        if (diskImage.getName() != null) {
            this.diskImageTextField.setVisible(true);
            this.diskImageTextField.setDisable(false);
            this.diskImageTextField.setText(diskImage.getName());
            return;
        }
        if (diskImage.getUrl() != null) {
            this.diskImageTextField.setVisible(true);
            this.diskImageTextField.setDisable(false);
            this.diskImageTextField.setText(diskImage.getUrl());
            return;
        }
        this.diskImageTextField.setVisible(false);
    }

    private void showLoginInfo(BasicStringRspec.LoginService loginService) {
        this.authenticationTypeLabel.setText(loginService.getAuthentication());
        this.hostnameTextField.setText(loginService.getHostname());
        this.portTextField.setText("" + loginService.getPort());
        this.usernameTextField.setText(loginService.getUsername());
        if (OSDetector.getUnixLikeOsFilter().includedOs(OSDetector.os)) {
            try {
                String cli = this.getCliSshCommand(loginService);
                this.cliSshTextArea.setText(cli);
            }
            catch (Exception e) {
                LOG.error("Something went wrong generating the SSH command line.");
                this.cliSshTextArea.setText("(error generating ssh command)");
            }
        } else {
            this.cliSshTextArea.setVisible(false);
        }
    }

    @Nonnull
    private String getCliSshCommand(@Nonnull BasicStringRspec.LoginService loginService) {
        return this.externalSshTerminal.getCliSshCommand(loginService.getUsername(), loginService.getHostname(), loginService.getPort(), (JFedConnection.ProxyInfo)loginService.getSshProxy());
    }

    public void showDialog() {
        this.dialog.show();
    }
}

