/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice;

import be.iminds.ilabt.jfed.experimenter_gui.slice.NodePropertiesDialog;
import be.iminds.ilabt.jfed.experimenter_gui.util.SSHTerminalUtil;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.ssh_terminal_tool.ExternalSshTerminal;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class NodePropertiesDialogFactory {
    private final GeniUserProvider geniUserProvider;
    private final ExternalSshTerminal externalSshTerminal;
    private final SSHTerminalUtil sshTerminalUtil;

    @Inject
    public NodePropertiesDialogFactory(GeniUserProvider geniUserProvider, ExternalSshTerminal externalSshTerminal, SSHTerminalUtil sshTerminalUtil) {
        this.geniUserProvider = geniUserProvider;
        this.externalSshTerminal = externalSshTerminal;
        this.sshTerminalUtil = sshTerminalUtil;
    }

    public void showSimplePropertiesDialog(@Nonnull Slice slice, @Nonnull FXRspecNode node) {
        List<BasicStringRspec.LoginService> loginServices = this.sshTerminalUtil.findAllLoginService(node, slice);
        Optional<BasicStringRspec.LoginService> bestLoginService = this.sshTerminalUtil.findBestLoginService(node, slice);
        this.showSimplePropertiesDialog(slice, node, bestLoginService.orElse(loginServices.get(0)), loginServices);
    }

    public void showSimplePropertiesDialog(@Nonnull Slice slice, @Nonnull FXRspecNode node, @Nullable BasicStringRspec.LoginService bestLoginService, @Nonnull List<BasicStringRspec.LoginService> loginServices) {
        if (bestLoginService != null && !loginServices.isEmpty()) {
            NodePropertiesDialog npd = new NodePropertiesDialog(slice, node, bestLoginService, loginServices, this.externalSshTerminal);
            npd.showDialog();
        } else {
            JFDialogs.create().message("The selected node doesn't provide any information to perform an interactive login. Is this node ready?").masthead("No information available about this node").showWarning();
        }
    }
}

