/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice;

import be.iminds.ilabt.jfed.experimenter_gui.dialogs.JFedBrowserFactory;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import java.util.Collection;
import java.util.Objects;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Spinner;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class OpenNodeBrowserDialog
extends Dialog<String> {
    private final BrowserUtil browserUtil;
    private final JFedBrowserFactory jFedBrowserFactory;
    private final RadioButton internalRadioButton;

    public OpenNodeBrowserDialog(BrowserUtil browserUtil, JFedBrowserFactory jFedBrowserFactory, Collection<String> possibleHostNames) {
        this.browserUtil = browserUtil;
        this.jFedBrowserFactory = jFedBrowserFactory;
        this.setTitle("Open browser to node");
        this.setHeaderText("Open browser to node");
        HBox urlLine = new HBox(5.0);
        ComboBox protocol = new ComboBox();
        protocol.setPrefWidth(110.0);
        protocol.getItems().add((Object)"http://");
        protocol.getItems().add((Object)"https://");
        protocol.getSelectionModel().selectFirst();
        ComboBox hostname = new ComboBox();
        hostname.setPrefWidth(400.0);
        hostname.getItems().setAll(possibleHostNames);
        hostname.getSelectionModel().selectFirst();
        Spinner portSpinner = new Spinner(0, 10240, 80);
        portSpinner.setEditable(true);
        portSpinner.setPrefWidth(100.0);
        protocol.getSelectionModel().selectedItemProperty().addListener((prop, oldValue, newValue) -> {
            if (Objects.equals(oldValue, newValue)) {
                return;
            }
            if ((Integer)portSpinner.getValue() == 80 && Objects.equals(newValue, "https://")) {
                portSpinner.getValueFactory().setValue((Object)443);
            }
            if ((Integer)portSpinner.getValue() == 443 && Objects.equals(newValue, "http://")) {
                portSpinner.getValueFactory().setValue((Object)80);
            }
        });
        urlLine.getChildren().addAll((Object[])new Node[]{new Label("Select the URL:"), protocol, hostname, new Label(":"), portSpinner});
        RadioButton externalRadioButton = new RadioButton("Use System Browser");
        this.internalRadioButton = new RadioButton("Use Internal jFed Browser");
        ToggleGroup rbGroup = new ToggleGroup();
        externalRadioButton.setToggleGroup(rbGroup);
        this.internalRadioButton.setToggleGroup(rbGroup);
        externalRadioButton.setSelected(true);
        VBox content = new VBox();
        content.getChildren().addAll((Object[])new Node[]{urlLine, externalRadioButton, this.internalRadioButton});
        this.getDialogPane().setContent((Node)content);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.setResultConverter(param -> {
            if (param == ButtonType.OK) {
                return (String)protocol.getSelectionModel().getSelectedItem() + (String)hostname.getSelectionModel().getSelectedItem() + ":" + ((Integer)portSpinner.getValue()).toString();
            }
            return null;
        });
    }

    private void openBrowser(String url) {
        if (this.internalRadioButton.isSelected()) {
            this.jFedBrowserFactory.showDialog(url);
        } else {
            this.browserUtil.openUrlInBrowser(url);
        }
    }

    public void doDialog() {
        this.showAndWait().ifPresent(this::openBrowser);
    }
}

