/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice;

import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.DialogsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.slice.CustomStateDetailsView;
import be.iminds.ilabt.jfed.experimenter_gui.slice.state_listeners.CreateDiskImageStateListener;
import be.iminds.ilabt.jfed.highlevel.jobs.CreateDiskImageJob;
import be.iminds.ilabt.jfed.highlevel.jobs.SingleTaskJob;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.jobs.TestLinksJob;
import be.iminds.ilabt.jfed.highlevel.tasks.CreateImageTask;
import be.iminds.ilabt.jfed.highlevel.tasks.OpenConsoleTask;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import java.util.List;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ProgressItemCustomDetailsViews {
    private final DialogsFactory dialogsFactory;

    @Inject
    public ProgressItemCustomDetailsViews(@Nonnull DialogsFactory dialogsFactory) {
        this.dialogsFactory = dialogsFactory;
    }

    public CustomStateDetailsView<? extends State> getCustomDetailsView(State state) {
        if (state instanceof CreateDiskImageJob.CreateImageState && state.getStatus() == ExperimentTaskStatus.SUCCESS) {
            return state1 -> CreateDiskImageStateListener.showImageInfoDialog((CreateImageTask)state1.getTask());
        }
        if (state instanceof SingleTaskJob.ExecuteTaskState && ((SingleTaskJob.ExecuteTaskState)state).getTask() instanceof OpenConsoleTask && state.getStatus() == ExperimentTaskStatus.SUCCESS) {
            OpenConsoleTask task = (OpenConsoleTask)((SingleTaskJob.ExecuteTaskState)state).getTask();
            if (((SingleTaskJob.ExecuteTaskState)state).getTaskExecution().isCompleted()) {
                if (task.getUrl() != null) {
                    JFDialogs.create().message("Console has been opened in browser. URL is: " + task.getUrl().toExternalForm()).allowCopyMessage().showWarning();
                } else {
                    new Alert(Alert.AlertType.ERROR, "No console URL received!", new ButtonType[0]).show();
                }
            } else {
                new Alert(Alert.AlertType.INFORMATION, "Console URL is being requested", new ButtonType[0]).show();
            }
        }
        if (state instanceof TestLinksJob.TestLinksOfExperimentPartState) {
            return st -> {
                TestLinksJob.TestLinksOfExperimentPartState s = (TestLinksJob.TestLinksOfExperimentPartState)state;
                List linkReports = s.getLinkReports();
                this.dialogsFactory.showLinkTestDialog(null, linkReports);
            };
        }
        return null;
    }
}

