/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentPartQoe;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.layout.TilePane;
import javafx.scene.paint.Color;
import org.controlsfx.glyphfont.FontAwesome;

public class QoeDialog
extends Dialog<List<QoeReply>> {
    final List<ExperimentPartQoe> experimentPartQoes = new ArrayList<ExperimentPartQoe>();

    public QoeDialog(Experiment experiment, Collection<SfaExperimentPart> experimentParts) {
        this.setTitle("Rate this experiment");
        this.setHeaderText(String.format("Please rate your experience while using '%s'", experiment.getName()));
        this.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.STAR, (Color)Color.GOLD));
        for (SfaExperimentPart experimentPart : experimentParts) {
            this.experimentPartQoes.add(new ExperimentPartQoe(experimentPart));
        }
        TilePane content = new TilePane(10.0, 10.0);
        int prefColumns = experimentParts.size() > 6 ? 3 : (experimentParts.size() > 2 ? 2 : 1);
        content.setPrefColumns(prefColumns);
        content.getChildren().addAll(this.experimentPartQoes);
        this.getDialogPane().setContent((Node)content);
        this.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        this.setResultConverter(param -> {
            if (param != ButtonType.OK) {
                return null;
            }
            return this.experimentPartQoes.stream().map(ExperimentPartQoe::getResult).collect(Collectors.toList());
        });
    }

    public static class QoeReply {
        private final SfaExperimentPart experimentPart;
        private final int overallScore;
        private final int qualityScore;
        private final int availabilityScore;

        public QoeReply(SfaExperimentPart experimentPart, int overallScore, int qualityScore, int availabilityScore) {
            this.experimentPart = experimentPart;
            this.overallScore = overallScore;
            this.qualityScore = qualityScore;
            this.availabilityScore = availabilityScore;
        }

        public SfaExperimentPart getExperimentPart() {
            return this.experimentPart;
        }

        public int getOverallScore() {
            return this.overallScore;
        }

        public int getQualityScore() {
            return this.qualityScore;
        }

        public int getAvailabilityScore() {
            return this.availabilityScore;
        }
    }
}

