/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentChangeListener;
import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.ExperimentCanvas;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.AddressPoolCanvasNode;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.CanvasNodeFactory;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.ModelRspecToCanvasBinding;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.RspecCanvasLink;
import be.iminds.ilabt.jfed.experimenter_gui.canvas.rspec.RspecCanvasNode;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.dialogs.JFedBrowserFactory;
import be.iminds.ilabt.jfed.experimenter_gui.slice.AddressPoolPropertiesDialog;
import be.iminds.ilabt.jfed.experimenter_gui.slice.LinkPropertiesDialog;
import be.iminds.ilabt.jfed.experimenter_gui.slice.NodePropertiesDialogFactory;
import be.iminds.ilabt.jfed.experimenter_gui.slice.OpenNodeBrowserDialog;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.ExperimentActionsFactory;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.experimenter_gui.util.RDPAppUtil;
import be.iminds.ilabt.jfed.experimenter_gui.util.SSHTerminalUtil;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.IPv4;
import be.iminds.ilabt.jfed.rspec.model.LoginService;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXAddressPool;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.Spinner;
import javafx.scene.control.TextInputDialog;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceExperimentCanvas
extends ExperimentCanvas
implements ExperimentChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(SliceExperimentCanvas.class);
    @Nonnull
    private final ModelRspecToCanvasBinding binding;
    @Nonnull
    private final ContextMenu linkContextMenu;
    @Nonnull
    private final ContextMenu addressPoolContextMenu;
    @Nonnull
    private final MenuItem shareLanItem;
    @Nonnull
    private final ExperimentController experimentController;
    @Nonnull
    private final Experiment experiment;
    @Nonnull
    private final ExperimentActionsFactory experimentActionsFactory;
    @Nonnull
    private final GeniUserProvider geniUserProvider;
    @Nonnull
    private final TestbedInfoSource testbedInfoSource;
    @Nonnull
    private final AuthorityFinder authorityFinder;
    @Nonnull
    private final HighLevelTaskFactory hltf;
    @Nonnull
    private final NodePropertiesDialogFactory nodePropertiesDialogFactory;
    @Nonnull
    private final RDPAppUtil rdpAppUtil;
    @Nonnull
    private final SSHTerminalUtil sshTerminalUtil;
    @Nonnull
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    @Nonnull
    private final JFedGuiConfig guiConfig;
    @Nonnull
    private final BrowserUtil browserUtil;
    @Nonnull
    private final JFedBrowserFactory jFedBrowserFactory;
    private final boolean isDemo = new JFedHLPreferences().getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_IS_DEMO, false);

    public SliceExperimentCanvas(@Nonnull ExperimentController experimentController, @Nonnull FXModelRspec model, @Nonnull JFedGuiConfig config, @Nonnull CanvasNodeFactory canvasNodeFactory, @Nonnull ExperimentActionsFactory experimentActionsFactory, @Nonnull GeniUserProvider geniUserProvider, @Nonnull TestbedInfoSource testbedInfoSource, @Nonnull AuthorityFinder authorityFinder, @Nonnull HighLevelTaskFactory hltf, @Nonnull NodePropertiesDialogFactory nodePropertiesDialogFactory, @Nonnull SSHTerminalUtil sshTerminalUtil, @Nonnull RDPAppUtil rdpAppUtil, @Nonnull AggregateManagerWrapperFactory aggregateManagerWrapperFactory, @Nonnull JFedGuiConfig guiConfig, @Nonnull BrowserUtil browserUtil, @Nonnull JFedBrowserFactory jFedBrowserFactory) {
        this.browserUtil = browserUtil;
        this.jFedBrowserFactory = jFedBrowserFactory;
        this.binding = new ModelRspecToCanvasBinding(model, this, config, canvasNodeFactory);
        this.experimentController = experimentController;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.experiment = experimentController.getExperiment();
        this.experimentActionsFactory = experimentActionsFactory;
        this.geniUserProvider = geniUserProvider;
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
        this.hltf = hltf;
        this.nodePropertiesDialogFactory = nodePropertiesDialogFactory;
        this.sshTerminalUtil = sshTerminalUtil;
        this.rdpAppUtil = rdpAppUtil;
        this.guiConfig = guiConfig;
        this.setCanvasStyle(ExperimentCanvas.CanvasStyle.FIXED);
        this.linkContextMenu = new ContextMenu();
        this.shareLanItem = new MenuItem("Share/Unshare Lan", (Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.SHARE_ALT));
        this.shareLanItem.setOnAction(actionEvent -> {
            RspecCanvasLink rspecCanvasLink = this.getSelectionProvider().getSelectedObject(RspecCanvasLink.class);
            if (rspecCanvasLink != null) {
                experimentActionsFactory.createShareLanAction(this.getScene().getWindow(), experimentController, rspecCanvasLink.getRspecLink()).run();
            }
        });
        this.linkContextMenu.getItems().add((Object)this.shareLanItem);
        MenuItem linkInfoMenuItem = new MenuItem("Show Link Info", (Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.INFO));
        linkInfoMenuItem.setOnAction(actionEvent -> {
            RspecCanvasLink rspecCanvasLink = this.getSelectionProvider().getSelectedObject(RspecCanvasLink.class);
            if (rspecCanvasLink != null) {
                FXRspecLink manifestLink = this.tryGetManifestRspecLink(rspecCanvasLink);
                if (manifestLink != null) {
                    new LinkPropertiesDialog(manifestLink).showDialog();
                } else {
                    new Alert(Alert.AlertType.INFORMATION, "No link information available. (no manifest)", new ButtonType[0]).show();
                }
            } else {
                throw new NullPointerException("It should be impossible that rspecCanvasLink is null");
            }
        });
        this.linkContextMenu.getItems().add((Object)linkInfoMenuItem);
        experimentController.getExperiment().addExperimentChangeListener((ExperimentChangeListener)this);
        this.updateCanvasStyle(experimentController.getExperiment().getExperimentState());
        this.addressPoolContextMenu = new ContextMenu();
        MenuItem addressPoolInfoMenuItem = new MenuItem("Show Address Pool Info", (Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.INFO));
        addressPoolInfoMenuItem.setOnAction(actionEvent -> {
            assert (this.getSelectionProvider().getSelectedAddressPool() != null);
            AddressPoolCanvasNode addressPoolCanvasNode = this.getSelectionProvider().getSelectedAddressPool();
            FXAddressPool manifestAddressPool = this.tryGetManifestAddressPool(addressPoolCanvasNode);
            if (manifestAddressPool != null) {
                new AddressPoolPropertiesDialog(manifestAddressPool).show();
            } else {
                new Alert(Alert.AlertType.INFORMATION, "No information available", new ButtonType[0]).show();
            }
        });
        this.addressPoolContextMenu.getItems().add((Object)addressPoolInfoMenuItem);
        MenuItem openBrowserMenuItem = new MenuItem("Open in browser", (Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.EXTERNAL_LINK));
        openBrowserMenuItem.setOnAction(event -> {
            assert (this.getSelectionProvider().getSelectedAddressPool() != null);
            AddressPoolCanvasNode addressPoolCanvasNode = this.getSelectionProvider().getSelectedAddressPool();
            FXAddressPool manifestAddressPool = this.tryGetManifestAddressPool(addressPoolCanvasNode);
            if (manifestAddressPool != null) {
                Dialog dialog = new Dialog();
                dialog.setTitle("Open browser to node");
                dialog.setHeaderText("Open browser to node");
                HBox content = new HBox(5.0);
                ComboBox protocol = new ComboBox();
                protocol.setPrefWidth(110.0);
                protocol.getItems().add((Object)"http://");
                protocol.getItems().add((Object)"https://");
                protocol.getSelectionModel().selectFirst();
                ComboBox hostname = new ComboBox();
                hostname.setPrefWidth(400.0);
                manifestAddressPool.getIPv4s().stream().map(IPv4::getAddress).forEach(arg_0 -> hostname.getItems().add(arg_0));
                hostname.getSelectionModel().selectFirst();
                Spinner portSpinner = new Spinner(0, 10240, 80);
                portSpinner.setEditable(true);
                portSpinner.setPrefWidth(100.0);
                protocol.getSelectionModel().selectedItemProperty().addListener((prop, oldValue, newValue) -> {
                    if (Objects.equals(oldValue, newValue)) {
                        return;
                    }
                    if ((Integer)portSpinner.getValue() == 80 && Objects.equals(newValue, "https://")) {
                        portSpinner.getValueFactory().setValue((Object)443);
                    }
                    if ((Integer)portSpinner.getValue() == 443 && Objects.equals(newValue, "http://")) {
                        portSpinner.getValueFactory().setValue((Object)80);
                    }
                });
                content.getChildren().addAll((Object[])new Node[]{new Label("Select the URL:"), protocol, hostname, new Label(":"), portSpinner});
                dialog.getDialogPane().setContent((Node)content);
                dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
                dialog.setResultConverter(param -> {
                    if (param == ButtonType.OK) {
                        return (String)protocol.getSelectionModel().getSelectedItem() + (String)hostname.getSelectionModel().getSelectedItem() + ":" + ((Integer)portSpinner.getValue()).toString();
                    }
                    return null;
                });
                dialog.showAndWait().ifPresent(browserUtil::openUrlInBrowser);
            }
        });
        this.addressPoolContextMenu.getItems().add((Object)openBrowserMenuItem);
    }

    private void showNodeContextMenu(@Nonnull RspecCanvasNode rspecCanvasNode, double posX, double posY) {
        Server selectedAuthority;
        boolean showComplexOpenSsh;
        if (this.experimentController.getExperiment().getSliceOpt().isEmpty()) {
            LOG.error("showNodeContextMenu when experiment has NO slice. Will do nothing.");
            return;
        }
        FXRspecNode rspecNode = rspecCanvasNode.getRspecNode();
        FXRspecNode manifestRspecNode = this.tryGetManifestRspecNode(rspecCanvasNode);
        ContextMenu nodeContextMenu = new ContextMenu();
        Slice slice = this.experimentController.getExperiment().getSliceOrNull();
        if (slice == null) {
            return;
        }
        List<BasicStringRspec.LoginService> loginServices = this.sshTerminalUtil.findAllLoginService(rspecNode, slice);
        Optional<BasicStringRspec.LoginService> bestLoginService = this.sshTerminalUtil.findBestLoginService(rspecNode, slice);
        boolean showSsh = bestLoginService.isPresent() || !loginServices.isEmpty();
        HashSet<String> possibleHostNames = new HashSet<String>();
        if (showSsh) {
            loginServices.stream().map(BasicStringRspec.LoginService::getHostname).forEach(possibleHostNames::add);
            if (manifestRspecNode != null) {
                manifestRspecNode.getLoginServices().stream().map(LoginService::getHostname).forEach(possibleHostNames::add);
                manifestRspecNode.getInterfaces().stream().flatMap(iface -> iface.getIpAddresses().stream()).map(RspecInterface.IpAddress::getAddress).forEach(possibleHostNames::add);
                if (manifestRspecNode.getHostName() != null) {
                    possibleHostNames.add(manifestRspecNode.getHostName());
                }
            }
        }
        if (showSsh && bestLoginService.isPresent()) {
            MenuItem sshMenuItem = new MenuItem("Open SSH terminal", (Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TERMINAL));
            sshMenuItem.setOnAction(actionEvent -> this.sshTerminalUtil.launchSSHTerminal((BasicStringRspec.LoginService)bestLoginService.get()));
            nodeContextMenu.getItems().add((Object)sshMenuItem);
        }
        assert (this.geniUserProvider != null);
        assert (this.geniUserProvider.getLoggedInGeniUser() != null);
        assert (this.geniUserProvider.getLoggedInGeniUser().getUserUrn() != null);
        String loggedInUsername = this.geniUserProvider.getLoggedInGeniUser().getUserUrn().getEncodedResourceName();
        assert (loggedInUsername != null);
        boolean bl = showComplexOpenSsh = showSsh && (!bestLoginService.isPresent() || loginServices.size() > 1 || !bestLoginService.get().getUsername().equalsIgnoreCase(loggedInUsername));
        if (showSsh && !showComplexOpenSsh) {
            MenuItem sshCustomUserMenuItem = new MenuItem("Open SSH terminal with custom user", (Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TERMINAL));
            sshCustomUserMenuItem.setOnAction(event -> {
                String username1 = this.geniUserProvider.getLoggedInGeniUser().getUserUrn().getEncodedResourceName();
                TextInputDialog dialog = new TextInputDialog(username1);
                dialog.setTitle("Open SSH terminal with custom user");
                dialog.setHeaderText("Open SSH terminal with custom user");
                dialog.setContentText("Please enter the custom username:");
                dialog.showAndWait().ifPresent(customUsername -> this.sshTerminalUtil.launchSSHTerminal(rspecNode, this.experimentController.getExperiment().getSliceOrNull(), (String)customUsername));
            });
            nodeContextMenu.getItems().add((Object)sshCustomUserMenuItem);
        }
        if (showComplexOpenSsh) {
            List usernames = loginServices.stream().map(BasicStringRspec.LoginService::getUsername).distinct().collect(Collectors.toList());
            if (!usernames.contains(loggedInUsername)) {
                usernames.add(loggedInUsername);
            }
            Map<String, List<BasicStringRspec.LoginService>> logins = loginServices.stream().collect(Collectors.groupingBy(ls -> ls.toDescription(false, true)));
            Menu sshRootMenu = new Menu("Open SSH terminal (host/user)", (Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TERMINAL));
            nodeContextMenu.getItems().add((Object)sshRootMenu);
            for (String login : logins.keySet()) {
                List<BasicStringRspec.LoginService> loginServiceList = logins.get(login);
                List loginUsernames = loginServiceList.stream().map(BasicStringRspec.LoginService::getUsername).distinct().collect(Collectors.toList());
                Menu sshSubMenu = new Menu(login);
                sshRootMenu.getItems().add((Object)sshSubMenu);
                for (String username : usernames) {
                    MenuItem sshLogin = new MenuItem(username);
                    sshLogin.setOnAction(event -> this.sshTerminalUtil.launchSSHTerminal((BasicStringRspec.LoginService)loginServiceList.get(0), username));
                    if (!loginUsernames.contains(username)) {
                        sshLogin.setStyle("-fx-text-fill: grey;");
                    }
                    sshSubMenu.getItems().add((Object)sshLogin);
                }
                MenuItem sshCustomUserMenuItem = new MenuItem("Other user...");
                sshCustomUserMenuItem.setOnAction(event -> {
                    TextInputDialog dialog = new TextInputDialog(loggedInUsername);
                    dialog.setTitle("Open SSH terminal with custom user");
                    dialog.setHeaderText("Open SSH terminal with custom user");
                    dialog.setContentText("Please enter the custom username:");
                    dialog.showAndWait().ifPresent(customUsername -> this.sshTerminalUtil.launchSSHTerminal((BasicStringRspec.LoginService)loginServiceList.get(0), (String)customUsername));
                });
                sshCustomUserMenuItem.setStyle("-fx-text-fill: grey;");
                sshSubMenu.getItems().add((Object)new SeparatorMenuItem());
                sshSubMenu.getItems().add((Object)sshCustomUserMenuItem);
            }
        }
        if (showSsh && manifestRspecNode != null) {
            MenuItem openBrowserMenuItem = new MenuItem("Open in browser", (Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.EXTERNAL_LINK));
            openBrowserMenuItem.setOnAction(event -> {
                OpenNodeBrowserDialog dialog = new OpenNodeBrowserDialog(this.browserUtil, this.jFedBrowserFactory, possibleHostNames);
                dialog.doDialog();
            });
            nodeContextMenu.getItems().add((Object)openBrowserMenuItem);
        }
        if (manifestRspecNode != null && !loginServices.isEmpty()) {
            MenuItem infoMenuItem = new MenuItem("Show Node Info", (Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.INFO));
            infoMenuItem.setOnAction(actionEvent -> this.nodePropertiesDialogFactory.showSimplePropertiesDialog(slice, manifestRspecNode, bestLoginService.orElse((BasicStringRspec.LoginService)loginServices.get(0)), loginServices));
            nodeContextMenu.getItems().add((Object)infoMenuItem);
        }
        boolean showCreateImage = false;
        boolean showReboot = false;
        boolean showReloadOs = false;
        boolean showOpenConsole = false;
        if (manifestRspecNode != null && manifestRspecNode.getComponentManagerId() != null && (selectedAuthority = this.authorityFinder.findByUrn(manifestRspecNode.getComponentManagerId(), AuthorityFinder.Purpose.CREATE_SLIVER)) != null && !selectedAuthority.isEdgeVlan() && !selectedAuthority.getServices().isEmpty()) {
            try {
                AggregateManagerWrapper amWrapper = this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(selectedAuthority);
                showCreateImage = amWrapper.areUserDiskImageFunctionsSupported() && manifestRspecNode.getSliverId() != null;
                showReboot = amWrapper.isRestartSupported() && manifestRspecNode.getSliverId() != null;
                showReloadOs = amWrapper.isReloadOSSupported() && manifestRspecNode.getSliverId() != null;
                showOpenConsole = amWrapper.isOpenConsoleSupported() && manifestRspecNode.getSliverId() != null;
            }
            catch (Exception e) {
                LOG.error("Error checking amWrapper for functionality (will be ignored)", (Throwable)e);
            }
        }
        if (showCreateImage) {
            MenuItem diskImageMenuItem = new MenuItem("Create Image", (Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.UPLOAD));
            diskImageMenuItem.setOnAction(actionEvent -> this.experimentActionsFactory.createCreateDiskImageAction(this.getScene().getWindow(), this.experimentController, manifestRspecNode).run());
            diskImageMenuItem.disableProperty().setValue(Boolean.valueOf(this.isDemo));
            nodeContextMenu.getItems().add((Object)diskImageMenuItem);
        }
        if (showReboot) {
            MenuItem rebootMenuItem = new MenuItem("Reboot", (Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.POWER_OFF));
            rebootMenuItem.setOnAction(actionEvent -> {
                Sliver selectedSliver = this.getSelectedSliver();
                if (selectedSliver != null) {
                    this.experimentActionsFactory.createRebootAction(this.getScene().getWindow(), this.experimentController, selectedSliver).run();
                } else {
                    LOG.error("Could not retrieve selected sliver sliver to reboot");
                }
            });
            rebootMenuItem.disableProperty().setValue(Boolean.valueOf(this.isDemo || this.guiConfig.isExperimentActionDisabled()));
            nodeContextMenu.getItems().add((Object)rebootMenuItem);
        }
        if (showReloadOs) {
            MenuItem reloadMenuItem = new MenuItem("Reload OS", (Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.POWER_OFF));
            reloadMenuItem.setOnAction(actionEvent -> {
                Sliver selectedSliver = this.getSelectedSliver();
                if (selectedSliver != null) {
                    this.experimentActionsFactory.createReloadOSAction(this.getScene().getWindow(), this.experimentController, selectedSliver).run();
                } else {
                    LOG.error("Could not retrieve selected sliver sliver to reload os");
                }
            });
            reloadMenuItem.disableProperty().setValue(Boolean.valueOf(this.isDemo || this.guiConfig.isExperimentActionDisabled()));
            nodeContextMenu.getItems().add((Object)reloadMenuItem);
        }
        if (showOpenConsole) {
            MenuItem openConsoleMenuItem = new MenuItem("Open Boot Console", (Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TERMINAL));
            openConsoleMenuItem.setOnAction(actionEvent -> {
                Sliver selectedSliver = this.getSelectedSliver();
                if (selectedSliver != null) {
                    this.experimentActionsFactory.createOpenConsoleAction(this.getScene().getWindow(), this.experimentController, selectedSliver).run();
                } else {
                    LOG.error("Could not retrieve selected sliver sliver to open boot console");
                }
            });
            nodeContextMenu.getItems().add((Object)openConsoleMenuItem);
        }
        if (showSsh) {
            MenuItem uploadMenuItem = new MenuItem("Transfer files", (Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.UPLOAD));
            uploadMenuItem.setOnAction(actionEvent -> this.experimentActionsFactory.createSCPUploadAction(this.getScene().getWindow(), this.experimentController, manifestRspecNode).run());
            nodeContextMenu.getItems().add((Object)uploadMenuItem);
        }
        nodeContextMenu.show((Node)rspecCanvasNode, posX, posY);
    }

    @Nullable
    private FXRspecNode tryGetManifestRspecNode(@Nonnull RspecCanvasNode rspecCanvasNode) {
        FXRspecNode rspecNode = rspecCanvasNode.getRspecNode();
        FXModelRspec manifestRspec = this.getFXManifestRspec();
        if (manifestRspec != null) {
            FXRspecNode manifestRspecNode = manifestRspec.getNodeByUniqueId(rspecNode.getUniqueId());
            if (manifestRspecNode == null && rspecNode.getClientId() != null) {
                manifestRspecNode = manifestRspec.getNodeByClientId(rspecNode.getClientId());
            }
            if (manifestRspecNode != null) {
                rspecNode = manifestRspecNode;
            }
        }
        return rspecNode;
    }

    @Nullable
    private FXRspecLink tryGetManifestRspecLink(@Nonnull RspecCanvasLink rspecCanvasLink) {
        FXRspecLink rspecLink = rspecCanvasLink.getRspecLink();
        FXModelRspec manifestRspec = this.getFXManifestRspec();
        if (manifestRspec != null) {
            FXRspecLink manifestRspecLink = manifestRspec.getLinkByUniqueId(rspecLink.getUniqueId());
            if (manifestRspecLink == null && rspecLink.getClientId() != null) {
                manifestRspecLink = manifestRspec.getLinkByClientId(rspecLink.getClientId());
            }
            if (manifestRspecLink != null) {
                rspecLink = manifestRspecLink;
            }
        }
        return rspecLink;
    }

    @Nullable
    private FXAddressPool tryGetManifestAddressPool(@Nonnull AddressPoolCanvasNode addressPoolCanvasNode) {
        FXAddressPool canvasAddressPool = addressPoolCanvasNode.getAddressPool();
        FXModelRspec manifestRspec = this.getFXManifestRspec();
        if (manifestRspec != null) {
            return manifestRspec.getAddressPoolByClientId(canvasAddressPool.getClientId());
        }
        return null;
    }

    @Nullable
    private FXModelRspec getFXManifestRspec() {
        if (this.experiment.getSliceOrNull() == null) {
            return null;
        }
        if (this.experiment.getSliceOrNull().getManifestRspec() == null) {
            return null;
        }
        FXModelRspec manifestRspec = (FXModelRspec)this.experiment.getSliceOrNull().getManifestRspec().getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        assert (manifestRspec != null);
        return manifestRspec;
    }

    @Nonnull
    public static String statusToNodeStyleClass(@Nonnull NodeStatus status) {
        switch (status.ordinal()) {
            case 1: {
                return "canvas-node-ready";
            }
            case 2: {
                return "canvas-node-ready-nologin";
            }
            case 5: {
                return "canvas-node-changing";
            }
            case 6: 
            case 7: {
                return "canvas-node-fail";
            }
            case 3: {
                return "canvas-node-unallocated";
            }
            case 0: {
                return "canvas-node-uninitialised";
            }
            case 4: {
                return "canvas-node-unknown";
            }
        }
        throw new IllegalArgumentException();
    }

    @Nonnull
    public static String statusToAddressPoolStyleClass(@Nonnull StatusDetails.SliverStatus status) {
        switch (status) {
            case READY: {
                return "canvas-node-ready";
            }
            case CHANGING: {
                return "canvas-node-changing";
            }
            case NOTREADY: {
                return "canvas-node-notready";
            }
            case FAIL: {
                return "canvas-node-fail";
            }
            case UNALLOCATED: {
                return "canvas-node-unallocated";
            }
            case UNINITIALISED: {
                return "canvas-node-uninitialised";
            }
            case UNKNOWN: {
                return "canvas-node-unknown";
            }
        }
        throw new IllegalArgumentException();
    }

    @Nonnull
    public static String statusToGTTStyleClass(@Nonnull StatusDetails.SliverStatus status) {
        switch (status) {
            case READY: {
                return "canvas-node-ready";
            }
            case CHANGING: {
                return "canvas-node-changing";
            }
            case NOTREADY: {
                return "canvas-node-notready";
            }
            case FAIL: {
                return "canvas-node-fail";
            }
            case UNALLOCATED: {
                return "canvas-node-unallocated";
            }
            case UNINITIALISED: {
                return "canvas-node-uninitialised";
            }
            case UNKNOWN: {
                return "canvas-node-unknown";
            }
        }
        throw new IllegalArgumentException();
    }

    @Nonnull
    public static String statusToInterfaceStyleClass(@Nonnull StatusDetails.SliverStatus status) {
        switch (status) {
            case READY: {
                return "canvas-link-ready";
            }
            case CHANGING: {
                return "canvas-link-changing";
            }
            case NOTREADY: {
                return "canvas-link-notready";
            }
            case FAIL: {
                return "canvas-link-fail";
            }
            case UNALLOCATED: {
                return "canvas-link-unallocated";
            }
            case UNINITIALISED: {
                return "canvas-link-uninitialised";
            }
            case UNKNOWN: {
                return "canvas-link-unknown";
            }
        }
        throw new IllegalArgumentException();
    }

    @Nonnull
    public static String statusToLinkCenterStyleClass(@Nullable StatusDetails.SliverStatus status) {
        if (status == null) {
            return "link-center-editable";
        }
        switch (status) {
            case READY: {
                return "link-center-ready";
            }
            case CHANGING: {
                return "link-center-changing";
            }
            case NOTREADY: {
                return "link-center-notready";
            }
            case FAIL: {
                return "link-center-fail";
            }
            case UNALLOCATED: {
                return "link-center-unallocated";
            }
            case UNINITIALISED: {
                return "link-center-uninitialised";
            }
            case UNKNOWN: {
                return "link-center-unknown";
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void canvasItemOnMouseClicked(MouseEvent mouseEvent) {
        super.canvasItemOnMouseClicked(mouseEvent);
        if (mouseEvent.getSource() instanceof RspecCanvasNode) {
            RspecCanvasNode node = (RspecCanvasNode)mouseEvent.getSource();
            this.getSelectionProvider().setSelectedCanvasNode(node);
            if (mouseEvent.getButton() == MouseButton.PRIMARY && mouseEvent.getClickCount() == 2) {
                if (Objects.equals(node.getRspecNode().getSliverTypeName(), "fake")) {
                    FXRspecNode manifestRspecNode = this.tryGetManifestRspecNode(node);
                    Slice slice = this.experimentController.getExperiment().getSliceOrNull();
                    if (slice != null && manifestRspecNode != null) {
                        this.nodePropertiesDialogFactory.showSimplePropertiesDialog(slice, manifestRspecNode, null, Collections.emptyList());
                    }
                } else if (this.rdpAppUtil.hasRdpService(node.getRspecNode(), this.experiment.getSliceOrNull())) {
                    this.rdpAppUtil.launchRdpApp(node.getRspecNode(), this.experiment.getSliceOrNull());
                } else {
                    this.sshTerminalUtil.launchSSHTerminal(node.getRspecNode(), this.experiment.getSliceOrNull());
                }
            } else if (mouseEvent.getButton() != MouseButton.PRIMARY || mouseEvent.isControlDown()) {
                this.showNodeContextMenu(node, mouseEvent.getScreenX(), mouseEvent.getScreenY());
            }
        }
        if (mouseEvent.getSource() instanceof RspecCanvasLink.LinkCenter) {
            RspecCanvasLink link = ((RspecCanvasLink.LinkCenter)mouseEvent.getSource()).getRspecCanvasLink();
            this.getSelectionProvider().setSelectedCanvasLink(link);
            assert (this.getSelectionProvider().getSelectedObject(RspecCanvasLink.class) != null);
            if (mouseEvent.getButton() != MouseButton.PRIMARY || mouseEvent.isControlDown()) {
                RspecCanvasLink rspecCanvasLink = this.getSelectionProvider().getSelectedObject(RspecCanvasLink.class);
                boolean isStiching = rspecCanvasLink != null && rspecCanvasLink.getRspecLink().isStitched(this.testbedInfoSource);
                boolean isEmulab = false;
                boolean supportsSharedLan = false;
                for (GeniUrn compManUrn : link.getRspecLink().getComponentManagerUrns()) {
                    Server nodeAuth = this.authorityFinder.findByUrn(compManUrn, AuthorityFinder.Purpose.CREATE_SLIVER);
                    if (nodeAuth == null) continue;
                    if (!nodeAuth.getServices().isEmpty()) {
                        try {
                            AggregateManagerWrapper amWrapper = this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(nodeAuth);
                            supportsSharedLan |= amWrapper.isShareLanSupported();
                        }
                        catch (Exception e) {
                            LOG.warn("Ignorable exception while determining supportsSharedLan", (Throwable)e);
                        }
                    }
                    if (nodeAuth.getServerType() == null) continue;
                    isEmulab |= nodeAuth.getServerType().equalsIgnoreCase("emulab") || nodeAuth.getServerType().equalsIgnoreCase("protogeni") || nodeAuth.getServerType().equalsIgnoreCase("instageni");
                }
                if (isEmulab && supportsSharedLan && !this.isDemo && !this.guiConfig.isExperimentActionDisabled()) {
                    this.shareLanItem.setDisable(false);
                } else {
                    this.shareLanItem.setDisable(true);
                }
                if (this.getSelectionProvider().getSelectedObject(RspecCanvasLink.class) != null) {
                    RspecCanvasLink selectedRspecCanvasLink = this.getSelectionProvider().getSelectedObject(RspecCanvasLink.class);
                    Button linkCenter = selectedRspecCanvasLink == null ? null : selectedRspecCanvasLink.getLinkCenter();
                    this.linkContextMenu.show((Node)linkCenter, mouseEvent.getScreenX(), mouseEvent.getScreenY());
                }
            }
        }
        if (mouseEvent.getSource() instanceof AddressPoolCanvasNode) {
            this.getSelectionProvider().setSelectedAddressPool((AddressPoolCanvasNode)((Object)mouseEvent.getSource()));
            if (mouseEvent.getButton() != MouseButton.PRIMARY || mouseEvent.isControlDown()) {
                this.addressPoolContextMenu.show((Node)this.getSelectionProvider().getSelectedAddressPool(), mouseEvent.getScreenX(), mouseEvent.getScreenY());
            } else if (mouseEvent.getClickCount() == 2) {
                AddressPoolCanvasNode addressPoolCanvasNode = (AddressPoolCanvasNode)((Object)mouseEvent.getSource());
                FXAddressPool manifestAddressPool = this.tryGetManifestAddressPool(addressPoolCanvasNode);
                if (manifestAddressPool != null) {
                    new AddressPoolPropertiesDialog(manifestAddressPool).show();
                } else {
                    new Alert(Alert.AlertType.INFORMATION, "No information available", new ButtonType[0]).show();
                }
            }
        }
    }

    public void onExperimentStateChange(ExperimentState newExperimentState) {
        this.updateCanvasStyle(this.experiment.getExperimentState());
    }

    public void onExperimentPartAdded(ExperimentPart experimentPart) {
    }

    private void updateCanvasStyle(ExperimentState newExperimentState) {
        Platform.runLater(() -> this.lambda$updateCanvasStyle$21(switch (newExperimentState) {
            case ExperimentState.EXPIRED, ExperimentState.UNKNOWN, ExperimentState.EMPTY -> ExperimentCanvas.CanvasStyle.EXPIRED;
            case ExperimentState.FUTURE_RESERVATION -> ExperimentCanvas.CanvasStyle.FUTURE_RESERVATION;
            case ExperimentState.TIMEOUT_WAITING, ExperimentState.FAILING, ExperimentState.FAILED -> ExperimentCanvas.CanvasStyle.FAILED;
            default -> ExperimentCanvas.CanvasStyle.FIXED;
        }));
    }

    public AddressPoolCanvasNode getAddressPoolCanvasNode(FXAddressPool addressPool) {
        return this.binding.getAddressPoolCanvasNode(addressPool);
    }

    public RspecCanvasNode getRspecCanvasNode(FXRspecNode node) {
        return this.binding.getRspecCanvasNode(node);
    }

    public RspecCanvasLink getRspecCanvasLink(FXRspecLink link) {
        return this.binding.getRspecCanvasLink(link);
    }

    @Nullable
    private FXRspecNode getSelectedManifestNode() {
        assert (this.getSelectionProvider().getSelectedCanvasNode() instanceof RspecCanvasNode);
        RspecCanvasNode rspecCanvasNode = (RspecCanvasNode)this.getSelectionProvider().getSelectedCanvasNode();
        FXModelRspec manifestRspec = this.getFXManifestRspec();
        if (rspecCanvasNode != null && manifestRspec != null) {
            return manifestRspec.getNodeByUniqueId(rspecCanvasNode.getRspecNode().getUniqueId());
        }
        return null;
    }

    private Sliver getSelectedSliver() {
        FXRspecNode selectedManifestNode = this.getSelectedManifestNode();
        if (selectedManifestNode != null) {
            if (selectedManifestNode.getSliverId() != null) {
                if (this.experimentController.getExperiment().getSliceOrNull() != null) {
                    return this.experimentController.getExperiment().getSliceOrNull().findSliver(selectedManifestNode.getSliverId());
                }
                LOG.error("experimentController.getExperiment().getSlice() is null");
                return null;
            }
            LOG.error("In getSelectedSliver(): Manifest node {} does not have a sliver-Id!", (Object)selectedManifestNode.getUniqueId());
            return null;
        }
        LOG.error("Could not retrieve the selected manifest node!");
        return null;
    }

    private /* synthetic */ void lambda$updateCanvasStyle$21(ExperimentCanvas.CanvasStyle newStyle) {
        this.setCanvasStyle(newStyle);
    }

    public static enum NodeStatus {
        UNINITIALISED,
        READY_WITH_LOGINSERVICES,
        READY_WITHOUT_LOGINSERVICES,
        UNALLOCATED,
        UNKNOWN,
        CHANGING,
        FAIL,
        RESERVATION_FAIL;


        public static NodeStatus fromSliverStatus(@Nullable StatusDetails.SliverStatus sliverStatus, boolean loginServiceAvailable, boolean reservationFailed) {
            if (sliverStatus == null) {
                LOG.warn("NodeStatus.fromSliverStatus(null) called (will return UNKNOWN)");
                return UNKNOWN;
            }
            if (reservationFailed) {
                return RESERVATION_FAIL;
            }
            switch (sliverStatus) {
                case READY: {
                    if (loginServiceAvailable) {
                        return READY_WITH_LOGINSERVICES;
                    }
                    return READY_WITHOUT_LOGINSERVICES;
                }
                case UNINITIALISED: {
                    return UNINITIALISED;
                }
                case UNALLOCATED: {
                    return UNALLOCATED;
                }
                case UNKNOWN: {
                    return UNKNOWN;
                }
                case FAIL: {
                    return FAIL;
                }
                case CHANGING: {
                    return CHANGING;
                }
                case NOTREADY: {
                    return CHANGING;
                }
            }
            LOG.warn("NodeStatus.fromSliverStatus(" + sliverStatus.name() + ") called (unsupported, will return UNKNOWN)");
            return UNKNOWN;
        }
    }
}

