/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.actions;

import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.ExperimentAction;
import be.iminds.ilabt.jfed.experimenter_gui.util.ui.UIUtils;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.util.ExecuteOnNotNull;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.validation.Severity;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import org.controlsfx.validation.decoration.GraphicValidationDecoration;
import org.controlsfx.validation.decoration.ValidationDecoration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDiskImageAction
extends ExperimentAction {
    private static final Logger LOG = LoggerFactory.getLogger(CreateDiskImageAction.class);
    private static final Pattern DISK_IMAGE_PATTERN = Pattern.compile("[A-Za-z0-9_-]{1,30}");
    private final FXRspecNode node;
    private final TestbedInfoSource testbedInfoSource;
    private final AuthorityFinder authorityFinder;
    private static final boolean GLOBAL = true;

    CreateDiskImageAction(Window parentWindow, ExperimentController experimentController, FXRspecNode node, TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder) {
        super(parentWindow, experimentController);
        this.node = node;
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
    }

    @Override
    public void run() {
        assert (Platform.isFxApplicationThread());
        new CreateDiskImageDialog().showDialog();
    }

    private class CreateDiskImageDialog
    extends GridPane {
        private final Dialog<ButtonType> dialog;
        @FXML
        private TextField textField;
        @FXML
        private CheckBox prepareImageCheckBox;

        CreateDiskImageDialog() {
            FXMLUtil.injectFXML((Object)((Object)this));
            this.dialog = new Dialog();
            this.dialog.initOwner(CreateDiskImageAction.this.parentWindow);
            this.dialog.setTitle("Create a Disk Image of " + CreateDiskImageAction.this.node.getClientId());
            this.dialog.setHeaderText("Create a Disk Image of " + CreateDiskImageAction.this.node.getClientId());
            this.dialog.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.UPLOAD, (Color)Color.GREEN));
            this.dialog.getDialogPane().setContent((Node)UIUtils.wrapWithDecorationPane((Node)this));
            this.dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
            this.dialog.resultProperty().addListener(observable -> {
                if (this.dialog.getResult() == ButtonType.OK) {
                    this.createDiskImage();
                }
            });
            ValidationSupport validationSupport = new ValidationSupport();
            validationSupport.registerValidator((Control)this.textField, Validator.createRegexValidator((String)"Please provide a valid disk image name!", (Pattern)DISK_IMAGE_PATTERN, (Severity)Severity.ERROR));
            validationSupport.setValidationDecorator((ValidationDecoration)new GraphicValidationDecoration());
            Node okButton = this.dialog.getDialogPane().lookupButton(ButtonType.OK);
            okButton.disableProperty().bind((ObservableValue)validationSupport.invalidProperty());
            new ExecuteOnNotNull<Scene>(this.sceneProperty()){

                public void run() {
                    Platform.runLater(() -> ((TextField)CreateDiskImageDialog.this.textField).requestFocus());
                }
            };
        }

        private void createDiskImage() {
            Server auth = CreateDiskImageAction.this.authorityFinder.findByUrn(CreateDiskImageAction.this.node.getComponentManagerId(), AuthorityFinder.Purpose.CREATE_SLIVER);
            if (auth == null) {
                LOG.error("Could not fetch authority info for node {} with componentManagerId {}", (Object)CreateDiskImageAction.this.node.getClientId(), (Object)CreateDiskImageAction.this.node.getComponentManagerId());
                return;
            }
            CreateDiskImageAction.this.experimentController.createDiskImage(CreateDiskImageAction.this.node, this.getDiskImageName(), true, this.isPrepareImage());
        }

        public String getDiskImageName() {
            return this.textField.getText();
        }

        public boolean isPrepareImage() {
            return this.prepareImageCheckBox.isSelected();
        }

        public void showDialog() {
            this.dialog.show();
        }
    }
}

