/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.actions;

import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentViewController;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.CreateDiskImageAction;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.ExportToolsConfigFilesAction;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.OpenConsoleAction;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.RebootAction;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.ReloadOSAction;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.SCPAction;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.SaveExperimentDescriptionAction;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.SaveExperimentInfoJsonAction;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.SaveManifestAction;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.ShareLanAction;
import be.iminds.ilabt.jfed.experimenter_gui.ui.progressbar.TaskService;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.preferences.ProxyPreferencesManager;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import com.google.common.eventbus.EventBus;
import javafx.stage.Window;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ExperimentActionsFactory {
    private final TestbedInfoSource testbedInfoSource;
    private final AuthorityFinder authorityFinder;
    private final TaskService taskService;
    private final JFedHLPreferences jFedPreferences;
    private final GeniUserProvider geniUserProvider;
    private final ProxyPreferencesManager proxyPreferencesManager;
    private final EventBus eventBus;

    @Inject
    public ExperimentActionsFactory(TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder, TaskService taskService, JFedHLPreferences jFedPreferences, GeniUserProvider geniUserProvider, ProxyPreferencesManager proxyPreferencesManager, EventBus eventBus) {
        this.testbedInfoSource = testbedInfoSource;
        this.authorityFinder = authorityFinder;
        this.taskService = taskService;
        this.jFedPreferences = jFedPreferences;
        this.geniUserProvider = geniUserProvider;
        this.proxyPreferencesManager = proxyPreferencesManager;
        this.eventBus = eventBus;
    }

    public CreateDiskImageAction createCreateDiskImageAction(Window parentWindow, ExperimentController experimentController, FXRspecNode node) {
        return new CreateDiskImageAction(parentWindow, experimentController, node, this.testbedInfoSource, this.authorityFinder);
    }

    public ReloadOSAction createReloadOSAction(Window parentWindow, ExperimentController experimentController, Sliver sliver) {
        return new ReloadOSAction(parentWindow, experimentController, sliver);
    }

    public OpenConsoleAction createOpenConsoleAction(Window parentWindow, ExperimentController experimentController, Sliver sliver) {
        return new OpenConsoleAction(parentWindow, experimentController, sliver);
    }

    public SaveManifestAction createSaveManifestAction(ExperimentViewController experimentViewController, boolean saveToCsv) {
        return new SaveManifestAction(experimentViewController, saveToCsv, this.taskService, (JFedPreferences)this.jFedPreferences);
    }

    public SaveExperimentInfoJsonAction createSaveExperimentInfoJsonAction(ExperimentViewController experimentViewController) {
        return new SaveExperimentInfoJsonAction(experimentViewController, this.taskService, (JFedPreferences)this.jFedPreferences, this.geniUserProvider);
    }

    public ShareLanAction createShareLanAction(Window parentWindow, ExperimentController experimentController, FXRspecLink rspecLink) {
        return new ShareLanAction(parentWindow, experimentController, rspecLink);
    }

    public RebootAction createRebootAction(Window parentWindow, ExperimentController experimentController, Sliver selectedSliver) {
        return new RebootAction(parentWindow, experimentController, selectedSliver);
    }

    public SaveExperimentDescriptionAction createSaveExperimentDescriptionAction(Window parentWindow, ExperimentViewController experimentViewController) {
        return new SaveExperimentDescriptionAction(parentWindow, experimentViewController, this.taskService, (JFedPreferences)this.jFedPreferences);
    }

    public ExportToolsConfigFilesAction createExportToolsConfigFilesAction(Window parentWindow, ExperimentViewController experimentViewController) {
        return new ExportToolsConfigFilesAction(parentWindow, experimentViewController, this.taskService, this.jFedPreferences, this.geniUserProvider, this.proxyPreferencesManager);
    }

    public SCPAction createSCPUploadAction(Window parentWindow, ExperimentController experimentController, FXRspecNode node) {
        return new SCPAction(parentWindow, experimentController, node, this.eventBus);
    }
}

