/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.actions;

import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentViewController;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.ExperimentViewAction;
import be.iminds.ilabt.jfed.experimenter_gui.ui.PasswordInputDialog;
import be.iminds.ilabt.jfed.experimenter_gui.ui.progressbar.TaskService;
import be.iminds.ilabt.jfed.experimenter_gui.util.FileUtils;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.highlevel.util.FXPlatformUtil;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.PuTTYFilesKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.pref_ssh_key_info.PreferencesPuttySshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.putty.PuTTYPrivateKeyFile;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.preferences.ProxyPreferencesManager;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.util.lib.AnsibleFileWriter;
import java.io.File;
import java.security.PrivateKey;
import java.security.PublicKey;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportToolsConfigFilesAction
extends ExperimentViewAction {
    private static final Logger LOG = LoggerFactory.getLogger(ExportToolsConfigFilesAction.class);
    private static final String ROOT_USERNAME = "root";
    private final TaskService taskService;
    private final JFedHLPreferences jFedPreferences;
    private final GeniUserProvider geniUserProvider;
    private final ProxyPreferencesManager proxyPreferencesManager;

    ExportToolsConfigFilesAction(Window parentWindow, ExperimentViewController experimentViewController, TaskService taskService, JFedHLPreferences jFedPreferences, GeniUserProvider geniUserProvider, ProxyPreferencesManager proxyPreferencesManager) {
        super(experimentViewController);
        this.taskService = taskService;
        this.jFedPreferences = jFedPreferences;
        this.geniUserProvider = geniUserProvider;
        this.proxyPreferencesManager = proxyPreferencesManager;
    }

    @Override
    public void run() {
        FileChooser fc = new FileChooser();
        fc.setTitle("Save tool config files");
        fc.getExtensionFilters().add((Object)FileUtils.ZIP_EXTENSION_FILTER);
        fc.setInitialFileName(this.experiment.getName() + ".zip");
        File initialDir = null;
        if (this.jFedPreferences.containsPreference((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST)) {
            initialDir = new File(this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST));
        } else if (System.getProperty("user.home") != null) {
            initialDir = new File(System.getProperty("user.home"));
        }
        if (initialDir != null && initialDir.exists() && initialDir.isDirectory()) {
            fc.setInitialDirectory(initialDir);
        } else {
            fc.setInitialDirectory(null);
        }
        File file = fc.showSaveDialog(this.parentWindow);
        if (file == null) {
            return;
        }
        this.jFedPreferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST, file.getParentFile().getAbsolutePath());
        if (!file.getAbsolutePath().endsWith(".zip")) {
            file = new File(file.getAbsolutePath() + ".zip");
        }
        Task<Void> saveTask = this.createSaveToolConfigurationFilesTask(file);
        this.taskService.submitTask(saveTask);
    }

    private Task<Void> createSaveToolConfigurationFilesTask(final File file) {
        return new Task<Void>(){

            protected Void call() throws Exception {
                String manifestRspecString;
                JFedConnection.SshProxyInfo proxyInfo;
                PuTTYFilesKeyInfo usedSshKeyInfo;
                this.updateMessage(String.format("Writing tool configuration files to '%s'", file.getAbsolutePath()));
                assert (ExportToolsConfigFilesAction.this.geniUserProvider.isUserLoggedIn());
                GeniUser loggedInUser = ExportToolsConfigFilesAction.this.geniUserProvider.getLoggedInGeniUser();
                assert (loggedInUser != null);
                PrivateKey privateKey = loggedInUser.getPrivateKey();
                PublicKey publicKey = loggedInUser.getPublicKey();
                String passphrase = null;
                PuTTYFilesKeyInfo overriddenSshKeyInfo = ExportToolsConfigFilesAction.this.jFedPreferences.getCustomSshKeyInfo();
                GeniUser geniUser = loggedInUser;
                Object object = usedSshKeyInfo = overriddenSshKeyInfo != null ? overriddenSshKeyInfo : SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)geniUser);
                if (overriddenSshKeyInfo != null) {
                    publicKey = overriddenSshKeyInfo.getPublicKey();
                    if (overriddenSshKeyInfo instanceof PreferencesPuttySshKeyInfo) {
                        PreferencesPuttySshKeyInfo preferencesPuttySshKeyInfo = (PreferencesPuttySshKeyInfo)overriddenSshKeyInfo;
                        PuTTYPrivateKeyFile ppk = preferencesPuttySshKeyInfo.getPPK();
                        assert (ppk != null);
                        if (ppk.isEncrypted()) {
                            boolean success = false;
                            boolean userCancelled = false;
                            while (!success && !userCancelled) {
                                passphrase = (String)FXPlatformUtil.runAndWait(this::getPrivateKeyPassword);
                                if (passphrase != null) {
                                    try {
                                        success = ppk.unlock(passphrase);
                                    }
                                    catch (RuntimeException ex) {
                                        LOG.warn("Error while unlocking ppk: {}. Incorrect passphrase?", (Object)ex.getMessage(), (Object)ex);
                                    }
                                    continue;
                                }
                                userCancelled = true;
                            }
                            privateKey = success ? ppk.getPrivateKey() : null;
                        } else {
                            privateKey = overriddenSshKeyInfo.getPrivateKey();
                        }
                    } else {
                        privateKey = overriddenSshKeyInfo.getPrivateKey();
                    }
                }
                if (privateKey == null) {
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.WARNING);
                        alert.setHeaderText("Private key could not be saved");
                        alert.setContentText("The private key is unavailable, and could not be included into the zip-file.\nYou will have to provide it yourself.");
                        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
                        alert.setResizable(true);
                        alert.show();
                    });
                    LOG.error("No private key available to include into the zip file!");
                }
                if (publicKey == null) {
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.WARNING);
                        alert.setHeaderText("Public key could not be saved");
                        alert.setContentText("The public key is unavailable, and could not be included into the zip-file.\nYou will have to provide it yourself.");
                        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
                        alert.setResizable(true);
                        alert.show();
                    });
                    LOG.error("No public key available to include into the zip file!");
                }
                JFedConnection.SshProxyInfo sshProxyInfo = (proxyInfo = ExportToolsConfigFilesAction.this.proxyPreferencesManager.getSshProxySettings(loggedInUser.getUserAuthorityServer().getTestbed().getProxies(), loggedInUser)) != null && proxyInfo instanceof JFedConnection.SshProxyInfo ? proxyInfo : null;
                String string = manifestRspecString = ExportToolsConfigFilesAction.this.experiment.getSliceOrNull() == null || ExportToolsConfigFilesAction.this.experiment.getSliceOrNull().getManifestRspec() == null ? null : ExportToolsConfigFilesAction.this.experiment.getSliceOrNull().getManifestRspec().getRspecXmlString();
                if (manifestRspecString == null) {
                    Platform.runLater(() -> {
                        Alert alert = new Alert(Alert.AlertType.ERROR);
                        alert.setHeaderText("Manifest not available");
                        alert.setContentText("The manifest containing the experiment details is not available.\n\nNo ansible files can be saved.\n\nPossible reasons: Experiment is not yet fully created or recovered, or the experiment has expired.\nPossible solution: Try refreshing the experiment.");
                        alert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
                        alert.setResizable(true);
                        alert.show();
                    });
                    LOG.error("Manifest not available");
                    return null;
                }
                AnsibleFileWriter ansibleWriter = AnsibleFileWriter.createWithCopiedPrivateKey((BasicStringRspec)new BasicStringRspec(manifestRspecString), (PrivateKey)privateKey, (PublicKey)publicKey, (GeniUser)loggedInUser, (JFedConnection.SshProxyInfo)sshProxyInfo, null);
                this.updateMessage(ansibleWriter.writeFilesToZip(file));
                return null;
            }

            protected void failed() {
                LOG.error("Error while writing tool configuration files", this.getException());
                Platform.runLater(() -> new Alert(Alert.AlertType.ERROR, String.format("Error while saving tool configuration files to '%s':\n%s", file.getAbsolutePath(), this.getException().getLocalizedMessage() == null ? "<no more data available, check debug logs>" : this.getException().getLocalizedMessage()), new ButtonType[0]).show());
                this.updateMessage("Error while writing tool configuration files");
            }

            private String getPrivateKeyPassword() {
                PasswordInputDialog dialog = new PasswordInputDialog();
                dialog.setHeaderText("Private key conversion");
                dialog.setContentText("Please enter the password of your private key:");
                return dialog.showAndWait().orElse(null);
            }
        };
    }
}

