/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.actions;

import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.ExperimentAction;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Window;

public class RebootAction
extends ExperimentAction {
    private final Sliver sliver;

    RebootAction(Window parentWindow, ExperimentController experimentController, Sliver sliver) {
        super(parentWindow, experimentController);
        this.sliver = sliver;
    }

    @Override
    public void run() {
        assert (Platform.isFxApplicationThread());
        Alert confirmAlert = new Alert(Alert.AlertType.WARNING);
        confirmAlert.setContentText(String.format("You are about to reboot sliver %s. All data in memory WILL BE LOST. Are you sure that you want to continue?", this.sliver.getUrnString()));
        confirmAlert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        confirmAlert.setTitle("Rebooting sliver");
        confirmAlert.setResizable(true);
        ButtonType rebootOSButton = new ButtonType("Reboot OS", ButtonBar.ButtonData.OTHER);
        confirmAlert.getButtonTypes().setAll((Object[])new ButtonType[]{rebootOSButton, ButtonType.CANCEL});
        ((Button)confirmAlert.getDialogPane().lookupButton(ButtonType.CANCEL)).setDefaultButton(true);
        confirmAlert.getDialogPane().setMinWidth(450.0);
        confirmAlert.showAndWait().filter(button -> button == rebootOSButton).ifPresent(button -> this.experimentController.reboot(this.sliver));
    }
}

