/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.actions;

import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.ExperimentAction;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import javafx.application.Platform;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.stage.Window;

public class ReloadOSAction
extends ExperimentAction {
    private final Sliver sliver;

    ReloadOSAction(Window parentWindow, ExperimentController experimentController, Sliver sliver) {
        super(parentWindow, experimentController);
        this.sliver = sliver;
    }

    @Override
    public void run() {
        assert (Platform.isFxApplicationThread());
        Alert confirmAlert = new Alert(Alert.AlertType.WARNING);
        confirmAlert.setContentText("This operation will revert the node back to its original image.\n\nAll changes made WILL BE LOST.");
        confirmAlert.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        confirmAlert.setTitle("Reload OS image");
        confirmAlert.setResizable(true);
        ButtonType reloadButtonType = new ButtonType("Reload OS and lose changes", ButtonBar.ButtonData.OTHER);
        confirmAlert.getButtonTypes().setAll((Object[])new ButtonType[]{reloadButtonType, ButtonType.CANCEL});
        ((Button)confirmAlert.getDialogPane().lookupButton(ButtonType.CANCEL)).setDefaultButton(true);
        confirmAlert.getDialogPane().setMinWidth(450.0);
        confirmAlert.showAndWait().filter(button -> button == reloadButtonType).ifPresent(button -> this.experimentController.reloadOS(this.sliver));
    }
}

