/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.actions;

import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.ExperimentAction;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.SCPEvent;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import com.google.common.eventbus.EventBus;
import impl.org.controlsfx.skin.DecorationPane;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Paths;
import javafx.application.Platform;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.validation.ValidationMessage;
import org.controlsfx.validation.ValidationResult;
import org.controlsfx.validation.ValidationSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCPAction
extends ExperimentAction {
    private static final Logger LOG = LoggerFactory.getLogger(SCPAction.class);
    private final FXRspecNode node;
    private final EventBus eventBus;

    public SCPAction(Window parentWindow, ExperimentController experimentController, FXRspecNode node, EventBus eventBus) {
        super(parentWindow, experimentController);
        this.node = node;
        this.eventBus = eventBus;
    }

    @Override
    public void run() {
        assert (Platform.isFxApplicationThread());
        Dialog dialog = new Dialog();
        dialog.initOwner(this.parentWindow);
        dialog.setTitle("Upload file to " + this.node.getClientId());
        dialog.setHeaderText("Upload file to " + this.node.getClientId());
        dialog.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.UPLOAD, (Color)Color.BROWN));
        GridPane dialogContent = new GridPane();
        dialogContent.setHgap(5.0);
        dialogContent.setVgap(10.0);
        dialogContent.add((Node)new Label("Action:"), 0, 0);
        ToggleGroup typeToggleGroup = new ToggleGroup();
        HBox typeHBox = new HBox(5.0);
        RadioButton uploadRadioButton = new RadioButton("Upload");
        RadioButton downloadRadioButton = new RadioButton("Download");
        typeToggleGroup.getToggles().addAll((Object[])new Toggle[]{uploadRadioButton, downloadRadioButton});
        typeToggleGroup.selectToggle((Toggle)uploadRadioButton);
        typeHBox.getChildren().addAll((Object[])new Node[]{uploadRadioButton, downloadRadioButton});
        dialogContent.add((Node)typeHBox, 1, 0);
        Label fromLabel = new Label();
        fromLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> typeToggleGroup.getSelectedToggle() == uploadRadioButton ? "Location:" : "Remote location:", (Observable[])new Observable[]{typeToggleGroup.selectedToggleProperty()}));
        dialogContent.add((Node)fromLabel, 0, 1);
        TextField fromTextField = new TextField();
        fromTextField.setPrefWidth(300.0);
        dialogContent.add((Node)fromTextField, 1, 1);
        MenuButton localBrowseButton = new MenuButton("Browse ...");
        localBrowseButton.visibleProperty().bind((ObservableValue)typeToggleGroup.selectedToggleProperty().isEqualTo((Object)uploadRadioButton));
        dialogContent.add((Node)localBrowseButton, 2, 1);
        MenuItem localFileMenuItem = new MenuItem("File");
        localFileMenuItem.setOnAction(event -> {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("Select file to upload");
            File chosenFile = fileChooser.showOpenDialog(null);
            if (chosenFile != null) {
                fromTextField.setText(chosenFile.getAbsolutePath());
            }
        });
        MenuItem localDirMenuItem = new MenuItem("Directory");
        localDirMenuItem.setOnAction(event -> {
            DirectoryChooser dirChooser = new DirectoryChooser();
            dirChooser.setTitle("Select directory to upload");
            File chosenFile = dirChooser.showDialog(null);
            if (chosenFile != null) {
                fromTextField.setText(chosenFile.getAbsolutePath());
            }
        });
        localBrowseButton.getItems().addAll((Object[])new MenuItem[]{localFileMenuItem, localDirMenuItem});
        Label toLabel = new Label();
        toLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> typeToggleGroup.getSelectedToggle() == uploadRadioButton ? "Remote location:" : "Download folder:", (Observable[])new Observable[]{typeToggleGroup.selectedToggleProperty()}));
        dialogContent.add((Node)toLabel, 0, 2);
        TextField toTextField = new TextField();
        dialogContent.add((Node)toTextField, 1, 2);
        Button toBrowseButton = new Button("Browse ...");
        toBrowseButton.visibleProperty().bind((ObservableValue)typeToggleGroup.selectedToggleProperty().isEqualTo((Object)downloadRadioButton));
        toBrowseButton.setOnAction(event -> {
            DirectoryChooser dirChooser = new DirectoryChooser();
            dirChooser.setTitle("Select directory to download to");
            File chosenFile = dirChooser.showDialog(null);
            if (chosenFile != null) {
                toTextField.setText(chosenFile.getAbsolutePath());
            }
        });
        dialogContent.add((Node)toBrowseButton, 2, 2);
        DecorationPane decorationPane = new DecorationPane();
        decorationPane.getChildren().add((Object)dialogContent);
        dialog.getDialogPane().setContent((Node)decorationPane);
        ValidationSupport validationSupport = new ValidationSupport();
        validationSupport.registerValidator((Control)fromTextField, true, (control, s) -> {
            ValidationResult result = new ValidationResult();
            if (typeToggleGroup.getSelectedToggle() == uploadRadioButton) {
                File localFile = new File((String)s);
                result.addErrorIf(control, "Not a valid file", !localFile.exists());
            } else {
                result.addErrorIf(control, "A remote path is required", s.isEmpty());
                try {
                    Paths.get(s, new String[0]);
                }
                catch (InvalidPathException ex) {
                    result.add(ValidationMessage.error((Control)control, (String)"Not a valid remote path"));
                }
            }
            return result;
        });
        validationSupport.registerValidator((Control)toTextField, true, (control, s) -> {
            ValidationResult result = new ValidationResult();
            if (typeToggleGroup.getSelectedToggle() == downloadRadioButton) {
                File localFile = new File((String)s);
                result.addErrorIf(control, "Not a valid directory", !localFile.exists());
                result.addErrorIf(control, "Not a directory", !localFile.isDirectory());
            } else {
                result.addErrorIf(control, "A remote path is required", s.isEmpty());
                try {
                    Paths.get(s, new String[0]);
                }
                catch (InvalidPathException ex) {
                    result.add(ValidationMessage.error((Control)control, (String)"Not a valid remote path"));
                }
            }
            return result;
        });
        validationSupport.registerValidator((Control)uploadRadioButton, (control, aBoolean) -> new ValidationResult());
        ColumnConstraints firstColumnConstraints = new ColumnConstraints();
        firstColumnConstraints.setPrefWidth(100.0);
        firstColumnConstraints.setHalignment(HPos.RIGHT);
        dialogContent.getColumnConstraints().add((Object)firstColumnConstraints);
        dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, ButtonType.CANCEL});
        Node okButton = dialog.getDialogPane().lookupButton(ButtonType.OK);
        okButton.disableProperty().bind((ObservableValue)validationSupport.invalidProperty());
        dialog.showAndWait().filter(buttonType -> buttonType == ButtonType.OK).ifPresent(buttonType -> this.eventBus.post((Object)new SCPEvent(this.experiment, this.node, typeToggleGroup.getSelectedToggle() == uploadRadioButton, fromTextField.getText(), toTextField.getText())));
    }
}

