/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.actions;

import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentViewController;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.ExperimentViewAction;
import be.iminds.ilabt.jfed.experimenter_gui.ui.progressbar.TaskService;
import be.iminds.ilabt.jfed.experimenter_gui.util.FileUtils;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javafx.concurrent.Task;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveExperimentDescriptionAction
extends ExperimentViewAction {
    private static final Logger LOG = LoggerFactory.getLogger(SaveExperimentDescriptionAction.class);
    private final TaskService taskService;
    private final JFedPreferences jFedPreferences;

    SaveExperimentDescriptionAction(Window parentWindow, ExperimentViewController experimentViewController, TaskService taskService, JFedPreferences jFedPreferences) {
        super(experimentViewController);
        this.taskService = taskService;
        this.jFedPreferences = jFedPreferences;
    }

    @Override
    public void run() {
        FileChooser fc = new FileChooser();
        fc.setTitle("Save experiment description");
        fc.getExtensionFilters().add((Object)FileUtils.RSPEC_EXTENSION_FILTER);
        fc.setInitialFileName(this.experiment.getName() + ".rspec");
        if (this.jFedPreferences.containsPreference((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST)) {
            fc.setInitialDirectory(new File(this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST)));
        } else if (System.getProperty("user.home") != null) {
            fc.setInitialDirectory(new File(System.getProperty("user.home")));
        }
        File file = fc.showSaveDialog(this.parentWindow);
        if (file == null) {
            return;
        }
        this.jFedPreferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST, file.getParentFile().getAbsolutePath());
        if (!file.getAbsolutePath().endsWith(".rspec")) {
            file = new File(file.getAbsolutePath() + ".rspec");
        }
        Task<Void> saveTask = this.createSaveExperimentDefinitionTask(file);
        this.taskService.submitTask(saveTask);
    }

    private Task<Void> createSaveExperimentDefinitionTask(final File file) {
        return new Task<Void>(){

            protected Void call() throws Exception {
                this.updateMessage(String.format("Writing experiment definition to '%s'", file.getAbsolutePath()));
                try (FileWriter writer = new FileWriter(file);){
                    String rspecString = SaveExperimentDescriptionAction.this.experimentViewController.getCanvasRspecSource().getRspecXmlString();
                    assert (rspecString != null);
                    writer.write(rspecString);
                    writer.flush();
                    writer.close();
                    this.updateMessage(String.format("Wrote experiment definition to '%s'", file.getAbsolutePath()));
                }
                catch (IOException ex) {
                    LOG.error("Error while writing experiment description", (Throwable)ex);
                    this.updateMessage("Error while writing experiment description");
                }
                return null;
            }
        };
    }
}

