/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.actions;

import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentViewController;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.ExperimentViewAction;
import be.iminds.ilabt.jfed.experimenter_gui.ui.progressbar.TaskService;
import be.iminds.ilabt.jfed.experimenter_gui.util.FileUtils;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.highlevel.util.ESpecMetaFileCreator;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.stage.FileChooser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveExperimentInfoJsonAction
extends ExperimentViewAction {
    private static final Logger LOG = LoggerFactory.getLogger(SaveExperimentInfoJsonAction.class);
    private final TaskService taskService;
    private final JFedPreferences jFedPreferences;
    private final GeniUserProvider geniUserProvider;

    SaveExperimentInfoJsonAction(ExperimentViewController experimentViewController, TaskService taskService, JFedPreferences jFedPreferences, GeniUserProvider geniUserProvider) {
        super(experimentViewController);
        this.taskService = taskService;
        this.jFedPreferences = jFedPreferences;
        this.geniUserProvider = geniUserProvider;
    }

    @Override
    public void run() {
        File file;
        File dir;
        assert (Platform.isFxApplicationThread());
        FileChooser fc = new FileChooser();
        fc.setTitle("Save experiment-info.json");
        fc.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{FileUtils.JSON_EXTENSION_FILTER, FileUtils.ALL_EXTENSION_FILTER});
        fc.setSelectedExtensionFilter(FileUtils.JSON_EXTENSION_FILTER);
        fc.setInitialFileName(this.experiment.getSliceOrNull().getName() + "-experiment-info.json");
        if (System.getProperty("user.home") != null) {
            fc.setInitialDirectory(new File(System.getProperty("user.home")));
        }
        if (this.jFedPreferences.containsPreference((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST) && (dir = new File(this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST))).exists()) {
            fc.setInitialDirectory(dir);
        }
        if ((file = fc.showSaveDialog(this.parentWindow)) == null) {
            return;
        }
        if (!file.getAbsolutePath().endsWith(".json")) {
            file = new File(file.getAbsolutePath() + ".json");
        }
        SaveExperimentInfoJsonTask saveTask = new SaveExperimentInfoJsonTask(file);
        this.taskService.submitTask(saveTask);
    }

    public class SaveExperimentInfoJsonTask
    extends Task<Void> {
        private final File file;

        public SaveExperimentInfoJsonTask(File file) {
            this.file = file;
        }

        protected Void call() throws Exception {
            byte[] fileContent;
            LOG.debug("Saving experiment info JSON in \"" + this.file.getAbsolutePath() + "\"");
            this.updateMessage("Saving experiment info JSON in \"" + this.file.getAbsolutePath() + "\"");
            try {
                ESpecMetaFileCreator eSpecMetaFileCreator = new ESpecMetaFileCreator(SaveExperimentInfoJsonAction.this.experiment, SaveExperimentInfoJsonAction.this.geniUserProvider.getLoggedInGeniUser());
                fileContent = eSpecMetaFileCreator.getExperimentInfoJson();
            }
            catch (Exception ex) {
                LOG.error("Error while generating experiment info JSON", (Throwable)ex);
                Platform.runLater(() -> JFDialogs.create().owner((Node)SaveExperimentInfoJsonAction.this.experimentViewController).message("An error occurred while generating the experiment-info JSON.").masthead("Error").title("Error").showException((Throwable)ex));
                return null;
            }
            LOG.debug("      experiment info JSON is " + fileContent.length + " bytes long");
            try (FileOutputStream os = new FileOutputStream(this.file);){
                os.write(fileContent);
                os.flush();
                os.close();
            }
            catch (IOException ex) {
                LOG.error("Error while saving experiment info JSON in \"" + this.file.getAbsolutePath() + "\"", (Throwable)ex);
                Platform.runLater(() -> JFDialogs.create().owner((Node)SaveExperimentInfoJsonAction.this.experimentViewController).message("An error occurred while saving the experiment-info JSON.").masthead("Error").title("Error").showException((Throwable)ex));
                return null;
            }
            this.updateMessage("Successfully saved experiment-info JSON in \"" + this.file.getAbsolutePath() + "\"");
            return null;
        }
    }
}

