/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.actions;

import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentViewController;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.ExperimentViewAction;
import be.iminds.ilabt.jfed.experimenter_gui.ui.progressbar.TaskService;
import be.iminds.ilabt.jfed.experimenter_gui.util.FileUtils;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec.model.LoginService;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecInterface;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.scene.Node;
import javafx.stage.FileChooser;

public class SaveManifestAction
extends ExperimentViewAction {
    private final boolean saveToCsv;
    private final TaskService taskService;
    private final JFedPreferences jFedPreferences;

    SaveManifestAction(ExperimentViewController experimentViewController, boolean saveToCsv, TaskService taskService, JFedPreferences jFedPreferences) {
        super(experimentViewController);
        this.saveToCsv = saveToCsv;
        this.taskService = taskService;
        this.jFedPreferences = jFedPreferences;
    }

    @Override
    public void run() {
        Task saveTask;
        File file;
        File dir;
        assert (Platform.isFxApplicationThread());
        FileChooser fc = new FileChooser();
        fc.setTitle("Save Manifest RSpec");
        fc.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{FileUtils.MANIFEST_RSPEC_EXTENSION_FILTER, FileUtils.CSV_EXTENSION_FILTER});
        fc.setSelectedExtensionFilter(this.saveToCsv ? FileUtils.CSV_EXTENSION_FILTER : FileUtils.MANIFEST_RSPEC_EXTENSION_FILTER);
        fc.setInitialFileName(this.experiment.getSliceOrNull().getName() + ".mrspec");
        if (System.getProperty("user.home") != null) {
            fc.setInitialDirectory(new File(System.getProperty("user.home")));
        }
        if (this.jFedPreferences.containsPreference((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST) && (dir = new File(this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST))).exists()) {
            fc.setInitialDirectory(dir);
        }
        if ((file = fc.showSaveDialog(this.parentWindow)) == null) {
            return;
        }
        this.jFedPreferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST, file.getParentFile().getAbsolutePath());
        if (fc.getSelectedExtensionFilter() == FileUtils.CSV_EXTENSION_FILTER) {
            if (!file.getAbsolutePath().endsWith(".csv")) {
                file = new File(file.getAbsolutePath() + ".csv");
            }
            saveTask = new SaveCSVTask(file);
        } else {
            if (!file.getAbsolutePath().endsWith(".mrspec")) {
                file = new File(file.getAbsolutePath() + ".mrspec");
            }
            saveTask = new SaveManifestTask(file);
        }
        this.taskService.submitTask(saveTask);
    }

    public class SaveCSVTask
    extends Task<Void> {
        private final File file;

        public SaveCSVTask(File file) {
            this.file = file;
        }

        protected Void call() throws Exception {
            this.updateMessage("Saving experiment CSV in \"" + this.file.getAbsolutePath() + "\"");
            try (FileWriter writer = new FileWriter(this.file);){
                FXModelRspec modelRspec = (FXModelRspec)SaveManifestAction.this.experiment.getSliceOrNull().getManifestRspec().getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
                int maxIfacesCount = modelRspec.getNodes().stream().map(FXRspecNode::getInterfaces).mapToInt(List::size).max().orElse(0);
                int[] ipAddressesCount = new int[maxIfacesCount];
                for (FXRspecNode node : modelRspec.getNodes()) {
                    for (int i = 0; i < node.getInterfaces().size(); ++i) {
                        ipAddressesCount[i] = Math.max(((FXRspecInterface)node.getInterfaces().get(i)).getIpAddresses().size(), ipAddressesCount[i]);
                    }
                }
                writer.write("node_id, authentication_type, hostname, port, username");
                for (int i = 0; i < maxIfacesCount; ++i) {
                    writer.write(", iface_id#, mac#".replace("#", Integer.toString(i + 1)));
                    for (int j = 0; j < ipAddressesCount[i]; ++j) {
                        writer.write(", ip#_$, netmask#_$".replace("#", Integer.toString(i + 1)).replace("$", Integer.toString(j + 1)));
                    }
                }
                writer.write(String.format("%n", new Object[0]));
                writer.flush();
                for (FXRspecNode node : modelRspec.getNodes()) {
                    StringBuilder ifacesStringBuilder = new StringBuilder();
                    for (int i = 0; i < maxIfacesCount; ++i) {
                        if (i < node.getInterfaces().size()) {
                            FXRspecInterface iface = (FXRspecInterface)node.getInterfaces().get(i);
                            ifacesStringBuilder.append(iface.getClientId()).append(",").append(iface.getMacAddress()).append(",");
                            for (int j = 0; j < ipAddressesCount[i]; ++j) {
                                if (j < iface.getIpAddresses().size()) {
                                    RspecInterface.IpAddress address = (RspecInterface.IpAddress)iface.getIpAddresses().get(j);
                                    ifacesStringBuilder.append(address.getAddress()).append(",").append(address.getNetmask()).append(",");
                                    continue;
                                }
                                ifacesStringBuilder.append(",,");
                            }
                            continue;
                        }
                        ifacesStringBuilder.append(",,");
                        for (int j = 0; j < ipAddressesCount[i]; ++j) {
                            ifacesStringBuilder.append(",,");
                        }
                    }
                    for (LoginService loginService : node.getLoginServices()) {
                        writer.write(String.format("%s, %s, %s, %s, %s,", node.getClientId(), loginService.getAuthentication(), loginService.getHostname(), loginService.getPort(), loginService.getUsername()));
                        writer.write(ifacesStringBuilder.toString());
                        writer.write(String.format("%n", new Object[0]));
                        writer.flush();
                    }
                }
                writer.close();
            }
            catch (IOException ex) {
                Platform.runLater(() -> JFDialogs.create().owner((Node)SaveManifestAction.this.experimentViewController).message("An error occurred while saving the experiment CSV.").masthead("Error").title("Error").showException((Throwable)ex));
            }
            this.updateMessage("Successfully saved experiment CSV in \"" + this.file.getAbsolutePath() + "\"");
            return null;
        }
    }

    public class SaveManifestTask
    extends Task<Void> {
        private final File file;

        public SaveManifestTask(File file) {
            this.file = file;
        }

        protected Void call() throws Exception {
            this.updateMessage("Saving experiment manifest in \"" + this.file.getAbsolutePath() + "\"");
            try (FileWriter writer = new FileWriter(this.file);){
                writer.write(SaveManifestAction.this.experiment.getSliceOrNull().getManifestRspec().getRspecXmlString());
                writer.flush();
                writer.close();
            }
            catch (IOException ex) {
                Platform.runLater(() -> JFDialogs.create().owner((Node)SaveManifestAction.this.experimentViewController).message("An error occurred while saving the manifest rspec.").masthead("Error").title("Error").showException((Throwable)ex));
            }
            this.updateMessage("Successfully saved manifest experiment in \"" + this.file.getAbsolutePath() + "\"");
            return null;
        }
    }
}

