/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.actions;

import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experimenter_gui.slice.actions.ExperimentAction;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecLink;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.TextField;
import javafx.scene.layout.GridPane;
import javafx.scene.paint.Color;
import javafx.stage.Window;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShareLanAction
extends ExperimentAction {
    private static final Logger LOG = LoggerFactory.getLogger(ShareLanAction.class);
    private final FXRspecLink link;

    public ShareLanAction(Window parentWindow, ExperimentController experimentController, FXRspecLink link) {
        super(parentWindow, experimentController);
        this.link = link;
    }

    @Override
    public void run() {
        new SharedLanDialog().showDialog();
    }

    private class SharedLanDialog
    extends GridPane {
        private final Dialog<ButtonType> dialog;
        @FXML
        private TextField linkClientIdField;
        @FXML
        private TextField sharedLanNameField;
        @FXML
        private Glyph invalidNameGlyph;
        private final ButtonType shareAction;
        private final ButtonType unshareAction;

        SharedLanDialog() {
            FXMLUtil.injectFXML((Object)((Object)this));
            this.shareAction = new ButtonType("Share LAN", ButtonBar.ButtonData.OK_DONE);
            this.unshareAction = new ButtonType("Unshare LAN", ButtonBar.ButtonData.OK_DONE);
            this.linkClientIdField.setText(ShareLanAction.this.link.getClientId());
            this.sharedLanNameField.setText("shared_lan_" + ShareLanAction.this.link.getClientId());
            this.dialog = new Dialog();
            this.dialog.initOwner(ShareLanAction.this.parentWindow);
            this.dialog.setTitle("Share/Unshare LAN" + ShareLanAction.this.link.getClientId());
            this.dialog.setHeaderText("Share/Unshare LAN " + ShareLanAction.this.link.getClientId());
            this.dialog.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.SHARE_ALT, (Color)Color.GREEN));
            this.dialog.setResizable(true);
            this.dialog.getDialogPane().setContent((Node)this);
            this.dialog.getDialogPane().getButtonTypes().setAll((Object[])new ButtonType[]{this.shareAction, this.unshareAction, ButtonType.CANCEL});
            this.dialog.resultProperty().addListener(observable -> {
                if (this.dialog.getResult() == this.shareAction) {
                    this.onShareLanAction();
                } else if (this.dialog.getResult() == this.unshareAction) {
                    this.onUnshareLanAction();
                }
            });
            Node shareButton = this.dialog.getDialogPane().lookupButton(this.shareAction);
            Node unshareButton = this.dialog.getDialogPane().lookupButton(this.unshareAction);
            BooleanBinding isValidLanNameBinding = Bindings.createBooleanBinding(this::isValidLanName, (Observable[])new Observable[]{this.sharedLanNameField.textProperty()});
            shareButton.disableProperty().bind((ObservableValue)isValidLanNameBinding.not());
            unshareButton.disableProperty().bind((ObservableValue)isValidLanNameBinding.not());
            this.invalidNameGlyph.visibleProperty().bind((ObservableValue)isValidLanNameBinding.not());
        }

        public void showDialog() {
            this.dialog.show();
        }

        private boolean isValidLanName() {
            this.sharedLanNameField.setText(this.sharedLanNameField.getText().trim());
            String sharedLanName = this.sharedLanNameField.getText();
            return sharedLanName.matches("[\\w-]*");
        }

        private void onUnshareLanAction() {
            assert (this.isValidLanName());
            String sharedLanName = this.sharedLanNameField.getText();
            ShareLanAction.this.experimentController.unshareLan(ShareLanAction.this.link, sharedLanName);
        }

        private void onShareLanAction() {
            assert (this.isValidLanName());
            String sharedLanName = this.sharedLanNameField.getText();
            ShareLanAction.this.experimentController.shareLan(ShareLanAction.this.link, sharedLanName);
        }
    }
}

