/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.ansible;

import be.iminds.ilabt.jfed.rspec.model.AnsibleService;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextArea;
import javafx.scene.image.ImageView;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnsibleOutputTab
extends Tab {
    private static final Logger LOG = LoggerFactory.getLogger(AnsibleOutputTab.class);
    private final RspecNode node;
    private final AnsibleService ansibleService;
    private final TabPane content;

    public AnsibleOutputTab(RspecNode node, AnsibleService ansibleService, StringProperty galaxyStdOut, StringProperty galaxyStdErr, StringProperty playbookStdOut, StringProperty playbookStdErr) {
        this.node = node;
        this.ansibleService = ansibleService;
        this.setText(String.format("Ansible playbook '%s'@%s", this.ansibleService.getExecutePlaybook(), this.node.getClientId()));
        ImageView graphic = new ImageView(((Object)((Object)this)).getClass().getResource("ansible.png").toExternalForm());
        graphic.setFitHeight(16.0);
        graphic.setFitWidth(16.0);
        graphic.setPreserveRatio(true);
        this.setGraphic((Node)graphic);
        this.content = new TabPane();
        this.content.setTabClosingPolicy(TabPane.TabClosingPolicy.UNAVAILABLE);
        this.content.setSide(Side.LEFT);
        this.content.getTabs().add((Object)new InputStreamToTextAreaTab(playbookStdOut, (Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.PLAY), "Playbook Out"));
        this.content.getTabs().add((Object)new InputStreamToTextAreaTab(playbookStdErr, (Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.EXCLAMATION_TRIANGLE), "Playbook Err"));
        this.content.getTabs().add((Object)new InputStreamToTextAreaTab(galaxyStdOut, (Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.DOWNLOAD), "Galaxy Out"));
        this.content.getTabs().add((Object)new InputStreamToTextAreaTab(galaxyStdErr, (Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.EXCLAMATION_CIRCLE), "Galaxy Err"));
        this.setContent((Node)this.content);
    }

    private static class InputStreamToTextAreaTab
    extends Tab {
        private final TextArea textArea;

        private InputStreamToTextAreaTab(StringProperty content, Node graphic, String text) {
            this.setGraphic(graphic);
            this.setText(text);
            this.textArea = new TextArea();
            this.textArea.setWrapText(true);
            this.textArea.setEditable(false);
            this.setContent((Node)this.textArea);
            this.textArea.textProperty().bind((ObservableValue)content);
            this.textArea.textProperty().addListener(observable -> this.textArea.setScrollTop(Double.MAX_VALUE));
        }
    }
}

