/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.errors;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.experiment.tasks.TaskExecutionFinishedListener;
import be.iminds.ilabt.jfed.experimenter_gui.call_gui.TasksWindow;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsCache;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsRef;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.VBox;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ErrorDialogs
implements TaskExecutionFinishedListener {
    private final TasksWindow tasksWindow;
    private final ApiCallDetailsCache apiCallDetailsCache;
    private static ErrorDialogDefinition[] ERROR_DIALOG_DEFS = new ErrorDialogDefinition[]{new DuplicateSlicenameErrorDialogDef(), new CouldNotMapToResourcesDef(), new TermsAndConditionsNotAcceptedDef(), new ReservationProblemDef()};

    @Inject
    public ErrorDialogs(TasksWindow tasksWindow, ApiCallDetailsCache apiCallDetailsCache) {
        this.tasksWindow = tasksWindow;
        this.apiCallDetailsCache = apiCallDetailsCache;
    }

    public void onTaskExecutionFinished(TaskExecution<?> taskExecution) {
        for (ApiCallDetailsRef apiCallDetailsRef : taskExecution.getApiCallHistory()) {
            SerializableApiCallDetails details = this.apiCallDetailsCache.getApiCallDetails(apiCallDetailsRef);
            if (details == null || details.getGeniResponseCodeIsSuccess() == null || details.getGeniResponseCodeIsSuccess().booleanValue() || details.getGeniResponseOutput() == null) continue;
            this.processCallError(details);
        }
    }

    private void processCallError(SerializableApiCallDetails details) {
        for (ErrorDialogDefinition errorDialogDef : ERROR_DIALOG_DEFS) {
            if (!errorDialogDef.matchesCallError(details)) continue;
            Platform.runLater(() -> {
                Alert error = new Alert(Alert.AlertType.ERROR);
                error.setTitle(errorDialogDef.getDialogTitle(details));
                error.setHeaderText(error.getTitle());
                error.setContentText(errorDialogDef.getDialogMessage(details));
                error.setResizable(true);
                String detailsMessage = errorDialogDef.getDialogDetailsMessage(details);
                if (detailsMessage != null) {
                    TextArea detailsTextArea = new TextArea(detailsMessage);
                    detailsTextArea.setEditable(false);
                    detailsTextArea.setWrapText(true);
                    detailsTextArea.setPrefHeight(300.0);
                    detailsTextArea.setPrefHeight(250.0);
                    VBox detailsRoot = new VBox(5.0);
                    detailsRoot.getChildren().setAll((Object[])new Node[]{new Label("Details:"), detailsTextArea});
                    error.getDialogPane().setExpandableContent((Node)detailsRoot);
                }
                ButtonType moreInfoButton = new ButtonType("More Info");
                error.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK, moreInfoButton});
                error.showAndWait().filter(buttonType -> buttonType == moreInfoButton).ifPresent(buttonType -> this.tasksWindow.showApiCall(details));
            });
        }
    }

    public static boolean isCommonError(SerializableApiCallDetails details, AbstractGeniAggregateManager.CommonAMError amError) {
        return AbstractGeniAggregateManager.isCommonError((Integer)details.getGeniResponseCode(), (String)details.getGeniResponseOutput(), (String)details.getXmlRpcGeniResponseValue(), (AbstractGeniAggregateManager.CommonAMError)amError);
    }

    private static interface ErrorDialogDefinition {
        public boolean matchesCallError(SerializableApiCallDetails var1);

        @Nonnull
        public String getDialogTitle(SerializableApiCallDetails var1);

        @Nonnull
        public String getDialogMessage(SerializableApiCallDetails var1);

        @Nullable
        public String getDialogDetailsMessage(SerializableApiCallDetails var1);
    }

    private static class DuplicateSlicenameErrorDialogDef
    implements ErrorDialogDefinition {
        private DuplicateSlicenameErrorDialogDef() {
        }

        @Override
        public boolean matchesCallError(SerializableApiCallDetails details) {
            return details.getXmlRpcGeniResponseOutput().contains("already a registered slice") || details.getXmlRpcGeniResponseOutput().contains("has the same name as the slice you are trying to create");
        }

        @Override
        public String getDialogTitle(SerializableApiCallDetails details) {
            return "Experiment name already in use";
        }

        @Override
        public String getDialogMessage(SerializableApiCallDetails details) {
            return "The requested experiment name is already in use. Please create your experiment with a different name.";
        }

        @Override
        @Nullable
        public String getDialogDetailsMessage(SerializableApiCallDetails details) {
            return null;
        }
    }

    private static class CouldNotMapToResourcesDef
    implements ErrorDialogDefinition {
        private CouldNotMapToResourcesDef() {
        }

        @Override
        public boolean matchesCallError(SerializableApiCallDetails details) {
            return ErrorDialogs.isCommonError(details, AbstractGeniAggregateManager.CommonAMError.NOT_ENOUGH_FREE_RESOURCES);
        }

        @Override
        public String getDialogTitle(SerializableApiCallDetails details) {
            return "Request could not be mapped to resources";
        }

        @Override
        public String getDialogMessage(SerializableApiCallDetails details) {
            return "Your request could not be mapped to resources on the testbed. Either your requested topology is impossible, or not enough resources are currently available.";
        }

        @Override
        @Nullable
        public String getDialogDetailsMessage(SerializableApiCallDetails details) {
            if (details.getXmlRpcGeniResponseOutput() != null) {
                return details.getXmlRpcGeniResponseOutput().replace("\\n", "\n").trim();
            }
            return null;
        }
    }

    private static class TermsAndConditionsNotAcceptedDef
    implements ErrorDialogDefinition {
        private TermsAndConditionsNotAcceptedDef() {
        }

        @Override
        public boolean matchesCallError(SerializableApiCallDetails details) {
            return ErrorDialogs.isCommonError(details, AbstractGeniAggregateManager.CommonAMError.TERMS_AND_SERVICES_NOT_ACCEPTED);
        }

        @Override
        public String getDialogTitle(SerializableApiCallDetails details) {
            return "Testbed Terms & Conditions not accepted";
        }

        @Override
        public String getDialogMessage(SerializableApiCallDetails details) {
            return "The testbed refused you access, because it has no record that you have accepted the Terms & Conditions for the testbed. When starting the experiment in jFed, you can go to the page with the Terms & Conditions for the testbed. The error message details should also contain the URL of that page. ";
        }

        @Override
        @Nullable
        public String getDialogDetailsMessage(SerializableApiCallDetails details) {
            if (details.getXmlRpcGeniResponseOutput() != null) {
                return details.getXmlRpcGeniResponseOutput().replace("\\n", "\n").trim();
            }
            return null;
        }
    }

    private static class ReservationProblemDef
    implements ErrorDialogDefinition {
        private ReservationProblemDef() {
        }

        @Override
        public boolean matchesCallError(SerializableApiCallDetails details) {
            return ErrorDialogs.isCommonError(details, AbstractGeniAggregateManager.CommonAMError.RESERVATION_PROBLEM);
        }

        @Override
        public String getDialogTitle(SerializableApiCallDetails details) {
            return "Problem with Resource Reservation";
        }

        @Override
        public String getDialogMessage(SerializableApiCallDetails details) {
            return "The requested action was refused, because of an issue with resource reservation on the testbed. You probably have not reserved resources, or have not extended the reservation before renewing the experiment.";
        }

        @Override
        @Nullable
        public String getDialogDetailsMessage(SerializableApiCallDetails details) {
            if (details.getXmlRpcGeniResponseOutput() != null) {
                return details.getXmlRpcGeniResponseOutput().replace("\\n", "\n").trim();
            }
            return null;
        }
    }
}

