/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.errors;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetails;
import be.iminds.ilabt.jfed.experiment.tasks.TaskExecutionFinishedListener;
import be.iminds.ilabt.jfed.experimenter_gui.call_gui.TasksWindow;
import be.iminds.ilabt.jfed.experimenter_gui.slice.errors.ApiCallErrorDetails;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.tasks.StatusTask;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsCache;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsRef;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.ErrorDetails;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.util.BindingsUtil;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Service;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javax.inject.Inject;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorsView
extends ListView<ErrorDetails>
implements TaskExecutionFinishedListener {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorsView.class);
    private static final Set<String> IGNORABLE_GENI_RESPONSE_VALUES;
    private static final DateFormat DATE_FORMAT;
    private final BooleanProperty newItemsAvailable = new SimpleBooleanProperty(false);
    private final TasksWindow tasksWindow;
    private final ApiCallDetailsCache apiCallDetailsCache;
    private final BrowserUtil browserUtil;

    @Inject
    public ErrorsView(TasksWindow tasksWindow, ApiCallDetailsCache apiCallDetailsCache, BrowserUtil browserUtil) {
        this.getItems().addListener(change -> {
            while (change.next()) {
                if (!change.wasAdded()) continue;
                this.newItemsAvailable.set(true);
            }
        });
        this.setCellFactory(errorDetailsListView -> new ErrorDetailsListCell());
        this.setPrefHeight(100.0);
        this.tasksWindow = tasksWindow;
        this.apiCallDetailsCache = apiCallDetailsCache;
        this.browserUtil = browserUtil;
    }

    public boolean getNewItemsAvailable() {
        return this.newItemsAvailable.get();
    }

    public BooleanProperty newItemsAvailableProperty() {
        return this.newItemsAvailable;
    }

    public void setNewItemsAvailable(boolean newItemsAvailable) {
        this.newItemsAvailable.set(newItemsAvailable);
    }

    public void onTaskExecutionFinished(TaskExecution<?> taskExecution) {
        StatusTask statusTask;
        StatusDetails statusDetails;
        Task task = taskExecution.getTask();
        GeniUrn sliverUrn = null;
        GeniUrn componentUrn = null;
        boolean errorFoundInCall = false;
        for (ApiCallDetailsRef apiCallDetailsRef : taskExecution.getApiCallHistory()) {
            SerializableApiCallDetails details = this.apiCallDetailsCache.getApiCallDetails(apiCallDetailsRef);
            if (details == null || details.getGeniResponseCodeIsSuccess() == null || details.getGeniResponseCodeIsSuccess().booleanValue() || details.getGeniResponseOutput() == null) continue;
            StringBuilder message = new StringBuilder();
            message.append(task.getName()).append(": ");
            if (details.getXmlRpcGeniResponseValue() != null && !IGNORABLE_GENI_RESPONSE_VALUES.contains(details.getXmlRpcGeniResponseValue())) {
                message.append(details.getXmlRpcGeniResponseValue());
                message.append(" --- ");
            }
            message.append(details.getGeniResponseOutput());
            Platform.runLater(() -> this.getItems().add((Object)new ApiCallErrorDetails(message.toString(), sliverUrn, componentUrn, taskExecution, apiCallDetailsRef)));
            errorFoundInCall = true;
        }
        if (task instanceof StatusTask && !(statusDetails = (statusTask = (StatusTask)task).getStatusDetails()).getAllErrors().isEmpty()) {
            Platform.runLater(() -> this.getItems().addAll((Collection)statusDetails.getAllErrors()));
        }
        if (!errorFoundInCall && taskExecution.getException() != null) {
            Platform.runLater(() -> this.getItems().add((Object)new ApiCallErrorDetails(task.getName() + ": " + String.valueOf(taskExecution.getException()), taskExecution, null)));
        }
    }

    static {
        DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        IGNORABLE_GENI_RESPONSE_VALUES = new HashSet<String>();
        IGNORABLE_GENI_RESPONSE_VALUES.add("");
        IGNORABLE_GENI_RESPONSE_VALUES.add("0");
    }

    private class ErrorDetailsListCell
    extends ListCell<ErrorDetails> {
        private final ErrorUrlInspectionService errorUrlInspectionService = new ErrorUrlInspectionService();
        private final Label label = new Label();
        private final Button goToErrorWebpageButton = new Button();
        private final Button goToCallButton = new Button();
        private final HBox container = new HBox(5.0);

        private ErrorDetailsListCell() {
            this.label.setWrapText(true);
            this.goToErrorWebpageButton.managedProperty().bind((ObservableValue)this.goToErrorWebpageButton.visibleProperty());
            this.goToErrorWebpageButton.setTooltip(new Tooltip("Go to authority error information page"));
            this.goToErrorWebpageButton.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.EYE));
            this.goToErrorWebpageButton.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.goToErrorWebpageButton.setOnAction(event -> {
                assert (this.errorUrlInspectionService.getValue() != null);
                ErrorsView.this.browserUtil.openUrlInBrowser((URL)this.errorUrlInspectionService.getValue());
            });
            this.goToErrorWebpageButton.visibleProperty().bind((ObservableValue)this.errorUrlInspectionService.valueProperty().isNotNull());
            this.goToErrorWebpageButton.setMinWidth(35.0);
            this.goToCallButton.managedProperty().bind((ObservableValue)this.goToCallButton.visibleProperty());
            this.goToCallButton.setTooltip(new Tooltip("View call details"));
            this.goToCallButton.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.DASHBOARD));
            this.goToCallButton.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
            this.goToCallButton.visibleProperty().bind((ObservableValue)BindingsUtil.instanceOfBinding((ObservableValue)this.itemProperty(), ApiCallErrorDetails.class));
            this.goToCallButton.setOnAction(event -> {
                ApiCallErrorDetails apiCallErrorDetails = (ApiCallErrorDetails)((Object)((Object)this.getItem()));
                if (apiCallErrorDetails.getApiCallDetailsRef() != null) {
                    ErrorsView.this.tasksWindow.showApiCall(apiCallErrorDetails.getApiCallDetailsRef());
                } else {
                    ErrorsView.this.tasksWindow.showTaskExecution(apiCallErrorDetails.getTaskExecution());
                }
            });
            this.goToCallButton.setMinWidth(35.0);
            Pane fillerPane = new Pane();
            HBox.setHgrow((Node)fillerPane, (Priority)Priority.SOMETIMES);
            HBox.setHgrow((Node)this.label, (Priority)Priority.ALWAYS);
            HBox.setHgrow((Node)this.goToErrorWebpageButton, (Priority)Priority.NEVER);
            HBox.setHgrow((Node)this.goToCallButton, (Priority)Priority.NEVER);
            this.label.maxWidthProperty().bind((ObservableValue)this.container.widthProperty().subtract((ObservableNumberValue)this.goToErrorWebpageButton.widthProperty()).subtract((ObservableNumberValue)this.goToCallButton.widthProperty()).subtract((ObservableNumberValue)this.container.spacingProperty().multiply((ObservableNumberValue)Bindings.size((ObservableList)this.container.getChildren()))).subtract(5));
            this.container.getChildren().addAll((Object[])new Node[]{this.label, fillerPane, this.goToErrorWebpageButton, this.goToCallButton});
            this.setGraphic((Node)this.container);
        }

        protected void updateItem(ErrorDetails errorDetails, boolean b) {
            super.updateItem((Object)errorDetails, b);
            if (errorDetails != null) {
                SerializableApiCallDetails apiCallDetails;
                ApiCallErrorDetails apiCallErrorDetails;
                StringBuilder sb = new StringBuilder();
                sb.append(DATE_FORMAT.format(new Date(errorDetails.getTimestamp())));
                sb.append(" ");
                if (errorDetails.getSliverUrn() != null) {
                    sb.append("[");
                    sb.append(errorDetails.getSliverUrn().getEncodedResourceName());
                    sb.append("] ");
                }
                if (errorDetails.getComponentUrn() != null) {
                    sb.append("{");
                    sb.append(errorDetails.getComponentUrn().getEncodedResourceName());
                    sb.append("} ");
                }
                sb.append(errorDetails.getError());
                this.label.setText(sb.toString());
                Object errorUrl = null;
                if (errorDetails instanceof ApiCallErrorDetails && (apiCallErrorDetails = (ApiCallErrorDetails)errorDetails).getApiCallDetailsRef() != null && (apiCallDetails = ErrorsView.this.apiCallDetailsCache.getApiCallDetails(apiCallErrorDetails.getApiCallDetailsRef())) != null && apiCallDetails.getProtogeniSpewLogUrl() != null && !apiCallDetails.getProtogeniSpewLogUrl().trim().isEmpty()) {
                    try {
                        this.errorUrlInspectionService.setUrl(new URL(apiCallDetails.getProtogeniSpewLogUrl()));
                        this.errorUrlInspectionService.restart();
                    }
                    catch (MalformedURLException e) {
                        LOG.error("Cannot parse ProtogeniSpewLogUrl '{}'", (Object)apiCallDetails.getProtogeniSpewLogUrl(), (Object)e);
                    }
                }
            } else {
                this.label.setText("");
            }
        }
    }

    private static final class ErrorUrlInspectionService
    extends Service<URL> {
        private final HttpClient httpClient = HttpClients.createDefault();
        private final ObjectProperty<URL> url = new SimpleObjectProperty();

        private ErrorUrlInspectionService() {
        }

        public void setUrl(URL url) {
            this.url.set((Object)url);
        }

        protected javafx.concurrent.Task<URL> createTask() {
            return new javafx.concurrent.Task<URL>(){

                protected URL call() throws Exception {
                    URL errorUrl = (URL)url.get();
                    try {
                        HttpHead errorHead = new HttpHead(errorUrl.toURI());
                        HttpResponse response = httpClient.execute((HttpUriRequest)errorHead);
                        if (response.getStatusLine().getStatusCode() == 200) {
                            LOG.trace("Got status-code {} when retrieving ProtogeniSpewLogUrl '{}'. Showing go-to-webpage-button.", (Object)response.getStatusLine().getStatusCode(), (Object)errorUrl);
                            return errorUrl;
                        }
                        LOG.info("Got status-code {} when retrieving ProtogeniSpewLogUrl '{}'. Not showing go-to-webpage-button.", (Object)response.getStatusLine().getStatusCode(), (Object)errorUrl);
                        return null;
                    }
                    catch (IOException | URISyntaxException e) {
                        LOG.error("Something went wrong while querying the ProtogeniSpewLogUrl", (Throwable)e);
                        return null;
                    }
                }
            };
        }

        public URL getUrl() {
            return (URL)this.url.get();
        }
    }
}

