/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.errors;

import be.iminds.ilabt.jfed.experimenter_gui.slice.errors.ErrorsView;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.WritableValue;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.paint.Color;
import javafx.util.Duration;
import org.controlsfx.glyphfont.FontAwesome;
import org.controlsfx.glyphfont.Glyph;
import org.controlsfx.glyphfont.GlyphFont;
import org.controlsfx.glyphfont.GlyphFontRegistry;

public class ErrorsViewTab
extends Tab {
    private static final GlyphFont fontAwesome = GlyphFontRegistry.font((String)"FontAwesome");
    private final ErrorsView errorsView;
    private final Glyph errorIcon = fontAwesome.create((Enum)FontAwesome.Glyph.TIMES_CIRCLE);
    private final Timeline timeline = new Timeline();

    public ErrorsViewTab(ErrorsView errorsView) {
        this.setText("Errors");
        this.setGraphic((Node)this.errorIcon);
        this.setClosable(false);
        this.timeline.setCycleCount(-1);
        this.timeline.setAutoReverse(true);
        KeyValue visibleKeyValue = new KeyValue((WritableValue)this.errorIcon.opacityProperty(), (Object)0.0);
        KeyFrame visibleFrame = new KeyFrame(Duration.millis((double)700.0), new KeyValue[]{visibleKeyValue});
        this.timeline.getKeyFrames().addAll((Object[])new KeyFrame[]{visibleFrame, visibleFrame});
        this.errorsView = errorsView;
        this.setContent((Node)errorsView);
        errorsView.newItemsAvailableProperty().addListener(observable -> {
            if (this.errorsView.getNewItemsAvailable()) {
                if (this.isSelected()) {
                    this.errorsView.setNewItemsAvailable(false);
                } else {
                    this.errorIcon.setColor(Color.RED);
                    this.timeline.playFromStart();
                }
            } else {
                this.errorIcon.setColor(Color.BLACK);
                this.timeline.stop();
                this.errorIcon.setOpacity(1.0);
            }
        });
        this.selectedProperty().addListener(observable -> this.errorsView.setNewItemsAvailable(false));
    }
}

