/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.espec.model;

import be.iminds.ilabt.jfed.espec.model.ESpecStep;
import be.iminds.ilabt.jfed.espec.model.UploadLikeSpec;
import be.iminds.ilabt.jfed.espec.util.LimitedLiveLog;
import be.iminds.ilabt.jfed.espec.util.UploadProgressTracker;
import be.iminds.ilabt.jfed.experimenter_gui.slice.espec.model.ESpecStateItem;
import be.iminds.ilabt.jfed.experimenter_gui.ui.status.TaskStatusIndicator;
import java.util.Objects;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public class ESpecLogItem
implements Comparable<ESpecLogItem> {
    private final long id;
    private final ObjectProperty<TaskStatusIndicator.Status> status = new SimpleObjectProperty();
    private final StringProperty text = new SimpleStringProperty();
    private final StringProperty statusText = new SimpleStringProperty();
    private final ObjectProperty<ESpecStateItem> eSpecStateItem = new SimpleObjectProperty();
    @Nullable
    private final ESpecStep especStep;
    @Nullable
    private final UploadProgressTracker uploadProgressTracker;
    @Nullable
    private final LimitedLiveLog limitedLiveLog;
    private final IntegerProperty logByteSize = new SimpleIntegerProperty();
    private final DoubleProperty progress = new SimpleDoubleProperty();

    public ESpecLogItem(long id, @Nonnull String text, @Nonnull TaskStatusIndicator.Status status, @Nullable ESpecStep especStep, @Nullable UploadProgressTracker uploadProgressTracker, @Nullable LimitedLiveLog limitedLiveLog) {
        this.id = id;
        this.text.set((Object)text);
        this.status.set((Object)status);
        this.especStep = especStep;
        this.uploadProgressTracker = uploadProgressTracker;
        this.limitedLiveLog = limitedLiveLog;
        if (uploadProgressTracker != null) {
            uploadProgressTracker.addChangeListener(t -> this.progress.setValue((Number)t.getPercentProgress()));
        }
        if (limitedLiveLog != null) {
            limitedLiveLog.addChangeListener(new LimitedLiveLog.ChangeListener(){

                public void onChanged(@Nonnull LimitedLiveLog source, @Nonnull String addedText) {
                    ESpecLogItem.this.logByteSize.setValue((Number)source.getReceivedSize());
                }

                public void onEndReached(@Nonnull LimitedLiveLog source) {
                    ESpecLogItem.this.logByteSize.setValue((Number)source.getReceivedSize());
                }
            });
        }
    }

    public ESpecLogItem(long id, @Nonnull String text, @Nonnull TaskStatusIndicator.Status status, @Nullable UploadLikeSpec spec) {
        this(id, text, status, (ESpecStep)spec, null, null);
    }

    public ESpecLogItem(long id, @Nonnull String text, @Nullable UploadLikeSpec spec) {
        this(id, text, TaskStatusIndicator.Status.INACTIVE, (ESpecStep)spec, null, null);
    }

    public ESpecLogItem(long id, @Nonnull String text) {
        this(id, text, TaskStatusIndicator.Status.INACTIVE, null, null, null);
    }

    public ESpecLogItem(long id) {
        this(id, "");
    }

    public void update(@Nonnull ESpecLogItem eSpecLogItem) {
        this.status.setValue((Object)eSpecLogItem.getStatus());
        this.text.setValue(eSpecLogItem.getText());
        this.statusText.setValue(eSpecLogItem.getStatusText());
        assert (this.especStep == eSpecLogItem.especStep);
        assert (this.id == eSpecLogItem.id);
    }

    public long getId() {
        return this.id;
    }

    public TaskStatusIndicator.Status getStatus() {
        return (TaskStatusIndicator.Status)((Object)this.status.get());
    }

    public ObjectProperty<TaskStatusIndicator.Status> statusProperty() {
        return this.status;
    }

    public String getText() {
        return (String)this.text.get();
    }

    public StringProperty textProperty() {
        return this.text;
    }

    public void setStatus(TaskStatusIndicator.Status status) {
        this.status.set((Object)status);
    }

    public void setText(String text) {
        this.text.set((Object)text);
    }

    public String getStatusText() {
        return (String)this.statusText.get();
    }

    public StringProperty statusTextProperty() {
        return this.statusText;
    }

    public void setStatusText(String statusText) {
        this.statusText.set((Object)statusText);
    }

    @Nullable
    public ESpecStep getEspecStep() {
        return this.especStep;
    }

    public ESpecStateItem getESpecStateItem() {
        return (ESpecStateItem)this.eSpecStateItem.get();
    }

    public ObjectProperty<ESpecStateItem> eSpecStateItemProperty() {
        return this.eSpecStateItem;
    }

    public void setESpecStateItem(ESpecStateItem eSpecStateItem) {
        this.eSpecStateItem.set((Object)eSpecStateItem);
    }

    public int getLogByteSize() {
        return this.logByteSize.get();
    }

    public IntegerProperty logByteSizeProperty() {
        return this.logByteSize;
    }

    @Nullable
    public UploadProgressTracker getUploadProgressTracker() {
        return this.uploadProgressTracker;
    }

    @Nullable
    public LimitedLiveLog getLimitedLiveLog() {
        return this.limitedLiveLog;
    }

    public double getProgress() {
        return this.progress.get();
    }

    public DoubleProperty progressProperty() {
        return this.progress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ESpecLogItem that = (ESpecLogItem)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public int compareTo(@NotNull ESpecLogItem o) {
        return Long.compare(this.id, o.id);
    }
}

