/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.espec.model;

import be.iminds.ilabt.jfed.espec.model.AnsiblePlaybookSpec;
import be.iminds.ilabt.jfed.espec.model.DirSpec;
import be.iminds.ilabt.jfed.espec.model.ESpecStep;
import be.iminds.ilabt.jfed.espec.model.ExecuteSpec;
import be.iminds.ilabt.jfed.espec.model.FileSource;
import be.iminds.ilabt.jfed.espec.model.RspecSpec;
import be.iminds.ilabt.jfed.espec.model.UploadLikeSpec;
import be.iminds.ilabt.jfed.espec.util.ESpecLogListener;
import be.iminds.ilabt.jfed.espec.util.ESpecLogger;
import be.iminds.ilabt.jfed.espec.util.LimitedLiveLog;
import be.iminds.ilabt.jfed.espec.util.UploadProgressTracker;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.experimenter_gui.slice.espec.model.ESpecLogItem;
import be.iminds.ilabt.jfed.experimenter_gui.slice.espec.model.ESpecStateItem;
import be.iminds.ilabt.jfed.experimenter_gui.ui.status.TaskStatusIndicator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESpecLogModel
implements ESpecLogListener {
    private static final Logger LOG = LoggerFactory.getLogger(ESpecLogModel.class);
    public static final String AQUIRE_RESOURCES_STEP_ID = "Acquire Resources";
    public static final String SETUP_SOFTWARE_STEP_ID = ExperimentState.SETUP_SOFTWARE.name();
    private final Map<ESpecStateId, ESpecStateItem> internalESpecStateItems = new ConcurrentHashMap<ESpecStateId, ESpecStateItem>();
    private final Map<Long, ESpecLogItem> eSpecLogItemsById;
    private final ObservableList<ESpecLogItem> eSpecLogItems;
    private final ObservableList<ESpecStateItem> eSpecStateItems;
    private final ObjectProperty<ESpecStateItem> selectedESpecStateItem;
    @Nonnull
    private final ESpecLogger logger;
    @Nonnull
    private final Experiment experiment;

    public ESpecLogModel(@Nonnull Experiment experiment) {
        this.logger = experiment.getExperimentSpecificationLogger();
        this.experiment = experiment;
        this.eSpecLogItemsById = new TreeMap<Long, ESpecLogItem>();
        this.eSpecLogItems = FXCollections.observableArrayList();
        this.eSpecStateItems = FXCollections.observableArrayList();
        this.selectedESpecStateItem = new SimpleObjectProperty();
        experiment.addESpecLogListener((ESpecLogListener)this);
        experiment.experimentStateProperty().addListener((observableValue, oldVal, newVal) -> {
            boolean success;
            this.setPreviousRunningToSuccess((ExperimentState)newVal, null);
            boolean bl = success = !ESpecLogModel.isFailingState(newVal);
            ESpecStateItem.ESpecStateStatus targetState = success ? (newVal.isActiveState() && newVal != ExperimentState.READY ? ESpecStateItem.ESpecStateStatus.RUNNING : ESpecStateItem.ESpecStateStatus.SUCCESS) : ESpecStateItem.ESpecStateStatus.FAILURE;
            ESpecStateItem cur = this.getState((ExperimentState)newVal, null, targetState);
            cur.setStatus(targetState);
            this.addLog().setText("Reached State " + newVal.name()).setFinalStatus(success).setESpecStateItem(cur).addOrUpdate();
        });
        this.addInitialStates();
    }

    private void addInitialStates() {
        this.getState(ExperimentState.ALLOCATING, null, ESpecStateItem.ESpecStateStatus.FUTURE);
        this.getState(ExperimentState.PROVISIONING, null, ESpecStateItem.ESpecStateStatus.FUTURE);
        this.getState(ExperimentState.WAIT_FOR_READY, null, ESpecStateItem.ESpecStateStatus.FUTURE);
        this.getState(ExperimentState.TESTING_CONNECTIVITY, null, ESpecStateItem.ESpecStateStatus.FUTURE);
        this.getState(ExperimentState.SETUP_SOFTWARE, null, ESpecStateItem.ESpecStateStatus.FUTURE);
        this.getState(ExperimentState.SETUP_SOFTWARE, "Dir", ESpecStateItem.ESpecStateStatus.FUTURE);
        this.getState(ExperimentState.SETUP_SOFTWARE, "Upload", ESpecStateItem.ESpecStateStatus.FUTURE);
        this.getState(ExperimentState.SETUP_SOFTWARE, "Execute", ESpecStateItem.ESpecStateStatus.FUTURE);
        this.getState(ExperimentState.SETUP_SOFTWARE, "Ansible", ESpecStateItem.ESpecStateStatus.FUTURE);
        this.getState(ExperimentState.READY, null, ESpecStateItem.ESpecStateStatus.FUTURE);
    }

    private void dumpDebug() {
        LOG.debug("All states:");
        Set<Map.Entry<ESpecStateId, ESpecStateItem>> all = this.internalESpecStateItems.entrySet();
        for (Map.Entry<ESpecStateId, ESpecStateItem> e : all) {
            ESpecStateId id = e.getKey();
            ESpecStateItem item = e.getValue();
            LOG.debug("State: " + String.valueOf(id) + " -> " + item.getId() + "    children=" + item.getChildren().stream().map(ESpecStateItem::getId).collect(Collectors.joining(",")));
        }
    }

    @Nonnull
    private ESpecStateItem getState(@Nullable ExperimentState experimentState, @Nullable String especStepId, @Nonnull ESpecStateItem.ESpecStateStatus initialStatus) {
        ESpecStateId id = new ESpecStateId(experimentState, especStepId);
        return this.getState(id, initialStatus);
    }

    @Nonnull
    private ESpecStateItem getState(@Nonnull ESpecStateId id, @Nonnull ESpecStateItem.ESpecStateStatus initialStatus) {
        assert (!Objects.equals(id.getBaseId(), "ALLOCATING") || id.getSubId() != null);
        if (id.isChild()) {
            ESpecStateId parentId = id.getParentId();
            ESpecStateItem parent = this.getState(parentId, initialStatus);
            AtomicBoolean wasAdded = new AtomicBoolean(false);
            ESpecStateItem res = this.internalESpecStateItems.computeIfAbsent(id, key -> {
                ESpecStateItem toAdd = new ESpecStateItem(id.subId, initialStatus);
                wasAdded.set(true);
                return toAdd;
            });
            if (wasAdded.get()) {
                Platform.runLater(() -> parent.getChildren().add((Object)res));
            }
            return res;
        }
        AtomicBoolean wasAdded = new AtomicBoolean(false);
        ESpecStateItem res = this.internalESpecStateItems.computeIfAbsent(id, key -> {
            ESpecStateItem toAdd = new ESpecStateItem(id.baseId, initialStatus);
            wasAdded.set(true);
            return toAdd;
        });
        if (wasAdded.get()) {
            Platform.runLater(() -> this.eSpecStateItems.add((Object)res));
        }
        return res;
    }

    private void setPreviousRunningToSuccess(ExperimentState experimentState, String especStepId) {
        this.setPreviousRunningToSuccess(new ESpecStateId(experimentState, especStepId));
    }

    private void setPreviousRunningToSuccess(ESpecStateId id) {
        this.internalESpecStateItems.values().stream().filter(esi -> esi.getId() != id.baseId).filter(esi -> id.subId == null || esi.getId() != id.subId).filter(esi -> esi.getStatus() == ESpecStateItem.ESpecStateStatus.RUNNING).forEach(esi -> esi.setStatus(ESpecStateItem.ESpecStateStatus.SUCCESS));
    }

    private void setStatus(ExperimentState experimentState, String especStepId, ESpecStateItem.ESpecStateStatus newStatus) {
        ESpecStateId id = new ESpecStateId(experimentState, especStepId);
        this.setStatus(id, newStatus);
    }

    private void setStatus(ESpecStateId id, ESpecStateItem.ESpecStateStatus newStatus) {
        ESpecStateItem item = this.getState(id, newStatus);
        item.setStatus(newStatus);
    }

    public ObservableList<ESpecLogItem> getESpecLogItems() {
        return this.eSpecLogItems;
    }

    public ObservableList<ESpecStateItem> getESpecStateItems() {
        return this.eSpecStateItems;
    }

    @Nullable
    public ESpecStateItem getSelectedESpecStateItem() {
        return (ESpecStateItem)this.selectedESpecStateItem.get();
    }

    public ObjectProperty<ESpecStateItem> selectedESpecStateItemProperty() {
        return this.selectedESpecStateItem;
    }

    public void setSelectedESpecStateItem(@Nullable ESpecStateItem selectedESpecStateItem) {
        this.selectedESpecStateItem.set((Object)selectedESpecStateItem);
    }

    public void clearSelectedESpecStateItem() {
        this.selectedESpecStateItem.set(null);
    }

    public static boolean isFailingState(@Nonnull ExperimentState state) {
        return state == ExperimentState.FAILING || state == ExperimentState.FAILED || state == ExperimentState.UNKNOWN || state == ExperimentState.TIMEOUT_WAITING;
    }

    public static boolean isFailingState(@Nonnull String stateName) {
        return stateName.equalsIgnoreCase(ExperimentState.FAILING.name()) || stateName.equalsIgnoreCase(ExperimentState.FAILED.name()) || stateName.equalsIgnoreCase(ExperimentState.UNKNOWN.name()) || stateName.equalsIgnoreCase(ExperimentState.TIMEOUT_WAITING.name());
    }

    private void addOrUpdateESpecLogItem(@Nonnull ESpecLogItem eSpecLogItem) {
        ESpecLogItem existing = this.eSpecLogItemsById.get(eSpecLogItem.getId());
        if (existing != null) {
            existing.update(eSpecLogItem);
        } else {
            this.eSpecLogItemsById.put(eSpecLogItem.getId(), eSpecLogItem);
            this.eSpecLogItems.add((Object)eSpecLogItem);
            if (eSpecLogItem.getESpecStateItem() != null) {
                eSpecLogItem.getESpecStateItem().getLogItems().add((Object)eSpecLogItem);
            }
        }
    }

    private ESpecLogItemAdder addLog() {
        ESpecLogModel eSpecLogModel = this;
        return new ESpecLogItemAdder(eSpecLogModel.logger.getNextLogId());
    }

    private ESpecLogItemAdder addLog(long id) {
        return new ESpecLogItemAdder(id);
    }

    public void onPreFileLoad() {
    }

    public void onPostFileLoad(@Nonnull FileSource fileSource, boolean isFast, long byteSize, @Nonnull ESpecLogListener.ESpecStepStatus status) {
        String fileText = fileSource.getBasename();
        this.addLog().setText("File load \"" + fileText + "\"").setStatus(status).setCurrentBaseState().setIsMinor(!status.isFailure()).addOrUpdate();
    }

    public void onPostFileLoadAll(boolean success) {
        this.addLog().setText("All files loaded").setFinalStatus(success).setCurrentBaseState().addOrUpdate();
    }

    public void onPreRSpec() {
    }

    public void onRequestRSpecKnown(@Nonnull RspecSpec rspecSpec, @Nonnull String requestRspec) {
        this.addLog().setText("Request RSpec Available").setFinalStatus(true).setCurrentBaseState().setEspecStep((ESpecStep)rspecSpec).addOrUpdate();
    }

    public void onPostRSpec(@Nonnull RspecSpec rspec, @Nonnull ESpecLogListener.ESpecStepStatus status) {
        if (status.isFailure()) {
            this.addLog().setText("RSpec Provision").setStatus(status).setCurrentBaseState().setEspecStep((ESpecStep)rspec).addOrUpdate();
        }
    }

    public void onPostRspecAll(boolean success, @Nonnull List<String> allNodeClientIds) {
    }

    public void onPreDir() {
        this.setPreviousRunningToSuccess(ExperimentState.SETUP_SOFTWARE, "Dir");
        this.setStatus(ExperimentState.SETUP_SOFTWARE, "Dir", ESpecStateItem.ESpecStateStatus.RUNNING);
    }

    public void onPreDirNode(@Nonnull String nodeClientId) {
    }

    public void onPreDir(long logEventId, @Nonnull DirSpec dir, @Nonnull String fullPath, @Nonnull String nodeClientId) {
        this.addLog(logEventId).setText("Dir \"" + fullPath + "\" Creation at " + nodeClientId).setStatus(ESpecLogListener.ESpecStepStatus.Status.RUNNING).setESpecStepId("Dir").setEspecStep((ESpecStep)dir).addOrUpdate();
    }

    public void onPostDir(long logEventId, @Nonnull DirSpec dir, @Nonnull String fullPath, @Nonnull String nodeClientId, @Nonnull ESpecLogListener.ESpecStepStatus status) {
        this.addLog(logEventId).setText("Dir \"" + fullPath + "\" Creation at " + nodeClientId).setStatus(status).setESpecStepId("Dir").setEspecStep((ESpecStep)dir).addOrUpdate();
    }

    public void onPostDirNode(@Nonnull String nodeClientId, boolean success) {
        this.addLog().setText("Finished Dir Creations at " + nodeClientId).setFinalStatus(success).setESpecStepId("Dir").setIsMinor().addOrUpdate();
    }

    public void onPostDirAll(boolean success) {
        this.setStatus(ExperimentState.SETUP_SOFTWARE, "Dir", success ? ESpecStateItem.ESpecStateStatus.SUCCESS : ESpecStateItem.ESpecStateStatus.FAILURE);
        this.addLog().setText("Finished Dir Creations").setFinalStatus(success).setESpecStepId("Dir").addOrUpdate();
    }

    public void onPreUpload() {
        this.setPreviousRunningToSuccess(ExperimentState.SETUP_SOFTWARE, "Upload");
        this.setStatus(ExperimentState.SETUP_SOFTWARE, "Upload", ESpecStateItem.ESpecStateStatus.RUNNING);
    }

    public void onPreUploadNode(@Nonnull String nodeClientId) {
    }

    public void onPreUpload(long logEventId, @Nonnull UploadLikeSpec uploadSpec, @Nonnull String fullPath, @Nonnull String nodeClientId, @Nonnull UploadProgressTracker uploadProgressTracker) {
        String path = uploadSpec.getPath() == null ? fullPath : uploadSpec.getPath();
        this.addLog(logEventId).setText("Upload \"" + path + "\" at " + nodeClientId).setStatus(ESpecLogListener.ESpecStepStatus.Status.RUNNING).setESpecStepId("Upload").setUploadProgressTracker(uploadProgressTracker).setEspecStep((ESpecStep)uploadSpec).addOrUpdate();
    }

    public void onPostUpload(long logEventId, @Nonnull UploadLikeSpec uploadSpec, @Nonnull String fullPath, @Nonnull String nodeClientId, @Nonnull ESpecLogListener.ESpecStepStatus status) {
        String path = uploadSpec.getPath() == null ? fullPath : uploadSpec.getPath();
        this.addLog(logEventId).setText("Upload \"" + path + "\" at " + nodeClientId).setStatus(status).setESpecStepId("Upload").setEspecStep((ESpecStep)uploadSpec).addOrUpdate();
    }

    public void onPostUploadNode(@Nonnull String nodeClientId, boolean success) {
        this.addLog().setText("Finished Uploads at " + nodeClientId).setFinalStatus(success).setESpecStepId("Upload").setIsMinor().addOrUpdate();
    }

    public void onPostUploadAll(boolean success) {
        this.setStatus(ExperimentState.SETUP_SOFTWARE, "Upload", success ? ESpecStateItem.ESpecStateStatus.SUCCESS : ESpecStateItem.ESpecStateStatus.FAILURE);
        this.addLog().setText("Finished Uploads").setFinalStatus(success).setESpecStepId("Upload").addOrUpdate();
    }

    public void onPreExecute() {
        this.setPreviousRunningToSuccess(ExperimentState.SETUP_SOFTWARE, "Execute");
        this.setStatus(ExperimentState.SETUP_SOFTWARE, "Execute", ESpecStateItem.ESpecStateStatus.RUNNING);
    }

    public void onPreExecute(long logEventId, @Nonnull ExecuteSpec executeSpec, @Nonnull String fullExecutablePath, @Nullable String fullLogPath, @Nonnull String nodeClientId, @Nonnull LimitedLiveLog currentLog) {
        String path = executeSpec.getPath() == null ? fullExecutablePath : executeSpec.getPath();
        this.addLog(logEventId).setText("Executing \"" + path + "\" at " + nodeClientId).setStatus(ESpecLogListener.ESpecStepStatus.Status.RUNNING).setESpecStepId("Execute").setLimitedLiveLog(currentLog).setEspecStep((ESpecStep)executeSpec).addOrUpdate();
    }

    public void onPostExecute(long logEventId, @Nonnull ExecuteSpec executeSpec, @Nonnull String fullExecutablePath, @Nullable String fullLogPath, @Nonnull String nodeClientId, int exitStatus, @Nonnull ESpecLogListener.ESpecStepStatus status) {
        String path = executeSpec.getPath() == null ? fullExecutablePath : executeSpec.getPath();
        this.addLog(logEventId).setText("Execute \"" + path + "\" at " + nodeClientId).setStatus(status).setESpecStepId("Execute").setEspecStep((ESpecStep)executeSpec).addOrUpdate();
    }

    public void onPostExecuteStepAll(@Nonnull ExecuteSpec executeSpec, boolean success) {
    }

    public void onPostExecuteAll(boolean success) {
        this.setStatus(ExperimentState.SETUP_SOFTWARE, "Execute", success ? ESpecStateItem.ESpecStateStatus.SUCCESS : ESpecStateItem.ESpecStateStatus.FAILURE);
        this.addLog().setText("Finished Executes").setFinalStatus(success).setESpecStepId("Execute").addOrUpdate();
    }

    public void onPreAnsible() {
        this.setPreviousRunningToSuccess(ExperimentState.SETUP_SOFTWARE, "Ansible");
        this.setStatus(ExperimentState.SETUP_SOFTWARE, "Ansible", ESpecStateItem.ESpecStateStatus.RUNNING);
    }

    public void onPreAnsiblePlaybook(long logEventId, @Nonnull AnsiblePlaybookSpec ansiblePlaybookSpec, @Nonnull String fullPlaybookPath, @Nullable String fullLogPath, @Nonnull String nodeClientId, @Nonnull LimitedLiveLog currentLog) {
        this.addLog(logEventId).setText("Ansible Playbook \"" + fullPlaybookPath + "\" at " + nodeClientId).setStatus(ESpecLogListener.ESpecStepStatus.Status.RUNNING).setESpecStepId("Ansible").setLimitedLiveLog(currentLog).setEspecStep((ESpecStep)ansiblePlaybookSpec).addOrUpdate();
    }

    public void onPostAnsiblePlaybook(long logEventId, @Nonnull AnsiblePlaybookSpec ansiblePlaybookSpec, @Nonnull String fullPlaybookPath, @Nullable String fullLogPath, @Nonnull String nodeClientId, @Nonnull ESpecLogListener.ESpecStepStatus status) {
        this.addLog(logEventId).setText("Ansible Playbook \"" + fullPlaybookPath + "\" at " + nodeClientId).setStatus(status).setESpecStepId("Ansible").setEspecStep((ESpecStep)ansiblePlaybookSpec).addOrUpdate();
    }

    public void onPostAnsibleAll(boolean success) {
        this.setStatus(ExperimentState.SETUP_SOFTWARE, "Ansible", success ? ESpecStateItem.ESpecStateStatus.SUCCESS : ESpecStateItem.ESpecStateStatus.FAILURE);
        this.addLog().setText("Ansible Playbooks").setFinalStatus(success).setESpecStepId("Ansible").addOrUpdate();
    }

    private static final class ESpecStateId {
        @Nonnull
        private final String baseId;
        @Nullable
        private final String subId;

        public ESpecStateId(@Nullable ExperimentState experimentState, @Nullable String especStepId) {
            this.baseId = this.findBaseId(experimentState, especStepId);
            this.subId = this.findSubId(experimentState, especStepId);
            assert (!Objects.equals(this.baseId, "ALLOCATING") || this.subId != null);
        }

        private ESpecStateId(@Nonnull String baseId, @Nullable String subId) {
            assert (!Objects.equals(baseId, "ALLOCATING") || subId != null);
            this.baseId = baseId;
            this.subId = subId;
        }

        public ESpecStateId(@Nullable ExperimentState experimentState) {
            this(experimentState, null);
        }

        private static boolean partOfResourceSetup(@Nonnull ExperimentState experimentState) {
            return experimentState == ExperimentState.ALLOCATING || experimentState == ExperimentState.PROVISIONING || experimentState == ExperimentState.WAIT_FOR_READY || experimentState == ExperimentState.TESTING_CONNECTIVITY;
        }

        @Nonnull
        private String findBaseId(@Nullable ExperimentState experimentState, @Nullable String especStepId) {
            if (experimentState == null) {
                if (especStepId != null) {
                    return ExperimentState.SETUP_SOFTWARE.name();
                }
                throw new RuntimeException("Unknown state: experimentState=" + String.valueOf(experimentState) + " especStepId=" + especStepId);
            }
            if (ESpecStateId.partOfResourceSetup(experimentState)) {
                return ESpecLogModel.AQUIRE_RESOURCES_STEP_ID;
            }
            return experimentState.name();
        }

        @Nullable
        public String findSubId(@Nullable ExperimentState experimentState, @Nullable String especStepId) {
            if (experimentState == null) {
                if (especStepId != null) {
                    return especStepId;
                }
                throw new RuntimeException("Unknown state: experimentState=" + String.valueOf(experimentState) + " especStepId=" + especStepId);
            }
            if (ESpecStateId.partOfResourceSetup(experimentState)) {
                return experimentState.name();
            }
            return especStepId;
        }

        @Nonnull
        public String getBaseId() {
            return this.baseId;
        }

        @Nullable
        public String getSubId() {
            return this.subId;
        }

        public boolean isChild() {
            return this.subId != null;
        }

        @Nonnull
        public ESpecStateId getParentId() {
            return new ESpecStateId(this.baseId, null);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ESpecStateId that = (ESpecStateId)o;
            return Objects.equals(this.baseId, that.baseId) && Objects.equals(this.subId, that.subId);
        }

        public int hashCode() {
            return Objects.hash(this.baseId, this.subId);
        }

        public String toString() {
            return "ESpecStateId{" + this.baseId + ", " + this.subId + "}";
        }
    }

    private class ESpecLogItemAdder {
        private final long id;
        private String text;
        private TaskStatusIndicator.Status status;
        private ESpecStep especStep;
        private LimitedLiveLog limitedLiveLog;
        private UploadProgressTracker uploadProgressTracker;
        private ESpecStateItem eSpecStateItem;
        private ESpecStateId eSpecStateId;
        private boolean minor = false;

        public ESpecLogItemAdder(long id) {
            this.id = id;
        }

        ESpecLogItemAdder setText(@Nonnull String text) {
            this.text = text;
            return this;
        }

        ESpecLogItemAdder setStatus(@Nonnull TaskStatusIndicator.Status status) {
            this.status = status;
            return this;
        }

        ESpecLogItemAdder setFinalStatus(boolean success) {
            if (success) {
                this.setStatus(TaskStatusIndicator.Status.SUCCESS);
            } else {
                this.setStatus(TaskStatusIndicator.Status.FAILED);
            }
            return this;
        }

        ESpecLogItemAdder setStatus(ESpecLogListener.ESpecStepStatus.Status status) {
            switch (status) {
                case RUNNING: {
                    this.setStatus(TaskStatusIndicator.Status.BUSY);
                    break;
                }
                case SUCCESS: {
                    this.setStatus(TaskStatusIndicator.Status.SUCCESS);
                    break;
                }
                case FAILURE: {
                    this.setStatus(TaskStatusIndicator.Status.FAILED);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported status");
                }
            }
            return this;
        }

        ESpecLogItemAdder setStatus(@Nonnull ESpecLogListener.ESpecStepStatus status) {
            this.setStatus(status.getStatus());
            return this;
        }

        public ESpecLogItemAdder setESpecStateId(ExperimentState experimentState, String especStepId) {
            this.eSpecStateId = new ESpecStateId(experimentState, especStepId);
            return this;
        }

        public ESpecLogItemAdder setExperimentState(ExperimentState experimentState) {
            this.eSpecStateId = new ESpecStateId(experimentState, null);
            return this;
        }

        public ESpecLogItemAdder setESpecStepId(String especStepId) {
            this.eSpecStateId = new ESpecStateId(ExperimentState.SETUP_SOFTWARE, especStepId);
            return this;
        }

        public ESpecLogItemAdder setESpecStateId(ESpecStateId eSpecStateId) {
            this.eSpecStateId = eSpecStateId;
            return this;
        }

        ESpecLogItemAdder setESpecStateItem(ESpecStateItem eSpecStateItem) {
            this.eSpecStateItem = eSpecStateItem;
            return this;
        }

        ESpecLogItemAdder setCurrentBaseState() {
            this.eSpecStateId = new ESpecStateId(ESpecLogModel.this.experiment.getExperimentState(), null);
            return this;
        }

        ESpecLogItemAdder setIsMinor() {
            this.minor = true;
            return this;
        }

        ESpecLogItemAdder setIsMinor(boolean newMinor) {
            this.minor = newMinor;
            return this;
        }

        public ESpecLogItemAdder setEspecStep(ESpecStep especStep) {
            this.especStep = especStep;
            return this;
        }

        public ESpecLogItemAdder setLimitedLiveLog(LimitedLiveLog limitedLiveLog) {
            this.limitedLiveLog = limitedLiveLog;
            return this;
        }

        public ESpecLogItemAdder setUploadProgressTracker(UploadProgressTracker uploadProgressTracker) {
            this.uploadProgressTracker = uploadProgressTracker;
            return this;
        }

        public void addOrUpdate() {
            if (this.text == null) {
                throw new IllegalStateException("text should have been set");
            }
            if (this.status == null) {
                throw new IllegalStateException("status should have been set");
            }
            if (this.eSpecStateId == null && this.eSpecStateItem == null) {
                throw new IllegalStateException("eSpecStateId or eSpecStateItem should have been set");
            }
            ESpecLogItem res = new ESpecLogItem(this.id, this.text, this.status, this.especStep, this.uploadProgressTracker, this.limitedLiveLog);
            if (this.eSpecStateId != null) {
                this.eSpecStateItem = ESpecLogModel.this.getState(this.eSpecStateId, ESpecStateItem.ESpecStateStatus.RUNNING);
                if (this.eSpecStateItem == null) {
                    throw new IllegalStateException("Should never happen");
                }
            }
            if (this.eSpecStateItem != null) {
                res.setESpecStateItem(this.eSpecStateItem);
            }
            Platform.runLater(() -> ESpecLogModel.this.addOrUpdateESpecLogItem(res));
        }
    }
}

