/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.espec.model;

import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.experimenter_gui.slice.espec.model.ESpecLogItem;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.Event;
import javafx.event.EventHandler;
import javax.annotation.Nonnull;

public class ESpecStateItem {
    private final ObjectProperty<ESpecStateStatus> status = new SimpleObjectProperty();
    private final StringProperty id = new SimpleStringProperty();
    private final StringProperty humanName = new SimpleStringProperty();
    private final ObservableList<ESpecStateItem> children = FXCollections.observableArrayList();
    private final ObjectProperty<EventHandler<Event>> onDetailsView = new SimpleObjectProperty();
    private final ObservableList<ESpecLogItem> logItems = FXCollections.observableArrayList();

    public ESpecStateItem(String id, ESpecStateStatus status) {
        this.id.set((Object)id);
        this.humanName.set((Object)ESpecStateItem.findHumanName(id));
        this.status.set((Object)status);
    }

    @Nonnull
    private static String findHumanName(@Nonnull String id) {
        if (id.equalsIgnoreCase(ExperimentState.PENDING.name())) {
            return "Pending";
        }
        if (id.equalsIgnoreCase(ExperimentState.ALLOCATING.name())) {
            return "Allocating";
        }
        if (id.equalsIgnoreCase(ExperimentState.PROVISIONING.name())) {
            return "Provisioning";
        }
        if (id.equalsIgnoreCase(ExperimentState.WAIT_FOR_READY.name())) {
            return "Wait until ready";
        }
        if (id.equalsIgnoreCase(ExperimentState.TESTING_CONNECTIVITY.name())) {
            return "Testing Connectivity";
        }
        if (id.equalsIgnoreCase(ExperimentState.SETUP_SOFTWARE.name())) {
            return "Setup Experiment";
        }
        if (id.equalsIgnoreCase(ExperimentState.READY.name())) {
            return "Ready";
        }
        if (id.equalsIgnoreCase(ExperimentState.DELETING.name())) {
            return "Deleting";
        }
        if (id.equalsIgnoreCase(ExperimentState.EMPTY.name())) {
            return "Empty";
        }
        if (id.equalsIgnoreCase(ExperimentState.FAILING.name())) {
            return "Failing";
        }
        if (id.equalsIgnoreCase(ExperimentState.TIMEOUT_WAITING.name())) {
            return "Wait Timed Out";
        }
        if (id.equalsIgnoreCase(ExperimentState.UNKNOWN.name())) {
            return "Unknown";
        }
        if (id.equalsIgnoreCase(ExperimentState.FAILED.name())) {
            return "Failed";
        }
        if (id.equalsIgnoreCase(ExperimentState.FUTURE_RESERVATION.name())) {
            return "Future";
        }
        if (id.equalsIgnoreCase(ExperimentState.EXPIRED.name())) {
            return "Expired";
        }
        if (id.equalsIgnoreCase(ExperimentState.CREATED.name())) {
            return "Created";
        }
        if (id.equalsIgnoreCase(ExperimentState.RESTORING.name())) {
            return "Restoring";
        }
        if (id.equalsIgnoreCase(ExperimentState.RENEW_EXISTING.name())) {
            return "Renewing";
        }
        if (id.equalsIgnoreCase("Dir")) {
            return "Dir";
        }
        if (id.equalsIgnoreCase("Upload")) {
            return "Upload";
        }
        if (id.equalsIgnoreCase("Execute")) {
            return "Execute";
        }
        if (id.equalsIgnoreCase("Ansible")) {
            return "Ansible";
        }
        if (id.equalsIgnoreCase("Acquire Resources")) {
            return "Acquire Resources";
        }
        return id;
    }

    public ESpecStateItem(String name) {
        this(name, ESpecStateStatus.FUTURE);
    }

    public ESpecStateStatus getStatus() {
        return (ESpecStateStatus)((Object)this.status.get());
    }

    public ObjectProperty<ESpecStateStatus> statusProperty() {
        return this.status;
    }

    public void setStatus(ESpecStateStatus status) {
        this.status.set((Object)status);
    }

    public String getId() {
        return (String)this.id.get();
    }

    public StringProperty idProperty() {
        return this.id;
    }

    public void setId(String id) {
        this.id.set((Object)id);
    }

    public String getHumanName() {
        return (String)this.humanName.get();
    }

    public StringProperty humanNameProperty() {
        return this.humanName;
    }

    public void setHumanName(String humanName) {
        this.humanName.set((Object)humanName);
    }

    public ObservableList<ESpecStateItem> getChildren() {
        return this.children;
    }

    public EventHandler<Event> getOnDetailsView() {
        return (EventHandler)this.onDetailsView.get();
    }

    public ObjectProperty<EventHandler<Event>> onDetailsViewProperty() {
        return this.onDetailsView;
    }

    public void setOnDetailsView(EventHandler<Event> onDetailsView) {
        this.onDetailsView.set(onDetailsView);
    }

    public ObservableList<ESpecLogItem> getLogItems() {
        return this.logItems;
    }

    public static enum ESpecStateStatus {
        SUCCESS,
        FAILURE,
        RUNNING,
        FUTURE;

    }
}

