/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.espec.view;

import be.iminds.ilabt.jfed.espec.model.AnsiblePlaybookSpec;
import be.iminds.ilabt.jfed.espec.model.ESpecStep;
import be.iminds.ilabt.jfed.espec.model.ExecuteSpec;
import be.iminds.ilabt.jfed.experiment.ExperimentController;
import be.iminds.ilabt.jfed.experimenter_gui.slice.espec.model.ESpecLogItem;
import be.iminds.ilabt.jfed.experimenter_gui.slice.espec.model.ESpecLogModel;
import be.iminds.ilabt.jfed.experimenter_gui.slice.espec.model.ESpecStateItem;
import be.iminds.ilabt.jfed.experimenter_gui.slice.espec.view.LimitedLiveLogPanel;
import be.iminds.ilabt.jfed.experimenter_gui.ui.status.TaskStatusIndicator;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESpecLogList
extends ListView<ESpecLogItem> {
    private static final Logger LOG = LoggerFactory.getLogger(ESpecLogList.class);
    private final ExperimentController experimentController;

    public ESpecLogList(ExperimentController experimentController, ESpecLogModel eSpecLogModel) {
        this.experimentController = experimentController;
        this.setPrefHeight(100.0);
        this.setCellFactory(progressItemListView -> new ESpecViewItem());
        this.setItems(eSpecLogModel.getESpecLogItems());
        ListChangeListener showLastItem = c -> {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                this.scrollTo(this.getItems().size() - 1);
            }
        };
        this.getItems().addListener(showLastItem);
        eSpecLogModel.selectedESpecStateItemProperty().addListener((o, oldVal, newVal) -> {
            if (oldVal != newVal) {
                this.getItems().removeListener(showLastItem);
                if (newVal != null) {
                    this.setItems(newVal.getLogItems());
                } else {
                    this.setItems(eSpecLogModel.getESpecLogItems());
                }
                this.getItems().addListener(showLastItem);
                this.scrollTo(this.getItems().size() - 1);
            }
        });
    }

    private class ESpecViewItem
    extends ListCell<ESpecLogItem> {
        private final HBox hbox;
        private final TaskStatusIndicator taskStatusIndicator;
        private final Label textLabel;
        private final Label statusLabel;
        private final Label logDetailsLabel;
        private final ProgressBar uploadProgressBar;
        private final ContextMenu contextMenu = new ContextMenu();
        private final MenuItem rerunSingle = new MenuItem("Re-run this step, on all involved nodes");
        private final MenuItem rerunFrom = new MenuItem("Re-run from this step, on all involved nodes");
        private final MenuItem rerunAll = new MenuItem("Re-run all steps on all nodes");
        private final MenuItem rerunFromNext = new MenuItem("Re-run from next step, on all involved nodes");
        private final MenuItem rerunBefore = new MenuItem("Re-run up to and including this step, on all involved nodes");

        public ESpecViewItem() {
            this.rerunAll.setOnAction(ae -> ESpecLogList.this.experimentController.rerunESpec(null, null));
            this.contextMenu.getItems().setAll((Object[])new MenuItem[]{this.rerunSingle, this.rerunFrom, this.rerunBefore, this.rerunFromNext, this.rerunAll});
            this.hbox = new HBox();
            this.hbox.setSpacing(5.0);
            this.taskStatusIndicator = new TaskStatusIndicator();
            this.taskStatusIndicator.setPrefHeight(16.0);
            this.taskStatusIndicator.setPrefWidth(16.0);
            this.textLabel = new Label();
            this.statusLabel = new Label();
            this.statusLabel.setStyle("-fx-text-fill: darkgrey;");
            this.logDetailsLabel = new Label("");
            this.logDetailsLabel.setStyle("-fx-text-fill: darkgrey; -fx-font-scale: 0.75;");
            this.uploadProgressBar = new ProgressBar();
            this.hbox.getChildren().addAll((Object[])new Node[]{this.taskStatusIndicator, this.textLabel, this.statusLabel, this.logDetailsLabel, this.uploadProgressBar});
            this.logDetailsLabel.setVisible(false);
            this.uploadProgressBar.setVisible(false);
            this.logDetailsLabel.managedProperty().bind((ObservableValue)this.logDetailsLabel.visibleProperty());
            this.uploadProgressBar.managedProperty().bind((ObservableValue)this.uploadProgressBar.visibleProperty());
            this.setGraphic((Node)this.hbox);
        }

        private EventHandler<Event> createExecuteStepOnMouseClickedHandler(ESpecLogItem item) {
            return e -> {
                MouseEvent mouseEvent = (MouseEvent)e;
                if (e.getEventType() != MouseEvent.MOUSE_CLICKED) {
                    return;
                }
                if (mouseEvent.getButton() == MouseButton.PRIMARY) {
                    if (item.getLimitedLiveLog() != null) {
                        Dialog logDialog = LimitedLiveLogPanel.createAsDialog(e.getSource() instanceof Node ? (Node)e.getSource() : null, item.getLimitedLiveLog());
                        logDialog.show();
                    }
                } else if (mouseEvent.getButton() == MouseButton.SECONDARY) {
                    this.rerunSingle.setOnAction(ae -> ESpecLogList.this.experimentController.rerunESpec(item.getEspecStep(), item.getEspecStep()));
                    this.rerunFrom.setOnAction(ae -> ESpecLogList.this.experimentController.rerunESpec(item.getEspecStep(), null));
                    this.rerunAll.setOnAction(ae -> ESpecLogList.this.experimentController.rerunESpec(null, null));
                    this.rerunFromNext.setOnAction(ae -> {
                        List steps = ESpecLogList.this.experimentController.getExperiment().getExperimentSpecification().getExecutes();
                        LOG.info("Searching next ESpec step");
                        ESpecStep nextStep = null;
                        for (int i = 0; i < steps.size(); ++i) {
                            ESpecStep curStep = (ESpecStep)steps.get(i);
                            if (curStep != item.getEspecStep()) continue;
                            if (i + 1 < steps.size()) {
                                nextStep = (ESpecStep)steps.get(i + 1);
                                break;
                            }
                            LOG.info("Selected ESpec step was the last step");
                            break;
                        }
                        if (nextStep != null) {
                            LOG.info("Running from next ESpec step");
                            ESpecLogList.this.experimentController.rerunESpec(nextStep, null);
                        } else {
                            LOG.info("Did not find next ESpec step to run");
                        }
                    });
                    this.rerunBefore.setOnAction(ae -> ESpecLogList.this.experimentController.rerunESpec(null, item.getEspecStep()));
                    this.contextMenu.getItems().setAll((Object[])new MenuItem[]{this.rerunSingle, this.rerunFrom, this.rerunFromNext, this.rerunBefore, this.rerunAll});
                    this.contextMenu.show((Node)this, mouseEvent.getScreenX(), mouseEvent.getScreenY());
                }
            };
        }

        private EventHandler<Event> createNonExecuteStepOnMouseClickedHandler(ESpecLogItem item) {
            return e -> {
                MouseEvent mouseEvent = (MouseEvent)e;
                if (e.getEventType() != MouseEvent.MOUSE_CLICKED) {
                    return;
                }
                if (mouseEvent.getButton() == MouseButton.SECONDARY) {
                    this.contextMenu.getItems().setAll((Object[])new MenuItem[]{this.rerunAll});
                    this.contextMenu.show((Node)this, mouseEvent.getScreenX(), mouseEvent.getScreenY());
                }
            };
        }

        protected void updateItem(ESpecLogItem item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.logDetailsLabel.visibleProperty().unbind();
            this.uploadProgressBar.visibleProperty().unbind();
            if (!empty) {
                this.textLabel.tooltipProperty().bind((ObservableValue)new TooltipBinding(item.eSpecStateItemProperty()));
                this.textLabel.textProperty().bind((ObservableValue)item.textProperty());
                this.statusLabel.textProperty().bind((ObservableValue)item.statusTextProperty());
                this.taskStatusIndicator.statusProperty().bind(item.statusProperty());
                this.taskStatusIndicator.setVisible(true);
                this.logDetailsLabel.visibleProperty().bind((ObservableValue)item.logByteSizeProperty().greaterThan(0));
                this.logDetailsLabel.textProperty().bind((ObservableValue)item.logByteSizeProperty().asString("(log size = %d bytes)"));
                this.uploadProgressBar.progressProperty().bind((ObservableValue)item.progressProperty());
                this.uploadProgressBar.visibleProperty().bind((ObservableValue)item.progressProperty().greaterThan(0.0));
                this.setOnMouseEntered(mouseEvent -> {
                    if (item.getEspecStep() instanceof ExecuteSpec || item.getEspecStep() instanceof AnsiblePlaybookSpec) {
                        this.setOnMouseClicked(this.createExecuteStepOnMouseClickedHandler(item));
                        this.setCursor(Cursor.HAND);
                    } else {
                        this.setOnMouseClicked(this.createNonExecuteStepOnMouseClickedHandler(item));
                        this.setCursor(null);
                    }
                });
            } else {
                this.textLabel.textProperty().unbind();
                this.textLabel.setText("");
                this.statusLabel.textProperty().unbind();
                this.statusLabel.setText("");
                this.taskStatusIndicator.setVisible(false);
                this.setOnMouseClicked(null);
                this.setCursor(null);
                this.logDetailsLabel.setVisible(false);
                this.uploadProgressBar.setVisible(false);
            }
        }
    }

    private static class TooltipBinding
    extends ObjectBinding<Tooltip> {
        @Nonnull
        private final ObjectProperty<ESpecStateItem> item;

        public TooltipBinding(@Nonnull ObjectProperty<ESpecStateItem> item) {
            this.bind(new Observable[]{item});
            this.item = item;
        }

        protected Tooltip computeValue() {
            if (this.item.get() != null) {
                return new Tooltip("Occured during state " + ((ESpecStateItem)this.item.get()).getHumanName());
            }
            return new Tooltip("Occured during null state ");
        }
    }

    private static class TooltipStringBinding
    extends ObjectBinding<Tooltip> {
        @Nonnull
        private final StringProperty text;

        public TooltipStringBinding(@Nonnull StringProperty text) {
            this.bind(new Observable[]{text});
            this.text = text;
        }

        protected Tooltip computeValue() {
            return new Tooltip((String)this.text.get());
        }
    }
}

