/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.espec.view;

import be.iminds.ilabt.jfed.experimenter_gui.slice.espec.model.ESpecStateItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ESpecStateButton
extends VBox {
    private final ESpecStateItem eSpecStateItem;
    private final Button mainButton;
    private final HBox extraButtonsBox;
    @Nullable
    private ClickedHandler onClickedHandler;

    public ESpecStateButton(@Nonnull ESpecStateItem eSpecStateItem) {
        this.eSpecStateItem = eSpecStateItem;
        this.mainButton = this.createBaseButton(eSpecStateItem);
        this.mainButton.getStyleClass().add((Object)(eSpecStateItem.getChildren().isEmpty() ? "without-substatus" : "with-substatus"));
        this.extraButtonsBox = new HBox();
        this.extraButtonsBox.setMaxWidth(Double.MAX_VALUE);
        VBox.setVgrow((Node)this.mainButton, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.extraButtonsBox, (Priority)Priority.ALWAYS);
        this.getChildren().addAll((Object[])new Node[]{this.mainButton, this.extraButtonsBox});
        eSpecStateItem.getChildren().addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                for (ESpecStateItem i : c.getAddedSubList()) {
                    this.addSubButton(i);
                    if (eSpecStateItem.getChildren().isEmpty() || !this.mainButton.getStyleClass().contains((Object)"without-substatus")) continue;
                    this.mainButton.getStyleClass().remove((Object)"without-substatus");
                    this.mainButton.getStyleClass().add((Object)"with-substatus");
                }
            }
        });
        for (ESpecStateItem child : eSpecStateItem.getChildren()) {
            this.addSubButton(child);
        }
    }

    public void setOnClickedHandler(@Nullable ClickedHandler onClickedHandler) {
        this.onClickedHandler = onClickedHandler;
    }

    public void fireOnClickedHandler(@Nonnull ESpecStateItem eSpecStateItem) {
        if (this.onClickedHandler != null) {
            this.onClickedHandler.onStateClicked(eSpecStateItem);
        }
    }

    public Button createBaseButton(ESpecStateItem eSpecStateItem) {
        Button res = new Button();
        res.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("espec-state-item.css").toExternalForm());
        res.getStyleClass().addAll((Object[])new String[]{"especState"});
        res.textProperty().bind((ObservableValue)eSpecStateItem.humanNameProperty());
        eSpecStateItem.statusProperty().addListener((o, oldVal, newVal) -> Platform.runLater(() -> this.updateStatus((ESpecStateItem.ESpecStateStatus)((Object)newVal), (Control)res)));
        this.updateStatus(eSpecStateItem.getStatus(), (Control)res);
        res.setMaxWidth(Double.MAX_VALUE);
        res.setOnAction(ae -> this.fireOnClickedHandler(eSpecStateItem));
        return res;
    }

    public void addSubButton(ESpecStateItem eSpecStateItem) {
        Button subButton = this.createBaseButton(eSpecStateItem);
        subButton.getStyleClass().add((Object)"with-substatus");
        this.extraButtonsBox.getChildren().add((Object)subButton);
    }

    public void updateStatus(ESpecStateItem.ESpecStateStatus status, Control target) {
        ArrayList<String> oldStyleClasses = new ArrayList<String>(Arrays.asList("future", "running", "fail", "success"));
        ArrayList<String> newStyleClasses = new ArrayList<String>();
        switch (status) {
            case FAILURE: {
                oldStyleClasses.remove("fail");
                newStyleClasses.add("fail");
                break;
            }
            case FUTURE: {
                oldStyleClasses.remove("future");
                newStyleClasses.add("future");
                break;
            }
            case SUCCESS: {
                oldStyleClasses.remove("success");
                newStyleClasses.add("success");
                break;
            }
            case RUNNING: {
                oldStyleClasses.remove("running");
                newStyleClasses.add("running");
            }
        }
        target.getStyleClass().removeAll(oldStyleClasses);
        newStyleClasses.removeAll((Collection<?>)target.getStyleClass());
        target.getStyleClass().addAll(newStyleClasses);
    }

    public static interface ClickedHandler {
        public void onStateClicked(ESpecStateItem var1);
    }
}

