/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.espec.view;

import be.iminds.ilabt.jfed.experimenter_gui.slice.espec.model.ESpecLogModel;
import be.iminds.ilabt.jfed.experimenter_gui.slice.espec.model.ESpecStateItem;
import be.iminds.ilabt.jfed.experimenter_gui.slice.espec.view.ESpecStateButton;
import java.util.ArrayList;
import java.util.Collection;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javax.annotation.Nonnull;

public class ESpecStateList
extends ScrollPane {
    private final Pane contentPane;
    private final ESpecLogModel eSpecLogModel;

    public ESpecStateList(ESpecLogModel eSpecLogModel) {
        this.eSpecLogModel = eSpecLogModel;
        this.contentPane = new HBox();
        this.contentPane.setMinHeight(60.0);
        this.contentPane.setPrefHeight(60.0);
        this.contentPane.setMaxHeight(60.0);
        this.setContent((Node)this.contentPane);
        this.setMinHeight(60.0);
        this.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.setHbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        Platform.runLater(() -> {
            eSpecLogModel.getESpecStateItems().addListener(c -> {
                while (c.next()) {
                    if (!c.wasAdded()) continue;
                    for (ESpecStateItem i : c.getAddedSubList()) {
                        this.addESpecStateItem(i);
                    }
                }
            });
            ArrayList<ESpecStateItem> origItems = new ArrayList<ESpecStateItem>((Collection<ESpecStateItem>)eSpecLogModel.getESpecStateItems());
            for (ESpecStateItem oi : origItems) {
                this.addESpecStateItem(oi);
            }
        });
    }

    public void addESpecStateItem(@Nonnull ESpecStateItem eSpecStateItem) {
        Platform.runLater(() -> {
            ESpecStateButton button = new ESpecStateButton(eSpecStateItem);
            button.setOnClickedHandler(clickedESpecStateItem -> this.eSpecLogModel.setSelectedESpecStateItem(clickedESpecStateItem));
            this.contentPane.getChildren().add((Object)button);
        });
    }
}

