/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.espec.view;

import be.iminds.ilabt.jfed.espec.util.LimitedLiveLog;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextArea;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.controlsfx.glyphfont.FontAwesome;

public class LimitedLiveLogPanel
extends VBox
implements LimitedLiveLog.ChangeListener {
    @Nonnull
    private final LimitedLiveLog liveLog;
    @Nonnull
    private final TextArea textArea;
    @Nonnull
    private final ProgressIndicator progress;

    public LimitedLiveLogPanel(@Nonnull LimitedLiveLog liveLog) {
        this.liveLog = liveLog;
        this.textArea = new TextArea("Initialising log view...");
        this.progress = new ProgressIndicator(-1.0);
        liveLog.addChangeListener((LimitedLiveLog.ChangeListener)this);
        VBox.setVgrow((Node)this.textArea, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.progress, (Priority)Priority.NEVER);
        this.getChildren().addAll((Object[])new Node[]{this.textArea, this.progress});
        this.onChanged(liveLog, "");
    }

    public void onChanged(@Nonnull LimitedLiveLog source, @Nonnull String addedText) {
        assert (source.getText() != null);
        Platform.runLater(() -> {
            double scrollTop = this.textArea.getScrollTop();
            this.textArea.setText(source.getText());
            this.textArea.setScrollTop(scrollTop);
            this.progress.setVisible(!source.isEndReached());
        });
    }

    public void onEndReached(@Nonnull LimitedLiveLog source) {
        this.onChanged(source, "");
    }

    public static Dialog createAsDialog(@Nullable Node owner, @Nonnull LimitedLiveLog liveLog) {
        Dialog dialog = new Dialog();
        DialogPane dialogPane = new DialogPane();
        dialogPane.setContent((Node)new LimitedLiveLogPanel(liveLog));
        dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.CLOSE});
        dialogPane.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.FILE_TEXT, (Color)Color.NAVY));
        if (owner != null && owner.getScene() != null) {
            dialog.initOwner(owner.getScene().getWindow());
        }
        dialog.setTitle("Log");
        dialog.setDialogPane(dialogPane);
        dialog.setResizable(true);
        return dialog;
    }
}

