/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.jobs;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experimenter_gui.slice.jobs.QoeJob;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.TestConnectivityJob;
import be.iminds.ilabt.jfed.highlevel.jobs.TestLinksJob;
import be.iminds.ilabt.jfed.highlevel.jobs.states.JobStateFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.ProxyServiceUtil;
import be.iminds.ilabt.jfed.highlevel.util.ProxySocketFactoryProvider;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.preferences.ProxyPreferencesManager;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;

@Singleton
public class ExperimenterJobFactory {
    @Nonnull
    private final Provider<HighLevelTaskFactory> hltfProvider;
    @Nonnull
    private final Provider<TaskThread> ttProvider;
    @Nonnull
    private final Provider<GeniUserProvider> geniUserProviderProvider;
    @Nonnull
    private final Provider<JFedHLPreferences> jFedPreferencesProvider;
    @Nonnull
    private final Provider<ProxyPreferencesManager> proxyPreferencesManagerProvider;
    @Nonnull
    private final Provider<ProxyServiceUtil> proxyServiceUtilProvider;
    @Nonnull
    private final JobStateFactory jobStateFactory;
    @Nonnull
    private final ProxySocketFactoryProvider proxySocketFactoryProvider;

    @Inject
    public ExperimenterJobFactory(@Nonnull Provider<HighLevelTaskFactory> hltfProvider, @Nonnull Provider<TaskThread> ttProvider, @Nonnull Provider<GeniUserProvider> geniUserProviderProvider, @Nonnull Provider<JFedHLPreferences> jFedPreferencesProvider, @Nonnull Provider<ProxyPreferencesManager> proxyPreferencesManagerProvider, @Nonnull Provider<ProxyServiceUtil> proxyServiceUtilProvider, @Nonnull JobStateFactory jobStateFactory, @Nonnull ProxySocketFactoryProvider proxySocketFactoryProvider) {
        this.hltfProvider = hltfProvider;
        this.ttProvider = ttProvider;
        this.geniUserProviderProvider = geniUserProviderProvider;
        this.jFedPreferencesProvider = jFedPreferencesProvider;
        this.proxyPreferencesManagerProvider = proxyPreferencesManagerProvider;
        this.proxyServiceUtilProvider = proxyServiceUtilProvider;
        this.jobStateFactory = jobStateFactory;
        this.proxySocketFactoryProvider = proxySocketFactoryProvider;
    }

    public QoeJob createQoeJob(Experiment experiment, Collection<SfaExperimentPart> experimentParts) {
        return new QoeJob(experiment, experimentParts, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get());
    }

    @Nonnull
    public TestConnectivityJob createTestConnectivityJob(@Nonnull Experiment experiment) {
        return new TestConnectivityJob(experiment, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (GeniUserProvider)this.geniUserProviderProvider.get(), (JFedPreferences)this.jFedPreferencesProvider.get(), (ProxyPreferencesManager)this.proxyPreferencesManagerProvider.get(), (ProxyServiceUtil)this.proxyServiceUtilProvider.get());
    }

    @Nonnull
    public TestLinksJob createTestLinksJob(@Nonnull Experiment experiment) {
        return new TestLinksJob(experiment, (HighLevelTaskFactory)this.hltfProvider.get(), (TaskThread)this.ttProvider.get(), (GeniUserProvider)this.geniUserProviderProvider.get(), (JFedPreferences)this.jFedPreferencesProvider.get(), (ProxyPreferencesManager)this.proxyPreferencesManagerProvider.get(), (ProxyServiceUtil)this.proxyServiceUtilProvider.get(), this.jobStateFactory, this.proxySocketFactoryProvider);
    }
}

