/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.jobs;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.experimenter_gui.slice.QoeDialog;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.AbstractJob;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.MultipleCallState;
import be.iminds.ilabt.jfed.highlevel.jobs.SingleCallState;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.ListPendingReputationQuestionnairesTask;
import be.iminds.ilabt.jfed.highlevel.tasks.RegisterReputationTask;
import be.iminds.ilabt.jfed.highlevel.util.FXPlatformUtil;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class QoeJob
extends AbstractJob<Void> {
    private final Collection<SfaExperimentPart> experimentParts;

    QoeJob(Experiment experiment, Collection<SfaExperimentPart> experimentParts, HighLevelTaskFactory hltf, TaskThread tt) {
        super("Registering experiment to reputation service", experiment, hltf, tt);
        this.experimentParts = experimentParts;
    }

    public Void execute() throws Exception {
        CheckForQuestionnairesState checkForQuestionnairesState = new CheckForQuestionnairesState();
        this.setAndRunState((State)checkForQuestionnairesState);
        if (((ListPendingReputationQuestionnairesTask)checkForQuestionnairesState.getTask()).getPendingQuestionnaires() == null || ((ListPendingReputationQuestionnairesTask)checkForQuestionnairesState.getTask()).getPendingQuestionnaires().isEmpty()) {
            this.updateMessage("No questionnaires available");
            return null;
        }
        AskUserForQOEState askUserForQOEState = new AskUserForQOEState();
        this.setAndRunState(askUserForQOEState);
        if (askUserForQOEState.getStatus() != ExperimentTaskStatus.SUCCESS) {
            this.updateMessage("User cancelled feedback dialog");
            return null;
        }
        this.setAndRunState((State)new SubmitQoeQuestionnaires(askUserForQOEState.getReplies()));
        return null;
    }

    private final class CheckForQuestionnairesState
    extends SingleCallState<ListPendingReputationQuestionnairesTask> {
        protected CheckForQuestionnairesState() {
            super("Check pending QoE questionnaires", (Task)QoeJob.this.hltf.listPendingReputationQuestionnaires(QoeJob.this.experiment.getSliceOrNull()));
        }
    }

    private final class AskUserForQOEState
    extends State {
        private List<QoeDialog.QoeReply> replies;

        protected AskUserForQOEState() {
            super("Asking user for Quality of Experience scores");
            this.replies = null;
        }

        @Nonnull
        protected ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
            this.replies = (List)FXPlatformUtil.runAndWait(() -> {
                QoeDialog dialog = new QoeDialog(QoeJob.this.experiment, QoeJob.this.experimentParts);
                return dialog.showAndWait().orElse(null);
            });
            return this.replies != null ? ExperimentTaskStatus.SUCCESS : ExperimentTaskStatus.FAILED;
        }

        public List<QoeDialog.QoeReply> getReplies() {
            return this.replies;
        }
    }

    private final class SubmitQoeQuestionnaires
    extends MultipleCallState<RegisterReputationTask> {
        private final List<QoeDialog.QoeReply> replies;

        public SubmitQoeQuestionnaires(List<QoeDialog.QoeReply> replies) {
            super("Submitting QoE questionnaires to reputation service", (AbstractJob)QoeJob.this);
            this.replies = replies;
        }

        public Collection<RegisterReputationTask> getTasks() {
            return this.replies.stream().map(reply -> QoeJob.this.hltf.registerReputation(QoeJob.this.experiment.getSliceOrNull(), reply.getExperimentPart().getSlivers().stream().map(Sliver::getUrn).collect(Collectors.toList()), reply.getOverallScore(), reply.getQualityScore(), reply.getAvailabilityScore())).collect(Collectors.toList());
        }
    }
}

