/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.progress;

import be.iminds.ilabt.jfed.experimenter_gui.slice.progress.ProgressItem;
import be.iminds.ilabt.jfed.experimenter_gui.ui.status.TaskStatusIndicator;
import javafx.beans.value.ObservableValue;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.layout.HBox;

public class ProgressView
extends ListView<ProgressItem> {
    public ProgressView() {
        this.setPrefHeight(100.0);
        this.setCellFactory(progressItemListView -> new ProgressViewItem());
        this.getItems().addListener(c -> {
            while (c.next()) {
                if (!c.wasAdded()) continue;
                this.scrollTo(this.getItems().size() - 1);
            }
        });
    }

    public void registerProgressViewItem(ProgressItem progressItem) {
        this.getItems().add((Object)progressItem);
    }

    private static class ProgressViewItem
    extends ListCell<ProgressItem> {
        private final HBox hbox = new HBox();
        private final TaskStatusIndicator taskStatusIndicator;
        private final Label textLabel;
        private final Label statusLabel;

        public ProgressViewItem() {
            this.hbox.setSpacing(5.0);
            this.taskStatusIndicator = new TaskStatusIndicator();
            this.taskStatusIndicator.setPrefHeight(16.0);
            this.taskStatusIndicator.setPrefWidth(16.0);
            this.textLabel = new Label();
            this.statusLabel = new Label();
            this.statusLabel.setStyle("-fx-text-fill: darkgrey;");
            this.hbox.getChildren().addAll((Object[])new Node[]{this.taskStatusIndicator, this.textLabel, this.statusLabel});
            this.setGraphic((Node)this.hbox);
        }

        protected void updateItem(ProgressItem progressItem, boolean empty) {
            super.updateItem((Object)progressItem, empty);
            if (!empty) {
                this.textLabel.textProperty().bind((ObservableValue)progressItem.textProperty());
                this.statusLabel.textProperty().bind((ObservableValue)progressItem.statusProperty());
                this.taskStatusIndicator.statusProperty().bind(progressItem.progressProperty());
                this.taskStatusIndicator.setVisible(true);
                this.setOnMouseEntered(mouseEvent -> {
                    if (progressItem.getOnDetailsView() != null) {
                        this.setOnMouseClicked(progressItem.getOnDetailsView());
                        this.setCursor(Cursor.HAND);
                    } else {
                        this.setOnMouseClicked(null);
                        this.setCursor(null);
                    }
                });
            } else {
                this.textLabel.textProperty().unbind();
                this.textLabel.setText("");
                this.statusLabel.textProperty().unbind();
                this.statusLabel.setText("");
                this.taskStatusIndicator.setVisible(false);
                this.setOnMouseClicked(null);
                this.setCursor(null);
            }
        }
    }
}

