/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.raw;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentChangeListener;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experimenter_gui.ui.code.XmlCodeView;
import be.iminds.ilabt.jfed.experimenter_gui.util.BrowserUtil;
import be.iminds.ilabt.jfed.experimenter_gui.util.FileUtils;
import be.iminds.ilabt.jfed.experimenter_gui.util.SSHTerminalUtil;
import be.iminds.ilabt.jfed.experimenter_gui.util.StringConverters;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Testbed;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.IPv4;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.StringRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXAddressPool;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.ui.javafx.FXMLUtil;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import be.iminds.ilabt.jfed.ui.javafx.dialogs.JFDialogs;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.library.XmlUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import javafx.util.StringConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.controlsfx.glyphfont.FontAwesome;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawSliceView
extends StackPane
implements ExperimentChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(RawSliceView.class);
    private static final String COMBINED_MANIFEST = "Combined Manifest RSpec";
    private final Experiment experiment;
    private final ManifestRspecSource canvasRspecSource;
    private final SSHTerminalUtil sshTerminalUtil;
    private final BrowserUtil browserUtil;
    private final JFedHLPreferences jFedPreferences;
    private final TestbedInfoSource testbedInfoSource;
    private final StringConverter<Object> manifestComboboxStringConverter = new StringConverter<Object>(){

        public String toString(Object object) {
            if (object == null) {
                return null;
            }
            if (object instanceof Testbed) {
                return ((Testbed)object).getLongName();
            }
            if (object instanceof Server) {
                return ((Server)object).getName();
            }
            if (object instanceof String) {
                return (String)object;
            }
            throw new UnsupportedOperationException("Only String and Server/Testbed are supported");
        }

        public Object fromString(String string) {
            throw new UnsupportedOperationException();
        }
    };
    @FXML
    private HBox initializingBox;
    @FXML
    private ScrollPane testbedsScrollPane;
    @FXML
    private VBox testbedsVBox;
    @FXML
    private TableView<Slice> sliceTableView;
    @FXML
    private TableColumn<Slice, String> sliceNameTableColumn;
    @FXML
    private TableColumn<Slice, String> sliceProjectTableColumn;
    @FXML
    private TableColumn<Slice, GeniUrn> sliceURNTableColumn;
    @FXML
    private TableColumn<Slice, Instant> sliceExpirationTimeTableColumn;
    @FXML
    private TableView<RawExperimentPart> sliversTableView;
    @FXML
    private TableColumn<RawExperimentPart, String> sliverTestbedTableColumn;
    @FXML
    private TableColumn<RawExperimentPart, String> sliverIdTableColumn;
    @FXML
    private TableColumn<RawExperimentPart, Instant> sliverExpirationTimeTableColumn;
    @FXML
    private TableColumn<RawExperimentPart, StatusDetails> sliverStatusTableColumn;
    @FXML
    private TableView<NodeWithLoginInfo> nodesTableView;
    @FXML
    private TableColumn<NodeWithLoginInfo, String> nodeNameTableColumn;
    @FXML
    private TableColumn<NodeWithLoginInfo, String> hostnameTableColumn;
    @FXML
    private TableColumn<NodeWithLoginInfo, Number> portTableColumn;
    @FXML
    private TableColumn<NodeWithLoginInfo, String> usernameTableColumn;
    @FXML
    private TableColumn<NodeWithLoginInfo, Boolean> loginTableColumn;
    @FXML
    private Label addressPoolsLabel;
    @FXML
    private TableView<AddressPoolIPv4> addressPoolsTableView;
    @FXML
    private TableColumn<AddressPoolIPv4, String> addressPoolClientIdTableColumn;
    @FXML
    private TableColumn<AddressPoolIPv4, String> addressPoolTestbedTableColumn;
    @FXML
    private TableColumn<AddressPoolIPv4, String> ipAddressTableColumn;
    @FXML
    private TableColumn<AddressPoolIPv4, String> netmaskTableColumn;
    @FXML
    private ComboBox<Object> manifestCombobox;
    @FXML
    private Label manifestLabel;
    @FXML
    private XmlCodeView manifestXmlView;
    private Slice slice = null;
    private final InvalidationListener manifestInvalidationListener = observable -> {
        if (Platform.isFxApplicationThread()) {
            this.updateView();
        } else {
            Platform.runLater(this::updateView);
        }
    };

    public RawSliceView(Experiment experiment, ManifestRspecSource canvasRspecSource, SSHTerminalUtil sshTerminalUtil, BrowserUtil browserUtil, JFedHLPreferences jFedPreferences, TestbedInfoSource testbedInfoSource) {
        this.experiment = experiment;
        this.canvasRspecSource = canvasRspecSource;
        this.sshTerminalUtil = sshTerminalUtil;
        this.browserUtil = browserUtil;
        this.jFedPreferences = jFedPreferences;
        this.testbedInfoSource = testbedInfoSource;
        FXMLUtil.injectFXML((Object)((Object)this));
        this.testbedsVBox.prefWidthProperty().bind((ObservableValue)this.testbedsScrollPane.widthProperty().subtract(15));
        this.sliceNameTableColumn.setCellValueFactory(t -> new ReadOnlyStringWrapper(((Slice)t.getValue()).getName()));
        this.sliceProjectTableColumn.setCellValueFactory(t -> new ReadOnlyStringWrapper(((Slice)t.getValue()).getSubAuthorityName()));
        this.sliceURNTableColumn.setCellValueFactory(t -> new ReadOnlyObjectWrapper((Object)((Slice)t.getValue()).getUrn()));
        this.sliceExpirationTimeTableColumn.setCellValueFactory(t -> ((Slice)t.getValue()).expirationDateProperty());
        this.sliceExpirationTimeTableColumn.setCellFactory(TextFieldTableCell.forTableColumn(StringConverters.INSTANT_STRING_CONVERTER));
        DoubleBinding sliceTableWidthLeft = this.sliceTableView.widthProperty().subtract(4);
        this.sliceNameTableColumn.prefWidthProperty().bind((ObservableValue)sliceTableWidthLeft.multiply(0.15));
        this.sliceProjectTableColumn.prefWidthProperty().bind((ObservableValue)sliceTableWidthLeft.multiply(0.15));
        this.sliceURNTableColumn.prefWidthProperty().bind((ObservableValue)sliceTableWidthLeft.multiply(0.5));
        this.sliceExpirationTimeTableColumn.prefWidthProperty().bind((ObservableValue)sliceTableWidthLeft.multiply(0.2));
        this.sliceTableView.setRowFactory(param -> {
            TableRow row = new TableRow();
            ContextMenu sliceUrnContextMenu = new ContextMenu();
            MenuItem copyUrnMenuItem = new MenuItem("Copy URN");
            copyUrnMenuItem.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.COPY));
            copyUrnMenuItem.setOnAction(event -> {
                Clipboard clipboard = Clipboard.getSystemClipboard();
                ClipboardContent content = new ClipboardContent();
                content.putString(this.slice.getUrnString());
                clipboard.setContent((Map)content);
            });
            sliceUrnContextMenu.getItems().add((Object)copyUrnMenuItem);
            row.setContextMenu(sliceUrnContextMenu);
            return row;
        });
        this.sliverTestbedTableColumn.setCellValueFactory(t -> new ReadOnlyStringWrapper(((RawExperimentPart)t.getValue()).getTestbed()));
        this.sliverIdTableColumn.setCellValueFactory(t -> new ReadOnlyStringWrapper(((RawExperimentPart)t.getValue()).getId()));
        this.sliverExpirationTimeTableColumn.setCellValueFactory(param -> ((RawExperimentPart)param.getValue()).expirationTimeProperty());
        this.sliverExpirationTimeTableColumn.setCellFactory(TextFieldTableCell.forTableColumn(StringConverters.INSTANT_STRING_CONVERTER));
        this.sliverStatusTableColumn.setCellValueFactory(param -> ((RawExperimentPart)param.getValue()).statusProperty());
        this.sliverStatusTableColumn.setCellFactory(sliverSliverStatusTableColumn -> new StatusTableCell());
        this.sliversTableView.setRowFactory(param -> {
            TableRow row = new TableRow();
            ContextMenu sliverUrnContextMenu = new ContextMenu();
            MenuItem copySliverUrnMenuItem = new MenuItem("Copy ID");
            copySliverUrnMenuItem.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.COPY));
            copySliverUrnMenuItem.setOnAction(event -> {
                Clipboard clipboard = Clipboard.getSystemClipboard();
                ClipboardContent content = new ClipboardContent();
                content.putString(((RawExperimentPart)row.getItem()).getId());
                clipboard.setContent((Map)content);
            });
            sliverUrnContextMenu.getItems().add((Object)copySliverUrnMenuItem);
            row.setContextMenu(sliverUrnContextMenu);
            return row;
        });
        DoubleBinding sliverTableWidthLeft = this.sliversTableView.widthProperty().subtract(4).subtract((ObservableNumberValue)this.sliverStatusTableColumn.widthProperty());
        this.sliverTestbedTableColumn.prefWidthProperty().bind((ObservableValue)sliverTableWidthLeft.multiply(0.25));
        this.sliverIdTableColumn.prefWidthProperty().bind((ObservableValue)sliverTableWidthLeft.multiply(0.5));
        this.sliverExpirationTimeTableColumn.prefWidthProperty().bind((ObservableValue)sliverTableWidthLeft.multiply(0.25));
        this.nodeNameTableColumn.setCellValueFactory(t -> new ReadOnlyStringWrapper(((NodeWithLoginInfo)t.getValue()).getId()));
        this.hostnameTableColumn.setCellValueFactory(t -> new ReadOnlyStringWrapper(((NodeWithLoginInfo)t.getValue()).getHostname()));
        this.portTableColumn.setCellValueFactory(t -> new ReadOnlyObjectWrapper((Object)((NodeWithLoginInfo)t.getValue()).getPort()));
        this.usernameTableColumn.setCellValueFactory(t -> new ReadOnlyStringWrapper(((NodeWithLoginInfo)t.getValue()).getUsername()));
        this.loginTableColumn.setCellValueFactory(p -> new SimpleBooleanProperty(((NodeWithLoginInfo)p.getValue()).getHostname() != null));
        this.loginTableColumn.setCellFactory(t -> new NodeWithLoginInfoButtonTableCell());
        this.nodesTableView.setRowFactory(param -> {
            TableRow row = new TableRow();
            ContextMenu loginContextManu = new ContextMenu();
            MenuItem copyLoginInfo = new MenuItem("Copy SSH login command");
            copyLoginInfo.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TERMINAL));
            copyLoginInfo.setOnAction(event -> {
                boolean success = false;
                if (row.getItem() instanceof RspecNodeWithLoginInfo) {
                    RspecNodeWithLoginInfo rspecNodeWithLoginInfo = (RspecNodeWithLoginInfo)row.getItem();
                    ClipboardContent content = new ClipboardContent();
                    if (rspecNodeWithLoginInfo.getLoginService() != null) {
                        BasicStringRspec.LoginService loginService = rspecNodeWithLoginInfo.getLoginService();
                        content.putString("ssh " + loginService.getUsername() + "@" + loginService.getHostname() + " -p " + loginService.getPort());
                        Clipboard.getSystemClipboard().setContent((Map)content);
                        success = true;
                    }
                }
                if (!success) {
                    new Alert(Alert.AlertType.ERROR, "No SSH info available.", new ButtonType[0]).showAndWait();
                }
            });
            loginContextManu.getItems().add((Object)copyLoginInfo);
            loginContextManu.getItems().add((Object)new SeparatorMenuItem());
            MenuItem copyHostnameMenuItem = new MenuItem("Copy hostname");
            copyHostnameMenuItem.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.COPY));
            copyHostnameMenuItem.setOnAction(event -> {
                if (((NodeWithLoginInfo)row.getItem()).getHostname() != null) {
                    ClipboardContent content = new ClipboardContent();
                    content.putString(((NodeWithLoginInfo)row.getItem()).getHostname());
                    Clipboard.getSystemClipboard().setContent((Map)content);
                } else {
                    new Alert(Alert.AlertType.ERROR, "No hostname available", new ButtonType[0]).showAndWait();
                }
            });
            loginContextManu.getItems().add((Object)copyHostnameMenuItem);
            MenuItem copyUsernameMenuItem = new MenuItem("Copy username");
            copyUsernameMenuItem.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.COPY));
            copyUsernameMenuItem.setOnAction(event -> {
                if (((NodeWithLoginInfo)row.getItem()).getUsername() != null) {
                    RspecNodeWithLoginInfo rspecNodeWithLoginInfo = (RspecNodeWithLoginInfo)row.getItem();
                    ClipboardContent content = new ClipboardContent();
                    content.putString(((NodeWithLoginInfo)row.getItem()).getUsername());
                    Clipboard.getSystemClipboard().setContent((Map)content);
                } else {
                    new Alert(Alert.AlertType.ERROR, "No username available", new ButtonType[0]).showAndWait();
                }
            });
            loginContextManu.getItems().add((Object)copyUsernameMenuItem);
            MenuItem copyPortMenuItem = new MenuItem("Copy port");
            copyPortMenuItem.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.COPY));
            copyPortMenuItem.setOnAction(event -> {
                if (((NodeWithLoginInfo)row.getItem()).getPort() != null) {
                    ClipboardContent content = new ClipboardContent();
                    content.putString(Integer.toString(((NodeWithLoginInfo)row.getItem()).getPort()));
                    Clipboard.getSystemClipboard().setContent((Map)content);
                } else {
                    new Alert(Alert.AlertType.ERROR, "No port available", new ButtonType[0]).showAndWait();
                }
            });
            loginContextManu.getItems().add((Object)copyPortMenuItem);
            row.setContextMenu(loginContextManu);
            return row;
        });
        this.nodesTableView.prefHeightProperty().bind((ObservableValue)Bindings.max((int)100, (ObservableNumberValue)Bindings.size((ObservableList)this.nodesTableView.getItems()).multiply(28).add(27)));
        DoubleBinding nodesTableViewWidthLeft = this.nodesTableView.widthProperty().subtract(4).subtract((ObservableNumberValue)this.loginTableColumn.prefWidthProperty());
        this.nodeNameTableColumn.prefWidthProperty().bind((ObservableValue)nodesTableViewWidthLeft.multiply(0.3));
        this.hostnameTableColumn.prefWidthProperty().bind((ObservableValue)nodesTableViewWidthLeft.multiply(0.3));
        this.portTableColumn.prefWidthProperty().bind((ObservableValue)nodesTableViewWidthLeft.multiply(0.2));
        this.usernameTableColumn.prefWidthProperty().bind((ObservableValue)nodesTableViewWidthLeft.multiply(0.2));
        BooleanBinding addressPoolShouldBeVisible = Bindings.isEmpty((ObservableList)this.addressPoolsTableView.getItems()).not();
        this.addressPoolsTableView.managedProperty().bind((ObservableValue)addressPoolShouldBeVisible);
        this.addressPoolsTableView.visibleProperty().bind((ObservableValue)addressPoolShouldBeVisible);
        this.addressPoolsLabel.managedProperty().bind((ObservableValue)addressPoolShouldBeVisible);
        this.addressPoolsLabel.visibleProperty().bind((ObservableValue)addressPoolShouldBeVisible);
        this.addressPoolClientIdTableColumn.setCellValueFactory(param -> ((AddressPoolIPv4)param.getValue()).getAddressPool().clientIdProperty());
        this.addressPoolTestbedTableColumn.setCellValueFactory(t -> new ReadOnlyStringWrapper(testbedInfoSource.getByUrnExact(((AddressPoolIPv4)t.getValue()).getAddressPool().getComponentManagerId()).getName()));
        this.ipAddressTableColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((AddressPoolIPv4)param.getValue()).getiPv4().getAddress()));
        this.netmaskTableColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((AddressPoolIPv4)param.getValue()).getiPv4().getNetmask()));
        this.addressPoolClientIdTableColumn.prefWidthProperty().bind((ObservableValue)this.addressPoolsTableView.widthProperty().subtract(2).multiply(0.25));
        this.addressPoolTestbedTableColumn.prefWidthProperty().bind((ObservableValue)this.addressPoolsTableView.widthProperty().subtract(2).multiply(0.25));
        this.ipAddressTableColumn.prefWidthProperty().bind((ObservableValue)this.addressPoolsTableView.widthProperty().subtract(2).multiply(0.25));
        this.netmaskTableColumn.prefWidthProperty().bind((ObservableValue)this.addressPoolsTableView.widthProperty().subtract(2).multiply(0.25));
        this.addressPoolsTableView.prefHeightProperty().bind((ObservableValue)Bindings.max((int)100, (ObservableNumberValue)Bindings.size((ObservableList)this.addressPoolsTableView.getItems()).multiply(28).add(27)));
        this.addressPoolsTableView.setRowFactory(param -> {
            TableRow row = new TableRow();
            MenuItem copyAddressMenuItem = new MenuItem("Copy IP Address");
            copyAddressMenuItem.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.COPY));
            copyAddressMenuItem.setOnAction(actionEvent -> {
                ClipboardContent content = new ClipboardContent();
                content.putString(((AddressPoolIPv4)row.getItem()).getiPv4().getAddress());
                Clipboard.getSystemClipboard().setContent((Map)content);
            });
            MenuItem copyNetmaskMenuItem = new MenuItem("Copy Netmask");
            copyNetmaskMenuItem.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.COPY));
            copyNetmaskMenuItem.setOnAction(actionEvent -> {
                ClipboardContent content = new ClipboardContent();
                content.putString(((AddressPoolIPv4)row.getItem()).getiPv4().getNetmask());
                Clipboard.getSystemClipboard().setContent((Map)content);
            });
            ContextMenu contextMenu = new ContextMenu(new MenuItem[]{copyAddressMenuItem, copyNetmaskMenuItem});
            row.setContextMenu(contextMenu);
            return row;
        });
        this.visibleProperty().addListener(observable -> {
            if (this.isVisible() && this.slice != null) {
                this.sliversTableView.itemsProperty().unbind();
                this.updateExperimentPartsTable();
            }
        });
        this.manifestCombobox.setConverter(this.manifestComboboxStringConverter);
        this.manifestCombobox.getItems().add((Object)COMBINED_MANIFEST);
        this.manifestCombobox.getSelectionModel().selectFirst();
        this.manifestCombobox.getSelectionModel().selectedItemProperty().addListener(observable -> this.updateManifestView());
        experiment.addExperimentChangeListener((ExperimentChangeListener)this);
        if (experiment.getSliceOrNull() != null) {
            this.initializeSlice(experiment.getSliceOrNull());
        }
        this.updateExperimentPartsTable();
    }

    private void disableInitializingView() {
        this.initializingBox.setVisible(false);
        this.initializingBox.setManaged(false);
        this.testbedsScrollPane.setVisible(true);
    }

    private void updateNodesTable() {
        ObservableList nodeWithLoginInfos = FXCollections.observableArrayList();
        if (this.slice.getManifestRspec() != null) {
            FXModelRspec modelRspec = (FXModelRspec)this.slice.getManifestRspec().getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
            if (modelRspec != null) {
                for (FXRspecNode node : modelRspec.getNodes()) {
                    List loginServices = this.slice.getManifestRspec().getNodeLoginInfo((RspecNode)node);
                    if (loginServices == null || loginServices.isEmpty()) {
                        nodeWithLoginInfos.add((Object)new RspecNodeWithLoginInfo(node, null));
                        continue;
                    }
                    for (BasicStringRspec.LoginService loginService : loginServices) {
                        nodeWithLoginInfos.add((Object)new RspecNodeWithLoginInfo(node, loginService));
                    }
                }
                FXCollections.sort((ObservableList)nodeWithLoginInfos, Comparator.comparing(NodeWithLoginInfo::getId, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(NodeWithLoginInfo::getHostname, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(NodeWithLoginInfo::getPort, Comparator.nullsLast(Comparator.naturalOrder())).thenComparing(NodeWithLoginInfo::getUsername, Comparator.nullsLast(Comparator.naturalOrder())));
            } else {
                LOG.info("Could not retrieve FXModelRspec from slice.getManifestRspec(). Not initialized yet?");
            }
        } else {
            LOG.info("Could not retrieve manifest from slice.getManifestRspec(). Not initialized yet?");
        }
        this.nodesTableView.getItems().setAll((Collection)nodeWithLoginInfos);
    }

    private void updateAddressPoolsTable() {
        if (this.slice.getManifestRspec() == null || this.slice.getManifestRspec().getModelRspec(ModelRspecType.FX, new ProgressHandler[0]) == null) {
            LOG.warn("Could not retrieve FXModelRspec from slice.getManifestRspec()!");
            this.addressPoolsTableView.getItems().clear();
            return;
        }
        FXModelRspec modelRspec = (FXModelRspec)this.slice.getManifestRspec().getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        ArrayList<AddressPoolIPv4> newAddressPoolIPv4s = new ArrayList<AddressPoolIPv4>();
        if (modelRspec != null) {
            for (FXAddressPool addressPool : modelRspec.getAddressPools()) {
                for (IPv4 iPv4 : addressPool.getIPv4s()) {
                    newAddressPoolIPv4s.add(new AddressPoolIPv4(addressPool, iPv4));
                }
            }
        }
        this.addressPoolsTableView.getItems().setAll(newAddressPoolIPv4s);
    }

    private void updateView() {
        if (this.experiment.isPartsEmpty()) {
            return;
        }
        this.disableInitializingView();
        this.updateNodesTable();
        this.updateAddressPoolsTable();
        Object oldSelection = this.manifestCombobox.getSelectionModel().getSelectedItem();
        ArrayList<Server> manifestAMsList = new ArrayList<Server>((Collection<Server>)this.slice.getManifestComponentManagers());
        manifestAMsList.sort(Comparator.comparing(Server::getName));
        ObservableList allManifests = FXCollections.observableArrayList();
        allManifests.add((Object)COMBINED_MANIFEST);
        allManifests.addAll(manifestAMsList);
        this.manifestCombobox.setItems(allManifests);
        this.manifestCombobox.getSelectionModel().select(oldSelection);
        this.updateManifestView();
    }

    @FXML
    private void updateManifestView() {
        if (this.slice == null || this.slice.getManifestRspec() == null) {
            return;
        }
        assert (Platform.isFxApplicationThread());
        ManifestRspecSource manifestRspecSource = this.slice.getManifestRspec();
        if (!this.manifestCombobox.getSelectionModel().isEmpty() && this.manifestCombobox.getSelectionModel().getSelectedItem() != COMBINED_MANIFEST) {
            assert (this.manifestCombobox.getSelectionModel().getSelectedItem() instanceof Server);
            manifestRspecSource = this.slice.getSpecificManifestRspec((Server)this.manifestCombobox.getSelectionModel().getSelectedItem());
        }
        if (manifestRspecSource != null) {
            this.manifestXmlView.setContent(XmlUtil.formatXmlFromString((String)manifestRspecSource.getRspecXmlString()));
        } else {
            this.manifestXmlView.setContent("No manifest available");
        }
    }

    @FXML
    private void saveManifest() {
        File dir;
        String rspecFolder;
        if (this.slice == null || this.slice.getManifestRspec() == null) {
            return;
        }
        assert (Platform.isFxApplicationThread());
        ManifestRspecSource manifestRspecSource = this.slice.getManifestRspec();
        if (this.manifestCombobox.getSelectionModel().getSelectedItem() != COMBINED_MANIFEST) {
            assert (this.manifestCombobox.getSelectionModel().getSelectedItem() instanceof Server);
            manifestRspecSource = this.slice.getSpecificManifestRspec((Server)this.manifestCombobox.getSelectionModel().getSelectedItem());
        }
        if (manifestRspecSource == null) {
            LOG.warn("No manifest available to save");
            return;
        }
        String selectedTitleString = this.manifestComboboxStringConverter.toString(this.manifestCombobox.getSelectionModel().getSelectedItem());
        String manifestXmlString = XmlUtil.formatXmlFromString((String)manifestRspecSource.getRspecXmlString());
        FileChooser fc = new FileChooser();
        fc.setTitle("Save Manifest RSpec");
        fc.getExtensionFilters().add((Object)FileUtils.MANIFEST_RSPEC_EXTENSION_FILTER);
        fc.setInitialFileName(selectedTitleString + ".mrspec");
        if (System.getProperty("user.home") != null) {
            fc.setInitialDirectory(new File(System.getProperty("user.home")));
        }
        if (this.jFedPreferences.containsPreference((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_MANIFEST)) {
            rspecFolder = this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_MANIFEST);
            assert (rspecFolder != null);
            dir = new File(rspecFolder);
            if (dir.exists()) {
                fc.setInitialDirectory(dir);
            }
        } else if (this.jFedPreferences.containsPreference((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_MANIFEST)) {
            rspecFolder = this.jFedPreferences.getString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_REQUEST);
            assert (rspecFolder != null);
            dir = new File(rspecFolder);
            if (dir.exists()) {
                fc.setInitialDirectory(dir);
            }
        }
        File saveFile = fc.showSaveDialog(this.getScene().getWindow());
        if (saveFile == null) {
            return;
        }
        this.jFedPreferences.setString((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_RSPECFOLDER_MANIFEST, saveFile.getParentFile().getAbsolutePath());
        if (!saveFile.getAbsolutePath().endsWith(".mrspec")) {
            saveFile = new File(saveFile.getAbsolutePath() + ".mrspec");
        }
        final String fileContents = manifestXmlString;
        final File finalSaveFile = saveFile;
        Task<Void> saveTask = new Task<Void>(){

            protected Void call() {
                this.updateMessage("Saving manifest in \"" + finalSaveFile.getAbsolutePath() + "\"");
                try (FileWriter writer = new FileWriter(finalSaveFile);){
                    writer.write(fileContents);
                    writer.flush();
                }
                catch (IOException ex) {
                    LOG.error("Error while saving experiment to file '" + finalSaveFile.getAbsolutePath() + "'", (Throwable)ex);
                    Platform.runLater(() -> JFDialogs.create().owner((Node)RawSliceView.this).message("An error occurred while saving the rspec.").masthead("Error").title("Error").showException((Throwable)ex));
                }
                this.updateMessage("Successfully saved experiment in \"" + finalSaveFile.getAbsolutePath() + "\"");
                return null;
            }
        };
        new Thread((Runnable)saveTask).start();
    }

    @Nullable
    public Slice getSlice() {
        return this.slice;
    }

    private void updateExperimentPartsTable() {
        ArrayList<RawExperimentPart> mergedList = new ArrayList<RawExperimentPart>();
        for (ExperimentPart experimentPart : this.experiment.getPartsListCopy()) {
            if (!(experimentPart instanceof SfaExperimentPart)) continue;
            mergedList.addAll(((SfaExperimentPart)experimentPart).getSlivers().stream().map(x$0 -> new SliverRawExperimentPart((Sliver)x$0)).collect(Collectors.toList()));
        }
        mergedList.sort(Comparator.comparing(RawExperimentPart::getTestbed).thenComparing(RawExperimentPart::getId));
        this.sliversTableView.getItems().setAll(mergedList);
    }

    private void initializeSlice(@Nonnull Slice slice) {
        assert (this.slice == null);
        this.slice = slice;
        LOG.debug("Initializing RawSliceView with slice {}", (Object)slice.getUrn());
        Platform.runLater(() -> {
            this.sliceTableView.getItems().add((Object)slice);
            slice.getObservableSlivers().addListener(observable -> this.updateExperimentPartsTable());
            this.updateExperimentPartsTable();
            this.sliversTableView.prefHeightProperty().bind((ObservableValue)Bindings.max((int)100, (ObservableNumberValue)Bindings.size((ObservableList)this.sliversTableView.getItems()).multiply(28).add(27)));
            slice.manifestRspecProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.manifestInvalidationListener));
            this.updateView();
        });
    }

    public void onExperimentStateChange(ExperimentState newState) {
        if (this.slice == null && newState != ExperimentState.PENDING && this.experiment.getSliceOrNull() != null) {
            assert (this.experiment.getSliceOrNull() != null);
            this.initializeSlice(this.experiment.getSliceOrNull());
        }
    }

    public void onExperimentPartAdded(ExperimentPart experimentPart) {
        Platform.runLater(() -> {
            this.updateView();
            this.updateExperimentPartsTable();
        });
    }

    public StringRspec getRspecXmlString() {
        return null;
    }

    private static class RspecNodeWithLoginInfo
    implements NodeWithLoginInfo {
        private final FXRspecNode rspecNode;
        private final BasicStringRspec.LoginService loginService;

        private RspecNodeWithLoginInfo(FXRspecNode rspecNode, BasicStringRspec.LoginService loginService) {
            this.rspecNode = rspecNode;
            this.loginService = loginService;
        }

        @Override
        public String getId() {
            return this.rspecNode.getClientId();
        }

        @Override
        public String getHostname() {
            return this.loginService != null ? this.loginService.getHostname() : null;
        }

        @Override
        public Integer getPort() {
            return this.loginService != null ? Integer.valueOf(this.loginService.getPort()) : null;
        }

        @Override
        public String getUsername() {
            return this.loginService != null ? this.loginService.getUsername() : null;
        }

        public FXRspecNode getRspecNode() {
            return this.rspecNode;
        }

        public BasicStringRspec.LoginService getLoginService() {
            return this.loginService;
        }
    }

    private static class AddressPoolIPv4 {
        private final FXAddressPool addressPool;
        private final IPv4 iPv4;

        public AddressPoolIPv4(FXAddressPool addressPool, IPv4 iPv4) {
            this.addressPool = addressPool;
            this.iPv4 = iPv4;
        }

        public FXAddressPool getAddressPool() {
            return this.addressPool;
        }

        public IPv4 getiPv4() {
            return this.iPv4;
        }
    }

    public static class SliverRawExperimentPart
    implements RawExperimentPart {
        private final Sliver sliver;

        private SliverRawExperimentPart(Sliver sliver) {
            this.sliver = sliver;
        }

        @Override
        public String getTestbed() {
            return this.sliver.getServer().getName();
        }

        @Override
        public String getId() {
            return this.sliver.getUrnString();
        }

        @Override
        public Instant getExpirationTime() {
            return this.sliver.getExpirationDate();
        }

        public ReadOnlyObjectProperty<Instant> expirationTimeProperty() {
            return this.sliver.expirationDateProperty();
        }

        @Override
        public StatusDetails getStatus() {
            return this.sliver.getStatus();
        }

        public ReadOnlyObjectProperty<StatusDetails> statusProperty() {
            return this.sliver.statusProperty();
        }
    }

    private static interface NodeWithLoginInfo {
        public String getId();

        public String getHostname();

        public Integer getPort();

        public String getUsername();
    }

    private class NodeWithLoginInfoButtonTableCell
    extends TableCell<NodeWithLoginInfo, Boolean> {
        private final Button loginButton = new Button("Login");

        public NodeWithLoginInfoButtonTableCell() {
            this.loginButton.setGraphic((Node)GlyphUtils.createSmallGlyph((FontAwesome.Glyph)FontAwesome.Glyph.TERMINAL, (Color)Color.BLACK));
            this.setGraphic((Node)this.loginButton);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        }

        protected void updateItem(Boolean item, boolean empty) {
            if (!empty) {
                this.loginButton.disableProperty().unbind();
                if (this.getTableRow().getItem() instanceof RspecNodeWithLoginInfo) {
                    RspecNodeWithLoginInfo rspecNodeWithLoginInfo = (RspecNodeWithLoginInfo)this.getTableRow().getItem();
                    this.loginButton.setDisable(item == false);
                    this.loginButton.setOnAction(actionEvent -> RawSliceView.this.sshTerminalUtil.launchSSHTerminal(rspecNodeWithLoginInfo.getLoginService()));
                }
                this.loginButton.setVisible(true);
            } else {
                this.loginButton.setVisible(false);
            }
        }
    }

    public static interface RawExperimentPart {
        public String getTestbed();

        public String getId();

        public Instant getExpirationTime();

        public ObjectExpression<Instant> expirationTimeProperty();

        public StatusDetails getStatus();

        public ObjectExpression<StatusDetails> statusProperty();
    }

    private static class StatusTableCell
    extends TableCell<RawExperimentPart, StatusDetails> {
        private StatusTableCell() {
        }

        private static String statusToStyleClass(StatusDetails status) {
            return StatusTableCell.statusToStyleClass(status.getGlobalStatus());
        }

        private static String statusToStyleClass(StatusDetails.SliverStatus status) {
            switch (status) {
                case READY: {
                    return "testbed-status-ready";
                }
                case CHANGING: {
                    return "testbed-status-changing";
                }
                case NOTREADY: {
                    return "testbed-status-notready";
                }
                case FAIL: {
                    return "testbed-status-fail";
                }
                case UNALLOCATED: {
                    return "testbed-status-unallocated";
                }
                case UNINITIALISED: {
                    return "testbed-status-uninitialised";
                }
                case UNKNOWN: {
                    return "testbed-status-unknown";
                }
            }
            throw new IllegalArgumentException();
        }

        protected void updateItem(StatusDetails item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Update sliver status with {} and {}", (Object)item, (Object)empty);
            }
            for (StatusDetails.SliverStatus s : StatusDetails.SliverStatus.values()) {
                this.getStyleClass().remove((Object)StatusTableCell.statusToStyleClass(s));
            }
            if (empty) {
                this.setText("");
            } else {
                this.setText(item.getGlobalStatus().name());
                this.getStyleClass().add((Object)StatusTableCell.statusToStyleClass(item));
            }
        }
    }
}

