/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.ribbon_tabs;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentViewController;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.EditSshKeysEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.FixSshKeysEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.RebootExperimentEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.RerunEspecEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.RunSshCommandEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.ShareExperimentEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.TestLinkEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.UnshareExperimentEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ribbon_tabs.SliceRibbonTab;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ribbon.RibbonButton;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import com.google.common.eventbus.EventBus;
import java.util.Objects;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.ObservableValueBase;
import javafx.fxml.FXML;
import org.reactfx.value.Val;

public class AdvancedSliceRibbonComponentGroupController {
    private final SliceRibbonTab sliceRibbonTab;
    private final EventBus eventBus;
    private final JFedGuiConfig config;
    @FXML
    private RibbonButton restartExperimentButton;
    @FXML
    private RibbonButton editSshKeysExperimentButton;
    @FXML
    private RibbonButton shareSliceButton;
    @FXML
    private RibbonButton unshareSliceButton;
    @FXML
    private RibbonButton linkTestButton;
    @FXML
    private RibbonButton rerunEspecButton;
    @FXML
    private RibbonButton runSshCommandButton;
    private final boolean isDemo = new JFedHLPreferences().getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_IS_DEMO, false);

    public AdvancedSliceRibbonComponentGroupController(SliceRibbonTab sliceRibbonTab, EventBus eventBus, JFedGuiConfig config) {
        this.sliceRibbonTab = sliceRibbonTab;
        this.eventBus = eventBus;
        this.config = config;
    }

    @FXML
    protected void initialize() {
        if (!this.isDemo && !this.config.isExperimentActionDisabled()) {
            final Val manifestUnavailableVal = Val.map(this.sliceRibbonTab.activeExperimentViewControllerProperty(), ExperimentViewController::getExperiment).flatMap(Experiment::sliceProperty).flatMap(Slice::manifestRspecProperty).map(Objects::isNull).orElseConst((Object)true);
            this.restartExperimentButton.disableProperty().bind((ObservableValue)manifestUnavailableVal);
            this.editSshKeysExperimentButton.disableProperty().bind((ObservableValue)manifestUnavailableVal);
            this.shareSliceButton.disableProperty().bind((ObservableValue)manifestUnavailableVal);
            this.unshareSliceButton.disableProperty().bind((ObservableValue)manifestUnavailableVal);
            ObservableValueBase<Boolean> hasNoLinksVal = new ObservableValueBase<Boolean>(){
                {
                    AdvancedSliceRibbonComponentGroupController.this.sliceRibbonTab.activeExperimentViewControllerProperty().addListener((ob, o, n) -> this.fireValueChangedEvent());
                    manifestUnavailableVal.addListener((ob, o, n) -> this.fireValueChangedEvent());
                }

                public Boolean getValue() {
                    ExperimentViewController evc = (ExperimentViewController)AdvancedSliceRibbonComponentGroupController.this.sliceRibbonTab.activeExperimentViewControllerProperty().getValue();
                    if (evc == null) {
                        return true;
                    }
                    Slice s = evc.getExperiment().getSliceOrNull();
                    if (s == null) {
                        return true;
                    }
                    ManifestRspecSource mrs = s.getManifestRspec();
                    if (mrs == null) {
                        return true;
                    }
                    ImmutableModelRspec mr = mrs.getImmutableModelRspec();
                    if (mr == null) {
                        return true;
                    }
                    return mr.getLinks().isEmpty();
                }
            };
            this.linkTestButton.disableProperty().bind((ObservableValue)hasNoLinksVal);
        } else {
            this.restartExperimentButton.setDisable(true);
            this.editSshKeysExperimentButton.setDisable(true);
            this.shareSliceButton.setDisable(true);
            this.unshareSliceButton.setDisable(true);
            this.linkTestButton.setDisable(true);
        }
    }

    @FXML
    private void onRebootExperimentAction() {
        this.eventBus.post((Object)new RebootExperimentEvent(this.restartExperimentButton.getScene().getWindow(), this.sliceRibbonTab.getActiveExperimentViewController().getExperimentController()));
    }

    @FXML
    private void onFixSshKeysAction() {
        this.eventBus.post((Object)new FixSshKeysEvent(this.editSshKeysExperimentButton.getScene().getWindow(), this.sliceRibbonTab.getActiveExperimentViewController().getExperimentController()));
    }

    @FXML
    private void onEditSshKeysExperimentAction() {
        this.eventBus.post((Object)new EditSshKeysEvent(this.editSshKeysExperimentButton.getScene().getWindow(), this.sliceRibbonTab.getActiveExperimentViewController().getExperimentController()));
    }

    @FXML
    private void onShareSliceAction() {
        this.eventBus.post((Object)new ShareExperimentEvent(this.shareSliceButton.getScene().getWindow(), this.sliceRibbonTab.getActiveExperimentViewController().getExperimentController()));
    }

    @FXML
    private void onUnshareSliceAction() {
        this.eventBus.post((Object)new UnshareExperimentEvent(this.unshareSliceButton.getScene().getWindow(), this.sliceRibbonTab.getActiveExperimentViewController().getExperimentController()));
    }

    @FXML
    private void onTestLinksAction() {
        this.eventBus.post((Object)new TestLinkEvent(this.linkTestButton.getScene().getWindow(), this.sliceRibbonTab.getActiveExperimentViewController().getExperimentController()));
    }

    @FXML
    private void onRerunEspecAction() {
        this.eventBus.post((Object)new RerunEspecEvent(this.rerunEspecButton.getScene().getWindow(), this.sliceRibbonTab.getActiveExperimentViewController().getExperimentController()));
    }

    @FXML
    private void onRunSshCommandAction() {
        this.eventBus.post((Object)new RunSshCommandEvent(this.runSshCommandButton.getScene().getWindow(), this.sliceRibbonTab.getActiveExperimentViewController().getExperimentController()));
    }
}

