/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.ribbon_tabs;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.experimenter_gui.config.JFedGuiConfig;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentViewController;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.RenewExperimentEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.TerminateExperimentEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.events.UpdateExperimentEvent;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ribbon_tabs.SliceRibbonTab;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ribbon.RibbonButton;
import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.gui_preferences.JFedHLPreferences;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import com.google.common.eventbus.EventBus;
import java.util.Objects;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import org.reactfx.value.Val;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericSliceRibbonComponentGroupController {
    private static final Logger LOG = LoggerFactory.getLogger(GenericSliceRibbonComponentGroupController.class);
    private final SliceRibbonTab sliceRibbonTab;
    private final JFedGuiConfig guiConfig;
    @FXML
    private RibbonButton updateExperimentButton;
    @FXML
    private RibbonButton renewSliceButton;
    @FXML
    private RibbonButton stopExperimentButton;
    private final EventBus eventBus;
    private final boolean isDemo = new JFedHLPreferences().getBoolean((JFedPreferences.PreferenceKey)HLPreferenceKey.PREF_IS_DEMO, false);

    public GenericSliceRibbonComponentGroupController(SliceRibbonTab sliceRibbonTab, EventBus eventBus, JFedGuiConfig guiConfig) {
        this.sliceRibbonTab = sliceRibbonTab;
        this.eventBus = eventBus;
        this.guiConfig = guiConfig;
    }

    @FXML
    protected void initialize() {
        Val experimentVal = Val.map(this.sliceRibbonTab.activeExperimentViewControllerProperty(), ExperimentViewController::getExperiment);
        Val sliceIsNullVal = experimentVal.flatMap(Experiment::sliceProperty).map(Objects::isNull).orElseConst((Object)true);
        this.updateExperimentButton.disableProperty().bind((ObservableValue)sliceIsNullVal);
        if (!this.isDemo && !this.guiConfig.isExperimentDeleteDisabled()) {
            Val terminatedVal = experimentVal.flatMap(Experiment::experimentStateProperty).map(ExperimentState::isTerminated);
            Val sliceIsNullOrTerminatingVal = sliceIsNullVal.orElse((ObservableValue)terminatedVal);
            this.renewSliceButton.disableProperty().bind((ObservableValue)sliceIsNullOrTerminatingVal);
            this.stopExperimentButton.disableProperty().bind((ObservableValue)sliceIsNullOrTerminatingVal);
        } else {
            this.renewSliceButton.setDisable(true);
            this.stopExperimentButton.setDisable(true);
        }
    }

    @FXML
    public void onUpdateExperimentAction() {
        this.eventBus.post((Object)new UpdateExperimentEvent(this.updateExperimentButton.getScene().getWindow(), this.sliceRibbonTab.getActiveExperimentViewController().getExperimentController()));
    }

    @FXML
    public void onStopExperimentAction() {
        LOG.info("User clicked Terminate button in generic slice ribbon");
        this.eventBus.post((Object)new TerminateExperimentEvent(this.updateExperimentButton.getScene().getWindow(), this.sliceRibbonTab.getActiveExperimentViewController().getExperimentController()));
    }

    @FXML
    private void onRenewSliceAction() {
        this.eventBus.post((Object)new RenewExperimentEvent(this.updateExperimentButton.getScene().getWindow(), this.sliceRibbonTab.getActiveExperimentViewController().getExperimentController()));
    }
}

