/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.ribbon_tabs;

import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentViewController;
import be.iminds.ilabt.jfed.experimenter_gui.slice.ExperimentViewControllerTab;
import be.iminds.ilabt.jfed.experimenter_gui.ui.ribbon.RibbonTab;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javax.annotation.Nonnull;

public abstract class SliceRibbonTab
extends RibbonTab {
    protected final ObjectProperty<ExperimentViewController> activeExperimentViewController = new SimpleObjectProperty();

    public SliceRibbonTab() {
        InvalidationListener sliceStateInvalidationListener = observable -> Platform.runLater(this::updateTabStyle);
        WeakInvalidationListener weakSliceStateInvalidationListener = new WeakInvalidationListener(sliceStateInvalidationListener);
        this.activeExperimentViewControllerProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.getExperiment().experimentStateProperty().removeListener((InvalidationListener)weakSliceStateInvalidationListener);
            }
            if (newValue != null) {
                Platform.runLater(this::updateTabStyle);
                newValue.getExperiment().experimentStateProperty().addListener((InvalidationListener)weakSliceStateInvalidationListener);
            }
        });
    }

    public ExperimentViewController getActiveExperimentViewController() {
        return (ExperimentViewController)this.activeExperimentViewController.get();
    }

    public void setActiveExperimentViewController(ExperimentViewController activeExperimentViewController) {
        this.activeExperimentViewController.set((Object)activeExperimentViewController);
    }

    @Nonnull
    public ObjectProperty<ExperimentViewController> activeExperimentViewControllerProperty() {
        return this.activeExperimentViewController;
    }

    private void updateTabStyle() {
        ExperimentViewControllerTab.TabStyle.updateTabStyle(this, ((ExperimentViewController)this.activeExperimentViewController.get()).getExperiment().getExperimentState());
    }
}

