/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.scp;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.SshConnectionPool;
import be.iminds.ilabt.jfed.experiment.SshConnectionPoolFactory;
import be.iminds.ilabt.jfed.experimenter_gui.slice.scp.SCPTask;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import java.io.IOException;
import javafx.application.Platform;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.xfer.TransferListener;
import net.schmizz.sshj.xfer.scp.SCPFileTransfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCPDownloadTask
extends SCPTask {
    private static final Logger LOG = LoggerFactory.getLogger(SCPDownloadTask.class);
    private final String remotePath;
    private final String localPath;
    private final LongProperty size = new SimpleLongProperty();
    private final SshConnectionPoolFactory sshConnectionPoolFactory;

    public SCPDownloadTask(Experiment experiment, FXRspecNode node, String remotePath, String localPath, SshConnectionPoolFactory sshConnectionPoolFactory) {
        super(experiment, node);
        this.sshConnectionPoolFactory = sshConnectionPoolFactory;
        this.localPath = localPath;
        this.remotePath = remotePath;
        this.updateTitle("Download '" + remotePath + "' to '" + localPath + "' on " + node.getClientId());
    }

    public Boolean call() throws Exception {
        SshConnectionPool sshConnectionPool = this.sshConnectionPoolFactory.getSshConnectionPool(this.experiment);
        SSHClient ssh = sshConnectionPool.getConnection(this.node.getUniqueId(), SshConnectionPool.BlockingMode.WAIT_FOR_SINGLE);
        if (ssh != null) {
            SCPFileTransfer fileTransfer = ssh.newSCPFileTransfer();
            fileTransfer.setTransferListener(new TransferListener(){

                public TransferListener directory(String name) {
                    SCPDownloadTask.this.updateMessage("Downloading directory '" + name + "'");
                    return this;
                }

                public StreamCopier.Listener file(String name, long size) {
                    Platform.runLater(() -> SCPDownloadTask.this.size.set(SCPDownloadTask.this.size.get() + size));
                    SCPDownloadTask.this.updateMessage("Downloading '" + name + "' (" + size + " bytes)");
                    return transferred -> {
                        SCPDownloadTask.this.updateMessage(String.format("Transferred %d%% of " + name, transferred * 100L / size));
                        SCPDownloadTask.this.updateProgress(transferred, size);
                    };
                }
            });
            try {
                fileTransfer.download(this.remotePath, this.localPath);
                Boolean bl = true;
                return bl;
            }
            catch (IOException ex) {
                this.updateMessage("Error while downloading: " + ex.getMessage());
                LOG.error("Error while downloading {}", (Object)this.remotePath, (Object)ex);
                throw ex;
            }
            finally {
                ssh.close();
            }
        }
        this.updateMessage("Could not establish a connection to " + this.node.getClientId());
        throw new RuntimeException("Could not establish a connection to " + this.node.getClientId());
    }

    @Override
    public FXRspecNode getNode() {
        return this.node;
    }

    @Override
    public String getLocalPath() {
        return this.localPath;
    }

    @Override
    public String getRemotePath() {
        return this.remotePath;
    }

    @Override
    public LongProperty sizeProperty() {
        return this.size;
    }
}

