/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.scp;

import be.iminds.ilabt.jfed.experimenter_gui.slice.scp.SCPDownloadTask;
import be.iminds.ilabt.jfed.experimenter_gui.slice.scp.SCPTask;
import be.iminds.ilabt.jfed.experimenter_gui.slice.scp.SCPUploadTask;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import java.text.DecimalFormat;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Worker;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Tab;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.layout.HBox;
import org.controlsfx.glyphfont.FontAwesome;

public class SCPTab
extends Tab {
    private final TableView<SCPTask> tableView;

    public SCPTab() {
        this.setText("SCP");
        this.setGraphic((Node)GlyphUtils.createGlyph((FontAwesome.Glyph)FontAwesome.Glyph.UPLOAD));
        this.tableView = new TableView();
        TableColumn actionTypeTableColumn = new TableColumn("Operation");
        actionTypeTableColumn.setMaxWidth(2.147483648E10);
        actionTypeTableColumn.setCellValueFactory(param -> {
            if (param.getValue() instanceof SCPUploadTask) {
                return new ReadOnlyStringWrapper("Upload");
            }
            if (param.getValue() instanceof SCPDownloadTask) {
                return new ReadOnlyStringWrapper("Download");
            }
            return new ReadOnlyStringWrapper("");
        });
        this.tableView.getColumns().add((Object)actionTypeTableColumn);
        TableColumn localTableColumn = new TableColumn("Local");
        localTableColumn.setMaxWidth(6.442450944E10);
        localTableColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((SCPTask)((Object)((Object)param.getValue()))).getLocalPath()));
        this.tableView.getColumns().add((Object)localTableColumn);
        TableColumn remoteTableColumn = new TableColumn("Remote");
        remoteTableColumn.setMaxWidth(6.442450944E10);
        remoteTableColumn.setCellValueFactory(param -> new ReadOnlyStringWrapper(((SCPTask)((Object)((Object)param.getValue()))).getRemotePath()));
        this.tableView.getColumns().add((Object)remoteTableColumn);
        TableColumn sizeTableColumn = new TableColumn("Size");
        sizeTableColumn.setMaxWidth(2.7917287424E10);
        sizeTableColumn.setCellValueFactory(param -> ((SCPTask)((Object)((Object)param.getValue()))).sizeProperty().asObject());
        sizeTableColumn.setCellFactory(param -> new FilesizeTableCell());
        this.tableView.getColumns().add((Object)sizeTableColumn);
        TableColumn progressTableColumn = new TableColumn("Status");
        progressTableColumn.setMinWidth(75.0);
        progressTableColumn.setMaxWidth(3.221225472E10);
        progressTableColumn.setCellValueFactory(param -> new ReadOnlyObjectWrapper((Object)((SCPTask)((Object)((Object)param.getValue())))));
        progressTableColumn.setCellFactory(param -> new StatusTableCell());
        this.tableView.getColumns().add((Object)progressTableColumn);
        this.tableView.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        this.setContent((Node)this.tableView);
        this.setClosable(false);
    }

    public void registerSCPTask(SCPTask task) {
        this.tableView.getItems().add((Object)task);
    }

    private static class StatusTableCell
    extends TableCell<SCPTask, SCPTask> {
        private final HBox content = new HBox(5.0);
        private final ProgressBar progressBar = new ProgressBar();
        private final Button cancelButton = new Button("Cancel");
        private final Label resultLabel = new Label();

        private StatusTableCell() {
            this.progressBar.managedProperty().bind((ObservableValue)this.progressBar.visibleProperty());
            this.cancelButton.managedProperty().bind((ObservableValue)this.cancelButton.visibleProperty());
            this.resultLabel.managedProperty().bind((ObservableValue)this.resultLabel.visibleProperty());
            this.content.getChildren().addAll((Object[])new Node[]{this.progressBar, this.cancelButton, this.resultLabel});
            this.cancelButton.setOnAction(event -> {
                ((SCPTask)((Object)((Object)this.getTableRow().getItem()))).cancel(true);
                ((SCPTask)((Object)((Object)this.getTableRow().getItem()))).stateProperty().isEqualTo((Object)Worker.State.CANCELLED);
            });
        }

        public void updateItem(SCPTask item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty) {
                this.setGraphic(null);
            } else {
                this.progressBar.progressProperty().unbind();
                this.progressBar.progressProperty().bind((ObservableValue)item.progressProperty());
                this.progressBar.visibleProperty().unbind();
                this.progressBar.visibleProperty().bind((ObservableValue)item.runningProperty());
                this.cancelButton.visibleProperty().unbind();
                this.cancelButton.visibleProperty().bind((ObservableValue)item.runningProperty());
                this.cancelButton.disableProperty().unbind();
                this.cancelButton.disableProperty().bind((ObservableValue)item.stateProperty().isNotEqualTo((Object)Worker.State.RUNNING));
                this.resultLabel.visibleProperty().unbind();
                this.resultLabel.visibleProperty().bind((ObservableValue)item.runningProperty().not());
                this.resultLabel.textProperty().unbind();
                this.resultLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
                    switch (item.getState()) {
                        case SUCCEEDED: {
                            return "Success";
                        }
                        case CANCELLED: {
                            return "Cancelled";
                        }
                        case FAILED: {
                            return "Failed";
                        }
                        case READY: 
                        case SCHEDULED: {
                            return "Pending";
                        }
                    }
                    return "Unknown";
                }, (Observable[])new Observable[]{item.stateProperty()}));
                this.setGraphic((Node)this.content);
            }
        }
    }

    private static class FilesizeTableCell
    extends TableCell<SCPTask, Long> {
        protected static final String[] UNITS = new String[]{"B", "kB", "MB", "GB", "TB", "EB"};

        private FilesizeTableCell() {
        }

        protected void updateItem(Long item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (!empty) {
                this.setText(FilesizeTableCell.readableFileSize(item));
            } else {
                this.setText("");
            }
        }

        public static String readableFileSize(long size) {
            if (size <= 0L) {
                return "0";
            }
            int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
            return new DecimalFormat("#,##0.##").format((double)size / Math.pow(1024.0, digitGroups)) + " " + UNITS[digitGroups];
        }
    }
}

