/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.scp;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.SshConnectionPool;
import be.iminds.ilabt.jfed.experiment.SshConnectionPoolFactory;
import be.iminds.ilabt.jfed.experimenter_gui.slice.scp.SCPTask;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import java.io.IOException;
import javafx.application.Platform;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.common.StreamCopier;
import net.schmizz.sshj.xfer.FileSystemFile;
import net.schmizz.sshj.xfer.LocalSourceFile;
import net.schmizz.sshj.xfer.TransferListener;
import net.schmizz.sshj.xfer.scp.SCPFileTransfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCPUploadTask
extends SCPTask {
    private static final Logger LOG = LoggerFactory.getLogger(SCPUploadTask.class);
    private final String localPath;
    private final String remotePath;
    private final LongProperty size = new SimpleLongProperty();
    private final SshConnectionPoolFactory sshConnectionPoolFactory;

    public SCPUploadTask(Experiment experiment, FXRspecNode node, String localPath, String remotePath, SshConnectionPoolFactory sshConnectionPoolFactory) {
        super(experiment, node);
        this.localPath = localPath;
        this.remotePath = remotePath;
        this.sshConnectionPoolFactory = sshConnectionPoolFactory;
        this.updateTitle("Upload '" + localPath + "' to '" + remotePath + "' on " + node.getClientId());
    }

    public Boolean call() throws Exception {
        SshConnectionPool sshConnectionPool = this.sshConnectionPoolFactory.getSshConnectionPool(this.experiment);
        SSHClient ssh = sshConnectionPool.getConnection(this.node.getUniqueId(), SshConnectionPool.BlockingMode.WAIT_FOR_SINGLE);
        if (ssh != null) {
            SCPFileTransfer fileTransfer = ssh.newSCPFileTransfer();
            fileTransfer.setTransferListener(new TransferListener(){

                public TransferListener directory(String name) {
                    LOG.debug("Uploading dir {}", (Object)name);
                    SCPUploadTask.this.updateMessage("Uploading directory '" + name + "'");
                    return this;
                }

                public StreamCopier.Listener file(String name, long size) {
                    Platform.runLater(() -> SCPUploadTask.this.size.set(SCPUploadTask.this.size.get() + size));
                    LOG.debug("Uploading {} (size: {} bytes)", (Object)name, (Object)size);
                    SCPUploadTask.this.updateMessage("Uploading '" + name + "' (" + size + " bytes)");
                    return transferred -> {
                        SCPUploadTask.this.updateMessage(String.format("Transferred %d%% of " + name, transferred * 100L / size));
                        SCPUploadTask.this.updateProgress(transferred, size);
                    };
                }
            });
            try {
                fileTransfer.upload((LocalSourceFile)new FileSystemFile(this.localPath), this.remotePath);
                Boolean bl = true;
                return bl;
            }
            catch (IOException ex) {
                this.updateMessage("Error while uploading: " + ex.getMessage());
                LOG.error("Error while uploading {}", (Object)this.localPath, (Object)ex);
                throw ex;
            }
            finally {
                ssh.close();
            }
        }
        this.updateMessage("Could not establish a connection to " + this.node.getClientId());
        throw new RuntimeException("Could not establish a connection to " + this.node.getClientId());
    }

    @Override
    public String getLocalPath() {
        return this.localPath;
    }

    @Override
    public String getRemotePath() {
        return this.remotePath;
    }

    @Override
    public LongProperty sizeProperty() {
        return this.size;
    }
}

