/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experimenter_gui.slice.state_listeners;

import be.iminds.ilabt.jfed.highlevel.jobs.CreateDiskImageJob;
import be.iminds.ilabt.jfed.highlevel.jobs.StateFinishedListener;
import be.iminds.ilabt.jfed.highlevel.tasks.CreateImageTask;
import be.iminds.ilabt.jfed.ui.javafx.GlyphUtils;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import org.controlsfx.glyphfont.FontAwesome;

public class CreateDiskImageStateListener
implements StateFinishedListener<CreateDiskImageJob.CreateImageState> {
    public void onStateFinished(CreateDiskImageJob.CreateImageState state) {
        CreateImageTask createImageTask = (CreateImageTask)state.getTask();
        CreateDiskImageStateListener.showImageInfoDialog(createImageTask);
    }

    public static void showImageInfoDialog(CreateImageTask createImageTask) {
        VBox container = new VBox();
        container.setSpacing(5.0);
        Label label = new Label("Your disk image is currently being created. This process typically takes around 15 minutes. You will receive an e-mail when the disk image is ready.\n\nIf you want to use the image on a different testbed then the current, use the following RSpec snippet:");
        TextArea textArea = new TextArea();
        textArea.setText(String.format("<sliver_type name=\"raw-pc\">\n\t<disk_image name=\"%s\"/>\n</sliver_type>", createImageTask.getResultDiskImageUrl()));
        textArea.setPrefRowCount(3);
        textArea.setPrefColumnCount(40);
        textArea.setEditable(false);
        textArea.setMinHeight(85.0);
        Label label2 = new Label("If however, you want to use this image on the same testbed, it is better to use:");
        TextArea textArea2 = new TextArea();
        textArea2.setText(String.format("<sliver_type name=\"raw-pc\">\n\t<disk_image name=\"%s\"/>\n</sliver_type>", createImageTask.getResultDiskImageUrn()));
        textArea2.setPrefRowCount(3);
        textArea2.setPrefColumnCount(40);
        textArea2.setEditable(false);
        textArea2.setMinHeight(85.0);
        container.getChildren().addAll((Object[])new Node[]{label, textArea, label2, textArea2});
        DialogPane dialogPane = new DialogPane();
        dialogPane.setContent((Node)container);
        dialogPane.setHeaderText("Your Disk Image is being prepared");
        dialogPane.setGraphic((Node)GlyphUtils.createDialogGlyph((FontAwesome.Glyph)FontAwesome.Glyph.HDD_ALT, (Color)Color.GRAY));
        dialogPane.getButtonTypes().setAll((Object[])new ButtonType[]{ButtonType.OK});
        Dialog dialog = new Dialog();
        dialog.setTitle("Your Disk Image is being prepared");
        dialog.setDialogPane(dialogPane);
        dialog.show();
    }
}

